/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.drain;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.common.ReplicaUpdatePolicies;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.common.xloc.ReplicationFlags;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.drain.OSDDrainException;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class OSDDrain {
    private DIRClient dirClient;
    private OSDServiceClient osdClient;
    private ServiceUUID osdUUID;
    private MRCServiceClient mrcClient;
    private List<FileInformation> fileInfos;
    private RPC.UserCredentials userCreds = RPCAuthentication.userService;
    private RPC.Auth password;
    private UUIDResolver resolver;

    public OSDDrain(DIRClient dirClient, OSDServiceClient osdClient, MRCServiceClient mrcClient, ServiceUUID osdUUID, RPC.Auth password, RPC.UserCredentials usercreds, UUIDResolver resolver) throws Exception {
        this.dirClient = dirClient;
        this.osdClient = osdClient;
        this.osdUUID = osdUUID;
        this.mrcClient = mrcClient;
        this.password = password;
        this.userCreds = usercreds;
        this.resolver = resolver;
    }

    public void drain(boolean shutdown) {
        try {
            this.setServiceStatus(DIR.ServiceStatus.SERVICE_STATUS_TO_BE_REMOVED);
            this.fileInfos = this.getFileListOfOSD();
            this.updateMRCAddresses(this.fileInfos);
            this.fileInfos = this.removeNonExistingFileIDs(this.fileInfos);
            this.fileInfos = this.getReplicaInfo(this.fileInfos);
            this.fileInfos = this.drainCoordinatedFiles(this.fileInfos);
            this.fileInfos = this.setReplicationUpdatePolicyRonly(this.fileInfos);
            this.fileInfos = this.setFilesReadOnlyAttribute(this.fileInfos);
            this.fileInfos = this.createReplicasForFiles(this.fileInfos);
            this.fileInfos = this.startReplication(this.fileInfos);
            this.fileInfos = this.waitForReplicationToComplete(this.fileInfos);
            this.removeOriginalFromReplica(this.fileInfos);
            this.resetFilesReadOnlyAttribute(this.fileInfos);
            this.resetReplicationUpdatePolicy(this.fileInfos);
            if (shutdown) {
                this.shutdownOsd();
            } else {
                System.out.println("The OSD is now locked and objects stored on it copied to other OSDs. It is save to shutdown this OSD now!");
            }
        }
        catch (OSDDrainException e) {
            this.handleException(e, true);
            try {
                this.setServiceStatus(DIR.ServiceStatus.SERVICE_STATUS_AVAIL);
            }
            catch (OSDDrainException e1) {
                this.handleException(e1, true);
                System.out.println("Service Status couldn't set back to AVAILABLE. You have to do this yourself.");
            }
        }
    }

    public void setServiceStatus(DIR.ServiceStatus status) throws OSDDrainException {
        DIR.Service serv;
        String serviceStatus;
        DIR.ServiceSet sSet = null;
        try {
            sSet = this.dirClient.xtreemfs_service_get_by_uuid(null, RPCAuthentication.authNone, RPCAuthentication.userService, this.osdUUID.toString());
        }
        catch (Exception e) {
            Logging.logError(4, this, e);
            throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.SET_SERVICE_STATUS);
        }
        if (sSet.getServicesCount() == 0) {
            System.out.println("no OSD with UUID " + this.osdUUID + " registered at directory service");
            System.exit(1);
        }
        if ((serviceStatus = KeyValuePairs.getValue((serv = sSet.getServices(0)).getData().getDataList(), "static.status")) == null) {
            System.out.println("Service " + this.osdUUID + " is not registered at DIR.");
            System.exit(3);
        }
        if (Integer.valueOf(serviceStatus).intValue() == status.getNumber()) {
            Logging.logMessage(7, Logging.Category.tool, status, "Service %s is already in status %s ", this.osdUUID, status.name());
            return;
        }
        List<GlobalTypes.KeyValuePair> data = serv.getData().getDataList();
        LinkedList<GlobalTypes.KeyValuePair> data2 = new LinkedList<GlobalTypes.KeyValuePair>();
        for (GlobalTypes.KeyValuePair kvp : data) {
            data2.add(GlobalTypes.KeyValuePair.newBuilder().setKey(kvp.getKey()).setValue(kvp.getValue()).build());
        }
        KeyValuePairs.putValue(data2, "static.status", Integer.toString(status.ordinal()));
        KeyValuePairs.putValue(data2, "static.do_not_set_last_updated", Boolean.toString(true));
        DIR.ServiceDataMap dataMap = DIR.ServiceDataMap.newBuilder().addAllData(data2).build();
        serv = serv.toBuilder().setData(dataMap).build();
        try {
            this.dirClient.xtreemfs_service_register(null, RPCAuthentication.authNone, RPCAuthentication.userService, serv);
        }
        catch (Exception e) {
            if (Logging.isDebug()) {
                Logging.logError(4, this, e);
            }
            throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.SET_SERVICE_STATUS);
        }
    }

    public LinkedList<FileInformation> getFileListOfOSD() throws OSDDrainException {
        LinkedList<FileInformation> osdFileList = new LinkedList<FileInformation>();
        RPCResponse<OSD.xtreemfs_internal_get_fileid_listResponse> resp = null;
        OSD.xtreemfs_internal_get_fileid_listResponse fileIDList = null;
        try {
            resp = this.osdClient.xtreemfs_internal_get_fileid_list(this.osdUUID.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService);
            fileIDList = resp.get();
        }
        catch (Exception e) {
            if (Logging.isDebug()) {
                Logging.logError(4, this, e);
            }
            throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.GET_FILE_LIST);
        }
        finally {
            if (resp != null) {
                resp.freeBuffers();
            }
        }
        for (String fileID : fileIDList.getFileIdsList()) {
            FileInformation info = new FileInformation();
            info.fileID = fileID;
            osdFileList.push(info);
        }
        return osdFileList;
    }

    public void updateMRCAddresses(List<FileInformation> fileInfos) throws OSDDrainException {
        for (FileInformation fileInfo : fileInfos) {
            String volumeUUID = fileInfo.fileID.substring(0, fileInfo.fileID.indexOf(58));
            DIR.ServiceSet sSet = null;
            String mrcUUIDString = null;
            try {
                sSet = this.dirClient.xtreemfs_service_get_by_uuid(null, this.password, this.userCreds, volumeUUID);
                for (GlobalTypes.KeyValuePair kvp : sSet.getServices(0).getData().getDataList()) {
                    if (!kvp.getKey().equals("mrc")) continue;
                    mrcUUIDString = kvp.getValue();
                }
                assert (mrcUUIDString != null);
            }
            catch (Exception e) {
                if (Logging.isDebug()) {
                    Logging.logError(4, this, e);
                }
                throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.UPDATE_MRC_ADDRESSES);
            }
            try {
                DIR.AddressMappingSet ams = this.dirClient.xtreemfs_address_mappings_get(null, this.password, this.userCreds, mrcUUIDString);
                assert (ams != null);
                assert (ams.getMappings(0).getUuid().equalsIgnoreCase(mrcUUIDString));
                InetAddress inetAddr = InetAddress.getByName(ams.getMappings(0).getAddress());
                fileInfo.mrcAddress = new InetSocketAddress(inetAddr, ams.getMappings(0).getPort());
            }
            catch (Exception e) {
                if (Logging.isDebug()) {
                    Logging.logError(4, this, e);
                }
                throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.UPDATE_MRC_ADDRESSES);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileInformation> removeNonExistingFileIDs(List<FileInformation> fileInfos) {
        LinkedList<FileInformation> returnList = new LinkedList<FileInformation>();
        HashMap callMap = new HashMap();
        HashMap<String, InetSocketAddress> volIDMrcAddressMapping = new HashMap<String, InetSocketAddress>();
        for (FileInformation fileInfo : fileInfos) {
            String volumeID = fileInfo.fileID.substring(0, fileInfo.fileID.indexOf(58));
            if (!callMap.containsKey(volumeID)) {
                callMap.put(volumeID, new LinkedList());
                volIDMrcAddressMapping.put(volumeID, fileInfo.mrcAddress);
            }
            ((List)callMap.get(volumeID)).add(fileInfo);
        }
        MRC.xtreemfs_check_file_existsRequest.Builder fileExistsRequest = null;
        for (Map.Entry entry : callMap.entrySet()) {
            fileExistsRequest = MRC.xtreemfs_check_file_existsRequest.newBuilder().setVolumeId((String)entry.getKey()).setOsdUuid(this.osdUUID.toString());
            for (FileInformation fi : (List)entry.getValue()) {
                fileExistsRequest.addFileIds(fi.fileID.substring(fi.fileID.indexOf(":") + 1));
            }
            RPCResponse<MRC.xtreemfs_check_file_existsResponse> r = null;
            MRC.xtreemfs_check_file_existsResponse response = null;
            try {
                r = this.mrcClient.xtreemfs_check_file_exists((InetSocketAddress)volIDMrcAddressMapping.get(entry.getKey()), this.password, this.userCreds, fileExistsRequest.build());
                response = r.get();
            }
            catch (Exception e) {
                if (Logging.isDebug()) {
                    Logging.logError(4, this, e);
                }
            }
            finally {
                if (r != null) {
                    r.freeBuffers();
                }
            }
            assert (response.getVolumeExists());
            for (int i = 0; i < response.getFileStatesCount(); ++i) {
                if (response.getFileStates(i) != MRC.xtreemfs_check_file_existsResponse.FILE_STATE.REGISTERED) continue;
                returnList.add((FileInformation)((List)entry.getValue()).get(i));
            }
        }
        return returnList;
    }

    public List<FileInformation> getReplicaInfo(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            RPCResponse<GlobalTypes.XLocSet> xlocsetResp = null;
            GlobalTypes.XLocSet xlocset = null;
            try {
                MRC.xtreemfs_get_xlocsetRequest xlocReq = MRC.xtreemfs_get_xlocsetRequest.newBuilder().setFileId(fileInfo.fileID).build();
                xlocsetResp = this.mrcClient.xtreemfs_get_xlocset(fileInfo.mrcAddress, this.password, this.userCreds, xlocReq);
                xlocset = xlocsetResp.get();
            }
            catch (Exception e) {
                if (Logging.isDebug()) {
                    Logging.logError(4, this, e);
                }
                throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.GET_REPLICA_INFO, fileInfos, finishedFileInfos);
            }
            finally {
                if (xlocsetResp != null) {
                    xlocsetResp.freeBuffers();
                }
            }
            fileInfo.isReplicaChangeCoordinated = xlocset.getReplicasCount() > 1 && ReplicaUpdatePolicies.isRwReplicated(xlocset.getReplicaUpdatePolicy());
            for (GlobalTypes.Replica replica : xlocset.getReplicasList()) {
                if (!replica.getOsdUuidsList().contains(this.osdUUID.toString())) continue;
                fileInfo.oldReplica = replica;
            }
            assert (fileInfo.oldReplica != null);
            finishedFileInfos.add(fileInfo);
        }
        return finishedFileInfos;
    }

    public List<FileInformation> drainCoordinatedFiles(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> uncoordinatedFiles = new LinkedList<FileInformation>();
        LinkedList<FileInformation> finishedFiles = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            if (!fileInfo.isReplicaChangeCoordinated) {
                uncoordinatedFiles.add(fileInfo);
                continue;
            }
            try {
                GlobalTypes.Replica replica;
                fileInfo.newReplica = replica = this.createReplicaForFile(fileInfo);
            }
            catch (OSDDrainException e) {
                String message = "Could not create a replica for file with id: " + fileInfo.fileID + "\n" + "It is safe to call xtfs_remove_osd again.\n" + "Original error was:\n" + e.getMessage();
                throw new OSDDrainException(message, OSDDrainException.ErrorState.DRAIN_COORDINATED);
            }
            try {
                this.addReplicaToFile(fileInfo, fileInfo.newReplica);
            }
            catch (OSDDrainException e) {
                String message = "Could not add replica for file with id: " + fileInfo.fileID + "\n" + "It is safe to call xtfs_remove_osd again.\n" + "Original error was:\n" + e.getMessage();
                throw new OSDDrainException(message, OSDDrainException.ErrorState.DRAIN_COORDINATED);
            }
            try {
                this.removeReplica(fileInfo, fileInfo.oldReplica);
            }
            catch (OSDDrainException e) {
                String message = "Could not remove the replica for file with id: " + fileInfo.fileID + " from the OSD: " + this.osdUUID.toString() + "\n" + "It is NOT SAFE to call xtfs_remove_osd again. Please remove the replica manually before " + "continuing.\n" + "Original error was:\n" + e.getMessage();
                throw new OSDDrainException(message, OSDDrainException.ErrorState.DRAIN_COORDINATED);
            }
            finishedFiles.add(fileInfo);
        }
        return uncoordinatedFiles;
    }

    public List<FileInformation> createReplicasForFiles(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            try {
                GlobalTypes.Replica replica;
                fileInfo.newReplica = replica = this.createReplicaForFile(fileInfo);
                this.addReplicaToFile(fileInfo, replica);
                finishedFileInfos.add(fileInfo);
            }
            catch (OSDDrainException e) {
                throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.CREATE_REPLICAS, fileInfos, finishedFileInfos);
            }
        }
        return finishedFileInfos;
    }

    private GlobalTypes.Replica createReplicaForFile(FileInformation fileInfo) throws OSDDrainException {
        MRC.xtreemfs_get_suitable_osdsResponse suitable_osdsResponse;
        RPCResponse<MRC.xtreemfs_get_suitable_osdsResponse> suitable_osdsResponseRPCResponse = null;
        try {
            MRC.xtreemfs_get_suitable_osdsRequest suitable_osdsRequest = MRC.xtreemfs_get_suitable_osdsRequest.newBuilder().setFileId(fileInfo.fileID).setNumOsds(1).build();
            suitable_osdsResponseRPCResponse = this.mrcClient.xtreemfs_get_suitable_osds(fileInfo.mrcAddress, this.password, this.userCreds, suitable_osdsRequest);
            suitable_osdsResponse = suitable_osdsResponseRPCResponse.get();
        }
        catch (Exception e) {
            if (Logging.isDebug()) {
                Logging.logError(4, this, e);
            }
            throw new OSDDrainException("Could not get suitable OSDs for file with id: " + fileInfo.fileID, OSDDrainException.ErrorState.CREATE_REPLICAS);
        }
        finally {
            if (suitable_osdsResponseRPCResponse != null) {
                suitable_osdsResponseRPCResponse.freeBuffers();
            }
        }
        if (suitable_osdsResponse.getOsdUuidsCount() == 0) {
            throw new OSDDrainException("No suitable OSDs to replicate file with id: " + fileInfo.fileID, OSDDrainException.ErrorState.CREATE_REPLICAS);
        }
        GlobalTypes.StripingPolicy oldSP = fileInfo.oldReplica.getStripingPolicy();
        GlobalTypes.StripingPolicy newSP = GlobalTypes.StripingPolicy.newBuilder().setType(oldSP.getType()).setStripeSize(oldSP.getStripeSize()).setWidth(1).build();
        GlobalTypes.Replica.Builder replica = GlobalTypes.Replica.newBuilder().addOsdUuids(suitable_osdsResponse.getOsdUuids(0)).setStripingPolicy(newSP);
        if (fileInfo.isReplicaChangeCoordinated) {
            replica.setReplicationFlags(0);
        } else {
            replica.setReplicationFlags(ReplicationFlags.setRandomStrategy(ReplicationFlags.setFullReplica(0)));
        }
        return replica.build();
    }

    private void addReplicaToFile(FileInformation fileInfo, GlobalTypes.Replica replica) throws OSDDrainException {
        RPCResponse response = null;
        try {
            MRC.xtreemfs_replica_addRequest replica_addRequest = MRC.xtreemfs_replica_addRequest.newBuilder().setFileId(fileInfo.fileID).setNewReplica(replica).build();
            response = this.mrcClient.xtreemfs_replica_add(fileInfo.mrcAddress, this.password, this.userCreds, replica_addRequest);
            response.get();
        }
        catch (Exception e) {
            if (Logging.isDebug()) {
                Logging.logError(4, this, e);
            }
            throw new OSDDrainException("Could not add replica to file with id" + fileInfo.fileID, OSDDrainException.ErrorState.CREATE_REPLICAS);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    public List<FileInformation> setReplicationUpdatePolicyRonly(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            try {
                fileInfo.oldReplicationPolicy = this.changeReplicationUpdatePolicy(fileInfo, "ronly");
                finishedFileInfos.add(fileInfo);
            }
            catch (Exception e) {
                throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.SET_UPDATE_POLICY, fileInfos, finishedFileInfos);
            }
        }
        return finishedFileInfos;
    }

    public List<FileInformation> resetReplicationUpdatePolicy(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        LinkedList<FileInformation> erroneousFiles = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            try {
                fileInfo.oldReplicationPolicy = this.changeReplicationUpdatePolicy(fileInfo, fileInfo.oldReplicationPolicy);
                finishedFileInfos.add(fileInfo);
            }
            catch (Exception e) {
                erroneousFiles.add(fileInfo);
            }
        }
        if (!erroneousFiles.isEmpty()) {
            throw new OSDDrainException("Failed to reset read only attribute for some files.", OSDDrainException.ErrorState.UNSET_UPDATE_POLICY, fileInfos, finishedFileInfos);
        }
        return finishedFileInfos;
    }

    private String changeReplicationUpdatePolicy(FileInformation fileInfo, String policy) throws Exception {
        RPCResponse<MRC.xtreemfs_set_replica_update_policyResponse> respRepl = null;
        MRC.xtreemfs_set_replica_update_policyResponse replSetResponse = null;
        try {
            respRepl = this.mrcClient.xtreemfs_set_replica_update_policy(fileInfo.mrcAddress, this.password, this.userCreds, fileInfo.fileID, policy);
            replSetResponse = respRepl.get();
        }
        catch (Exception ioe) {
            if (Logging.isDebug()) {
                Logging.logError(4, this, ioe);
            }
            throw ioe;
        }
        finally {
            if (respRepl != null) {
                respRepl.freeBuffers();
            }
        }
        return replSetResponse.getOldUpdatePolicy();
    }

    public List<FileInformation> setFilesReadOnlyAttribute(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            try {
                fileInfo.wasAlreadyReadOnly = this.setFileReadOnlyAttribute(fileInfo, true);
            }
            catch (OSDDrainException e) {
                throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.SET_RONLY, fileInfos, finishedFileInfos);
            }
            finishedFileInfos.add(fileInfo);
        }
        return finishedFileInfos;
    }

    public List<FileInformation> resetFilesReadOnlyAttribute(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        LinkedList<FileInformation> erroneousFiles = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            if (fileInfo.wasAlreadyReadOnly.booleanValue()) {
                finishedFileInfos.add(fileInfo);
                continue;
            }
            try {
                this.setFileReadOnlyAttribute(fileInfo, false);
                finishedFileInfos.add(fileInfo);
            }
            catch (OSDDrainException e) {
                erroneousFiles.add(fileInfo);
            }
        }
        if (!erroneousFiles.isEmpty()) {
            throw new OSDDrainException("Failed to reset read only attribute for some files.", OSDDrainException.ErrorState.UNSET_RONLY, fileInfos, finishedFileInfos);
        }
        return finishedFileInfos;
    }

    boolean setFileReadOnlyAttribute(FileInformation fileInfo, boolean mode) throws OSDDrainException {
        RPCResponse<MRC.xtreemfs_set_read_only_xattrResponse> response = null;
        MRC.xtreemfs_set_read_only_xattrResponse setResponse = null;
        try {
            response = this.mrcClient.xtreemfs_set_read_only_xattr(fileInfo.mrcAddress, this.password, this.userCreds, fileInfo.fileID, mode);
            setResponse = response.get();
        }
        catch (Exception e) {
            if (Logging.isDebug()) {
                Logging.logError(4, this, e);
            }
            throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.SET_RONLY);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
        return !setResponse.getWasSet();
    }

    public List<FileInformation> startReplication(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            RPCResponse<GlobalTypes.FileCredentials> r1 = null;
            try {
                r1 = this.mrcClient.xtreemfs_get_file_credentials(fileInfo.mrcAddress, this.password, this.userCreds, fileInfo.fileID);
                fileInfo.fileCredentials = r1.get();
            }
            catch (Exception e) {
                if (Logging.isDebug()) {
                    Logging.logError(4, this, e);
                }
                throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.WAIT_FOR_REPLICATION, fileInfos, finishedFileInfos);
            }
            finally {
                if (r1 != null) {
                    r1.freeBuffers();
                }
            }
            StripingPolicyImpl spol = StripingPolicyImpl.getPolicy(fileInfo.newReplica, 0);
            for (int i = 0; i < fileInfo.newReplica.getOsdUuidsCount(); ++i) {
                Iterator<Long> objs = spol.getObjectsOfOSD(i, 0L, Long.MAX_VALUE);
                long obj = objs.next();
                RPCResponse<OSD.ObjectData> r2 = null;
                try {
                    InetSocketAddress osd = new ServiceUUID(fileInfo.newReplica.getOsdUuids(i), this.resolver).getAddress();
                    r2 = this.osdClient.read(osd, this.password, this.userCreds, fileInfo.fileCredentials, fileInfo.fileID, obj, 0L, 0, 1);
                    r2.get();
                    continue;
                }
                catch (Exception e) {
                    if (Logging.isDebug()) {
                        Logging.logError(4, this, e);
                    }
                    throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.WAIT_FOR_REPLICATION, fileInfos, finishedFileInfos);
                }
                finally {
                    if (r2 != null) {
                        r2.freeBuffers();
                    }
                }
            }
            finishedFileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    public List<FileInformation> waitForReplicationToComplete(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        LinkedList<FileInformation> toBeRemovedFileInfos = new LinkedList<FileInformation>();
        while (!fileInfos.isEmpty()) {
            for (FileInformation fileInfo : fileInfos) {
                String fileID = fileInfo.fileID;
                GlobalTypes.FileCredentials fc = fileInfo.fileCredentials;
                GlobalTypes.Replica replica = fileInfo.newReplica;
                boolean isReplicated = true;
                StripingPolicyImpl sp = StripingPolicyImpl.getPolicy(replica, 0);
                long lastObjectNo = sp.getObjectNoForOffset(fc.getXlocs().getReadOnlyFileSize() - 1L);
                int osdRelPos = 0;
                for (String osdUUID : replica.getOsdUuidsList()) {
                    RPCResponse<OSD.ObjectList> r = null;
                    ObjectSet oSet = null;
                    try {
                        InetSocketAddress osdAddress = new ServiceUUID(osdUUID, this.resolver).getAddress();
                        r = this.osdClient.xtreemfs_internal_get_object_set(osdAddress, this.password, this.userCreds, fc, fileID);
                        OSD.ObjectList ol = r.get();
                        byte[] serializedBitSet = ol.getSet().toByteArray();
                        oSet = new ObjectSet(sp.getWidth(), osdRelPos, serializedBitSet);
                    }
                    catch (Exception e) {
                        if (Logging.isDebug()) {
                            Logging.logError(4, this, e);
                        }
                        LinkedList<FileInformation> allInfos = new LinkedList<FileInformation>();
                        allInfos.addAll(fileInfos);
                        allInfos.addAll(finishedFileInfos);
                        throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.WAIT_FOR_REPLICATION, finishedFileInfos, allInfos);
                    }
                    finally {
                        if (r != null) {
                            r.freeBuffers();
                        }
                    }
                    for (long objNo = (long)osdRelPos; objNo <= lastObjectNo; objNo += (long)sp.getWidth()) {
                        if (oSet.contains(objNo)) continue;
                        isReplicated = false;
                    }
                }
                if (!isReplicated) continue;
                toBeRemovedFileInfos.add(fileInfo);
                finishedFileInfos.add(fileInfo);
            }
            fileInfos.removeAll(toBeRemovedFileInfos);
            toBeRemovedFileInfos.clear();
            if (fileInfos.isEmpty()) {
                return finishedFileInfos;
            }
            Logging.logMessage(6, Logging.Category.tool, this, "waiting 10secs for replication to be finished", new Object[0]);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {}
        }
        return finishedFileInfos;
    }

    public void removeOriginalFromReplica(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        LinkedList<FileInformation> erroneousFiles = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            try {
                this.removeReplica(fileInfo, fileInfo.oldReplica);
                finishedFileInfos.add(fileInfo);
            }
            catch (OSDDrainException e) {
                erroneousFiles.add(fileInfo);
            }
        }
        if (!erroneousFiles.isEmpty()) {
            throw new OSDDrainException("Failed to remove original replicas for some files.\nIt is NOT SAFE to call xtfs_remove_osd again. Please remove the replicas manually before continuing.", OSDDrainException.ErrorState.REMOVE_REPLICAS, fileInfos, finishedFileInfos);
        }
    }

    private void removeReplica(FileInformation fileInfo, GlobalTypes.Replica replica) throws OSDDrainException {
        RPCResponse<GlobalTypes.FileCredentials> response = null;
        String headOSD = replica.getOsdUuids(0);
        MRC.xtreemfs_replica_removeRequest replica_removeRequest = MRC.xtreemfs_replica_removeRequest.newBuilder().setFileId(fileInfo.fileID).setOsdUuid(headOSD).build();
        try {
            response = this.mrcClient.xtreemfs_replica_remove(fileInfo.mrcAddress, this.password, this.userCreds, replica_removeRequest);
            response.get();
        }
        catch (Exception e) {
            if (Logging.isDebug()) {
                Logging.logError(4, this, e);
            }
            throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.REMOVE_REPLICAS);
        }
        finally {
            if (response != null) {
                response.freeBuffers();
            }
        }
    }

    void shutdownOsd() throws OSDDrainException {
        RPCResponse r = null;
        try {
            r = this.osdClient.xtreemfs_shutdown(this.osdUUID.getAddress(), this.password, this.userCreds);
            r.get();
        }
        catch (Exception e) {
            if (Logging.isDebug()) {
                Logging.logError(4, this, e);
            }
            throw new OSDDrainException(e.getMessage(), OSDDrainException.ErrorState.SHUTDOWN_OSD);
        }
        finally {
            if (r != null) {
                r.freeBuffers();
            }
        }
    }

    private void revertRemoveOriginalReplicas(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        LinkedList<FileInformation> erroneousFiles = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            try {
                if (fileInfo.oldReplica != null) {
                    this.addReplicaToFile(fileInfo, fileInfo.oldReplica);
                }
                finishedFileInfos.add(fileInfo);
            }
            catch (OSDDrainException e) {
                erroneousFiles.add(fileInfo);
            }
        }
        if (!erroneousFiles.isEmpty()) {
            throw new OSDDrainException("Failed to recreate original replicas for some files.\nIt is NOT SAFE to call xtfs_remove_osd again. Please ensure the files are properly replicated before continuing.", OSDDrainException.ErrorState.CREATE_REPLICAS, fileInfos, finishedFileInfos);
        }
    }

    private void removeNewReplicas(List<FileInformation> fileInfos) throws OSDDrainException {
        LinkedList<FileInformation> finishedFileInfos = new LinkedList<FileInformation>();
        LinkedList<FileInformation> erroneousFiles = new LinkedList<FileInformation>();
        for (FileInformation fileInfo : fileInfos) {
            try {
                if (fileInfo.newReplica != null) {
                    this.removeReplica(fileInfo, fileInfo.newReplica);
                }
                finishedFileInfos.add(fileInfo);
            }
            catch (OSDDrainException e) {
                erroneousFiles.add(fileInfo);
            }
        }
        if (!erroneousFiles.isEmpty()) {
            throw new OSDDrainException("Failed to remove new replicas for some files.\nIt is NOT SAFE to call xtfs_remove_osd again. Please remove the replicas manually before continuing.", OSDDrainException.ErrorState.CREATE_REPLICAS, fileInfos, finishedFileInfos);
        }
    }

    public void handleException(OSDDrainException ex, boolean printError) {
        switch (ex.getErrorState()) {
            case INITIALIZATION: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to initialize connection", new Object[0]);
                    this.printError();
                }
                if (!Logging.isDebug()) break;
                Logging.logError(7, this, ex);
                break;
            }
            case GET_FILE_LIST: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to get filelist from OSD", new Object[0]);
                    this.printError();
                }
                if (!Logging.isDebug()) break;
                Logging.logError(7, this, ex);
                break;
            }
            case UPDATE_MRC_ADDRESSES: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to get all MRC Addresses from DIR", new Object[0]);
                    this.printError();
                }
                if (!Logging.isDebug()) break;
                Logging.logError(7, this, ex);
                break;
            }
            case REMOVE_NON_EXISTING_IDS: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to check if files exist on MRC", new Object[0]);
                    this.printError();
                }
                if (!Logging.isDebug()) break;
                Logging.logError(7, this, ex);
                break;
            }
            case GET_REPLICA_INFO: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to to get replica info from MRC", new Object[0]);
                    this.printError();
                }
                if (!Logging.isDebug()) break;
                Logging.logError(7, this, ex);
                break;
            }
            case SET_SERVICE_STATUS: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "ERROR: failed to set ServiceStatus for OSD", new Object[0]);
                    this.printError();
                }
                if (!Logging.isDebug()) break;
                Logging.logError(7, this, ex);
                break;
            }
            case DRAIN_COORDINATED: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, ex.getMessage(), new Object[0]);
                    this.printError();
                }
                if (!Logging.isDebug()) break;
                Logging.logError(7, this, ex);
                break;
            }
            case SET_UPDATE_POLICY: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to set ReplicationUpdatePolicies", new Object[0]);
                    this.printError();
                }
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                Logging.logMessage(6, Logging.Category.tool, this, "Trying to revert ReplicationUpdatePolicy changes...", new Object[0]);
                try {
                    this.resetReplicationUpdatePolicy(ex.getFileInfosCurrent());
                    Logging.logMessage(6, Logging.Category.tool, this, "DONE reverting ReplicationUpdatePolicy changes", new Object[0]);
                }
                catch (OSDDrainException ode) {
                    List<FileInformation> failedFileInfos = ode.getFileInfosAll();
                    failedFileInfos.removeAll(ode.getFileInfosCurrent());
                    String error = "Following files couldn't set back its originial ReplicationUpdatePolicy due to errors:";
                    for (FileInformation fileInfo : failedFileInfos) {
                        error = error + "\n " + fileInfo.fileID;
                    }
                    Logging.logMessage(3, Logging.Category.tool, this, error, new Object[0]);
                }
                break;
            }
            case SET_RONLY: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to set files read-only", new Object[0]);
                    this.printError();
                }
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                Logging.logMessage(6, Logging.Category.tool, this, "Trying to revert read-only mode changes...", new Object[0]);
                try {
                    this.resetFilesReadOnlyAttribute(ex.getFileInfosCurrent());
                    Logging.logMessage(6, Logging.Category.tool, this, "DONE reverting read-only mode changes", new Object[0]);
                }
                catch (OSDDrainException ode) {
                    List<FileInformation> failedFileInfos = ode.getFileInfosAll();
                    failedFileInfos.removeAll(ode.getFileInfosCurrent());
                    String error = "Following files couldn't set back its originial read-only mode:";
                    for (FileInformation fileInfo : failedFileInfos) {
                        error = error + "\n " + fileInfo.fileID;
                    }
                    Logging.logMessage(3, Logging.Category.tool, this, error, new Object[0]);
                }
                this.handleException(new OSDDrainException(ex.getMessage(), OSDDrainException.ErrorState.SET_UPDATE_POLICY, ex.getFileInfosAll(), ex.getFileInfosAll()), false);
                break;
            }
            case CREATE_REPLICAS: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to create new replicas", new Object[0]);
                    this.printError();
                }
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                Logging.logMessage(6, Logging.Category.tool, this, "Trying to revert replica changes...", new Object[0]);
                try {
                    this.removeNewReplicas(ex.getFileInfosCurrent());
                    Logging.logMessage(6, Logging.Category.tool, this, "DONE reverting replica changes", new Object[0]);
                }
                catch (OSDDrainException ode) {
                    List<FileInformation> failedFileInfos = ode.getFileInfosAll();
                    failedFileInfos.removeAll(ode.getFileInfosCurrent());
                    String error = ex.getMessage() + "\n" + "From following files the newly created replicas couldn't be removed:";
                    for (FileInformation fileInfo : failedFileInfos) {
                        error = error + "\n " + fileInfo.fileID;
                    }
                    Logging.logMessage(3, Logging.Category.tool, this, error, new Object[0]);
                }
                this.handleException(new OSDDrainException(ex.getMessage(), OSDDrainException.ErrorState.SET_RONLY, ex.getFileInfosAll(), ex.getFileInfosAll()), false);
                break;
            }
            case WAIT_FOR_REPLICATION: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to replicate files", new Object[0]);
                    this.printError();
                }
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                Logging.logMessage(6, Logging.Category.tool, this, "Trying to remove yet replicated files...", new Object[0]);
                try {
                    this.removeNewReplicas(ex.getFileInfosAll());
                    Logging.logMessage(6, Logging.Category.tool, this, "DONE removing yet replicated files", new Object[0]);
                }
                catch (OSDDrainException ode) {
                    List<FileInformation> failedFileInfos = ode.getFileInfosAll();
                    failedFileInfos.removeAll(ode.getFileInfosCurrent());
                    String error = ex.getMessage() + "\n" + "From following files the newly created replicas couldn't be removed:";
                    for (FileInformation fileInfo : failedFileInfos) {
                        error = error + "\n " + fileInfo.fileID;
                    }
                    Logging.logMessage(3, Logging.Category.tool, this, error, new Object[0]);
                }
                this.handleException(new OSDDrainException(ex.getMessage(), OSDDrainException.ErrorState.SET_RONLY, ex.getFileInfosAll(), ex.getFileInfosAll()), false);
                break;
            }
            case REMOVE_REPLICAS: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to remove original replicas", new Object[0]);
                    this.printError();
                }
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                Logging.logMessage(6, Logging.Category.tool, this, "Trying to revert original replica changes...", new Object[0]);
                try {
                    this.revertRemoveOriginalReplicas(ex.getFileInfosCurrent());
                    Logging.logMessage(6, Logging.Category.tool, this, "DONE removing original replicate changes", new Object[0]);
                }
                catch (OSDDrainException ode) {
                    List<FileInformation> failedFileInfos = ode.getFileInfosAll();
                    failedFileInfos.removeAll(ode.getFileInfosCurrent());
                    String error = ex.getMessage() + "\n" + "From the following files the changes to the original replica couldn't be reverted:";
                    for (FileInformation fileInfo : failedFileInfos) {
                        error = error + "\n " + fileInfo.fileID;
                    }
                    Logging.logMessage(3, Logging.Category.tool, this, error, new Object[0]);
                }
                this.handleException(new OSDDrainException(ex.getMessage(), OSDDrainException.ErrorState.CREATE_REPLICAS, ex.getFileInfosAll(), ex.getFileInfosAll()), false);
                break;
            }
            case UNSET_RONLY: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to set files back from read-only mode", new Object[0]);
                    this.printError();
                }
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                List<FileInformation> failedFileInfos = ex.getFileInfosAll();
                failedFileInfos.removeAll(ex.getFileInfosCurrent());
                String error = "Following files couldn't set back to read-only mode:";
                for (FileInformation fileInfo : failedFileInfos) {
                    error = error + "\n " + fileInfo.fileID;
                }
                Logging.logMessage(3, Logging.Category.tool, this, error, new Object[0]);
                this.handleException(new OSDDrainException(ex.getMessage(), OSDDrainException.ErrorState.REMOVE_REPLICAS, ex.getFileInfosAll(), ex.getFileInfosAll()), false);
                break;
            }
            case UNSET_UPDATE_POLICY: {
                if (printError) {
                    Logging.logMessage(3, Logging.Category.tool, this, "Failed to set ReplicationUpdatePolicy back to the original ones", new Object[0]);
                    this.printError();
                }
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                List<FileInformation> failedFileInfos = ex.getFileInfosAll();
                failedFileInfos.removeAll(ex.getFileInfosCurrent());
                String error = "For the following files the changes to ReplicationUpdatePolicy couldn't be reverted:";
                for (FileInformation fileInfo : failedFileInfos) {
                    error = error + "\n " + fileInfo.fileID;
                }
                Logging.logMessage(3, Logging.Category.tool, this, error, new Object[0]);
                this.handleException(new OSDDrainException(ex.getMessage(), OSDDrainException.ErrorState.REMOVE_REPLICAS, failedFileInfos, failedFileInfos), false);
                break;
            }
            case SHUTDOWN_OSD: {
                if (printError) {
                    Logging.logMessage(4, Logging.Category.tool, this, "Couldn't shut down OSD with UUID=" + this.osdUUID.toString() + "  but all object files are moved to other OSDs. It's safe to shutdown this OSD now.", new Object[0]);
                    System.out.println("WARNING: Couldn't shut down OSD with UUID=" + this.osdUUID.toString() + "  but all object files are moved to other OSDs. It's safe to shutdown this OSD now.");
                }
                if (!Logging.isDebug()) break;
                Logging.logError(7, this, ex);
                break;
            }
        }
    }

    private void printError() {
        System.err.println("ERROR: An error accured during the OSD drain process. See logging outputfor details. It is NOT save to shutdown the OSD.");
    }

    public static class FileInformation {
        public String fileID;
        public InetSocketAddress mrcAddress;
        public GlobalTypes.FileCredentials fileCredentials;
        public GlobalTypes.Replica newReplica;
        public GlobalTypes.Replica oldReplica;
        public Boolean wasAlreadyReadOnly;
        public String oldReplicationPolicy;
        public boolean isReplicaChangeCoordinated = false;
    }
}

