/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import java.io.IOException;
import java.util.List;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class CheckObjectOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public CheckObjectOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 21;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        final OSD.xtreemfs_check_objectRequest args = (OSD.xtreemfs_check_objectRequest)rq.getRequestArgs();
        if (args.getObjectNumber() < 0L) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "object number must be >= 0");
            return;
        }
        this.master.getStorageStage().readObject(args.getFileId(), args.getObjectNumber(), rq.getLocationList().getLocalReplica().getStripingPolicy(), 0, -1, rq.getCapability().getSnapConfig() == GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP ? rq.getCapability().getSnapTimestamp() : 0L, rq, new StorageStage.ReadObjectCallback(){

            @Override
            public void readComplete(ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
                CheckObjectOperation.this.step2(rq, args, result, error);
            }
        });
    }

    public void step2(OSDRequest rq, OSD.xtreemfs_check_objectRequest args, ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else if (rq.getLocationList().getLocalReplica().getOSDs().size() == 1) {
            this.nonStripedCheckObject(rq, args, result);
        } else {
            this.stripedCheckObject(rq, args, result);
        }
    }

    private void nonStripedCheckObject(OSDRequest rq, OSD.xtreemfs_check_objectRequest args, ObjectInformation result) {
        boolean isLastObjectOrEOF = result.getLastLocalObjectNo() <= args.getObjectNumber();
        this.readFinish(rq, args, result, isLastObjectOrEOF);
    }

    private void stripedCheckObject(final OSDRequest rq, final OSD.xtreemfs_check_objectRequest args, final ObjectInformation result) {
        boolean isLastObjectLocallyKnown;
        long objNo = args.getObjectNumber();
        long lastKnownObject = Math.max(result.getLastLocalObjectNo(), result.getGlobalLastObjectNo());
        boolean bl = isLastObjectLocallyKnown = lastKnownObject <= objNo;
        if (objNo > lastKnownObject || objNo == lastKnownObject && result.getData() != null && result.getData().remaining() < result.getStripeSize()) {
            try {
                List<ServiceUUID> osds = rq.getLocationList().getLocalReplica().getOSDs();
                final RPCResponse[] gmaxRPCs = new RPCResponse[osds.size() - 1];
                int cnt = 0;
                for (ServiceUUID osd : osds) {
                    if (osd.equals(this.localUUID)) continue;
                    gmaxRPCs[cnt++] = this.master.getOSDClient().xtreemfs_internal_get_gmax(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, args.getFileCredentials(), args.getFileId());
                }
                this.waitForResponses(gmaxRPCs, new OSDOperation.ResponsesListener(){

                    @Override
                    public void responsesAvailable() {
                        CheckObjectOperation.this.stripedCheckObjectAnalyzeGmax(rq, args, result, gmaxRPCs);
                    }
                });
            }
            catch (IOException ex) {
                rq.sendInternalServerError(ex);
                return;
            }
        } else {
            this.readFinish(rq, args, result, isLastObjectLocallyKnown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripedCheckObjectAnalyzeGmax(OSDRequest rq, OSD.xtreemfs_check_objectRequest args, ObjectInformation result, RPCResponse[] gmaxRPCs) {
        long maxObjNo = -1L;
        long maxTruncate = -1L;
        try {
            for (int i = 0; i < gmaxRPCs.length; ++i) {
                OSD.InternalGmax gmax = (OSD.InternalGmax)gmaxRPCs[i].get();
                if (gmax.getLastObjectId() <= maxObjNo || gmax.getEpoch() < maxTruncate) continue;
                maxObjNo = gmax.getLastObjectId();
                maxTruncate = gmax.getEpoch();
            }
            boolean isLastObjectLocallyKnown = maxObjNo <= args.getObjectNumber();
            this.readFinish(rq, args, result, isLastObjectLocallyKnown);
            this.master.getStorageStage().receivedGMAX_ASYNC(args.getFileId(), maxTruncate, maxObjNo);
        }
        catch (Exception ex) {
            rq.sendInternalServerError(ex);
        }
        finally {
            for (RPCResponse r : gmaxRPCs) {
                r.freeBuffers();
            }
        }
    }

    private void readFinish(OSDRequest rq, OSD.xtreemfs_check_objectRequest args, ObjectInformation result, boolean isLastObjectOrEOF) {
        InternalObjectData data = result.getObjectData(isLastObjectOrEOF, 0, result.getStripeSize());
        if (data.getData() != null) {
            data.setZero_padding(data.getZero_padding() + data.getData().remaining());
            BufferPool.free(data.getData());
            data.setData(null);
        }
        this.sendResponse(rq, data);
    }

    public void sendResponse(OSDRequest rq, InternalObjectData result) {
        rq.sendSuccess(result.getMetadata(), null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_check_objectRequest rpcrq = (OSD.xtreemfs_check_objectRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

