/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import java.io.IOException;
import java.util.List;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.OpenFileTable;
import org.xtreemfs.osd.operations.EventCloseFile;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.DeletionStage;
import org.xtreemfs.osd.stages.PreprocStage;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class DeleteOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public DeleteOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 12;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        final OSD.unlink_osd_Request args = (OSD.unlink_osd_Request)rq.getRequestArgs();
        this.master.getPreprocStage().checkDeleteOnClose(args.getFileId(), new PreprocStage.DeleteOnCloseCallback(){

            @Override
            public void deleteOnCloseResult(boolean isDeleteOnClose, RPC.RPCHeader.ErrorResponse error) {
                DeleteOperation.this.closeFileIfNecessary(rq, isDeleteOnClose, args, error);
            }
        });
    }

    public void closeFileIfNecessary(final OSDRequest rq, boolean isDeleteOnClose, final OSD.unlink_osd_Request args, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
            return;
        }
        if (!isDeleteOnClose) {
            if (rq.getLocationList().getReplicaUpdatePolicy().equals("ronly")) {
                this.master.getReplicationStage().cancelReplicationForFile(args.getFileId());
            }
            this.master.getDeletionStage().deleteObjects(args.getFileId(), null, rq.getCowPolicy().cowEnabled(), rq, false, new DeletionStage.DeleteObjectsCallback(){

                @Override
                public void deleteComplete(RPC.RPCHeader.ErrorResponse error) {
                    DeleteOperation.this.disseminateDeletesIfNecessary(rq, args, error);
                }
            });
        } else {
            this.master.getPreprocStage().close(args.getFileId(), new PreprocStage.CloseCallback(){

                @Override
                public void closeResult(OpenFileTable.OpenFileTableEntry entry, RPC.RPCHeader.ErrorResponse error) {
                    OSDOperation closeEvent = DeleteOperation.this.master.getInternalEvent(EventCloseFile.class);
                    closeEvent.startInternalEvent(new Object[]{entry.getFileId(), true, entry.getCowPolicy().cowEnabled(), entry.isWrite(), new EventCloseFile.EventCloseCallback(){

                        @Override
                        public void closeEventResult(RPC.RPCHeader.ErrorResponse error) {
                            DeleteOperation.this.disseminateDeletesIfNecessary(rq, args, error);
                        }
                    }});
                }
            });
        }
    }

    public void disseminateDeletesIfNecessary(final OSDRequest rq, OSD.unlink_osd_Request args, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
            return;
        }
        Replica localReplica = rq.getLocationList().getLocalReplica();
        if (localReplica.isStriped() && localReplica.getHeadOsd().equals(this.localUUID)) {
            try {
                List<ServiceUUID> osds = rq.getLocationList().getLocalReplica().getOSDs();
                final RPCResponse[] gmaxRPCs = new RPCResponse[osds.size() - 1];
                int cnt = 0;
                for (ServiceUUID osd : osds) {
                    if (osd.equals(this.localUUID)) continue;
                    gmaxRPCs[cnt++] = this.master.getOSDClient().unlink(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, args.getFileCredentials(), args.getFileId());
                }
                this.waitForResponses(gmaxRPCs, new OSDOperation.ResponsesListener(){

                    @Override
                    public void responsesAvailable() {
                        DeleteOperation.this.analyzeUnlinkReponses(rq, gmaxRPCs);
                    }
                });
            }
            catch (IOException ex) {
                rq.sendInternalServerError(ex);
                return;
            }
        } else {
            this.sendResponse(rq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeUnlinkReponses(OSDRequest rq, RPCResponse[] gmaxRPCs) {
        try {
            for (int i = 0; i < gmaxRPCs.length; ++i) {
                gmaxRPCs[i].get();
            }
            this.sendResponse(rq);
        }
        catch (Exception ex) {
            rq.sendInternalServerError(ex);
        }
        finally {
            for (RPCResponse r : gmaxRPCs) {
                r.freeBuffers();
            }
        }
    }

    public void sendResponse(OSDRequest rq) {
        rq.sendSuccess(null, null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.unlink_osd_Request rpcrq = (OSD.unlink_osd_Request)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public boolean bypassViewValidation() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

