/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.DeletionStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.storage.FileMetadata;

public class EventCloseFile
extends OSDOperation {
    public EventCloseFile(OSDRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startInternalEvent(Object[] args) {
        String fileId = (String)args[0];
        Boolean deleteOnClose = (Boolean)args[1];
        Boolean cowEnabled = (Boolean)args[2];
        Boolean createVersion = (Boolean)args[3];
        EventCloseCallback cb = args.length > 4 ? (EventCloseCallback)args[4] : null;
        this.flushCaches(fileId, deleteOnClose, cowEnabled, createVersion, cb);
    }

    public void flushCaches(final String fileId, final boolean deleteOnClose, final boolean cowEnabled, final boolean createVersion, final EventCloseCallback cb) {
        this.master.getStorageStage().flushCaches(fileId, new StorageStage.CachesFlushedCallback(){

            @Override
            public void cachesFlushed(RPC.RPCHeader.ErrorResponse error, FileMetadata fi) {
                EventCloseFile.this.createVersionIfNecessary(fileId, deleteOnClose, cowEnabled, createVersion, fi, cb, error);
            }
        });
        this.master.getRWReplicationStage().fileClosed(fileId);
    }

    public void createVersionIfNecessary(final String fileId, final boolean deleteOnClose, final boolean cowEnabled, boolean createVersion, final FileMetadata fi, final EventCloseCallback cb, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            this.finishEvent(cb, error);
            return;
        }
        if (cowEnabled && createVersion) {
            this.master.getStorageStage().createFileVersion(fileId, fi, null, new StorageStage.CreateFileVersionCallback(){

                @Override
                public void createFileVersionComplete(long fileSize, RPC.RPCHeader.ErrorResponse error) {
                    EventCloseFile.this.deleteIfNecessary(fileId, deleteOnClose, cowEnabled, fi, cb, error);
                }
            });
        } else {
            this.deleteIfNecessary(fileId, deleteOnClose, cowEnabled, fi, cb, null);
        }
    }

    public void deleteIfNecessary(String fileId, boolean deleteOnClose, boolean cowEnabled, FileMetadata fi, final EventCloseCallback cb, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            this.finishEvent(cb, error);
            return;
        }
        if (deleteOnClose) {
            this.master.getReplicationStage().cancelReplicationForFile(fileId);
            this.master.getDeletionStage().deleteObjects(fileId, fi, cowEnabled, null, false, new DeletionStage.DeleteObjectsCallback(){

                @Override
                public void deleteComplete(RPC.RPCHeader.ErrorResponse error) {
                    EventCloseFile.this.finishEvent(cb, error);
                }
            });
        } else {
            this.finishEvent(cb, null);
        }
    }

    public void finishEvent(EventCloseCallback cb, RPC.RPCHeader.ErrorResponse error) {
        if (cb != null) {
            cb.closeEventResult(error);
        } else if (error != null) {
            Logging.logMessage(3, this, "exception in internal close event: %s", ErrorUtils.formatError(error));
        }
    }

    @Override
    public int getProcedureId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void startRequest(OSDRequest rq) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean requiresCapability() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static interface EventCloseCallback {
        public void closeEventResult(RPC.RPCHeader.ErrorResponse var1);
    }
}

