/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class EventGmax
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public EventGmax(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 20;
    }

    @Override
    public void startRequest(OSDRequest rq) {
        OSD.xtreemfs_broadcast_gmaxRequest args = (OSD.xtreemfs_broadcast_gmaxRequest)rq.getRequestArgs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.stage, this, "received GMAX packet for: %s from %s", rq.getFileId(), rq.getRPCRequest().getSenderAddress());
        }
        this.master.getStorageStage().receivedGMAX_ASYNC(args.getFileId(), args.getTruncateEpoch(), args.getLastObject());
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        rq.setFileId("");
        return null;
    }

    @Override
    public boolean requiresCapability() {
        return false;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

