/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import java.util.ArrayList;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class GetFileIDListOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public GetFileIDListOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 45;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        this.master.getStorageStage().getFileIDList(rq, new StorageStage.GetFileIDListCallback(){

            @Override
            public void createGetFileIDListComplete(ArrayList<String> fileIDList, RPC.RPCHeader.ErrorResponse error) {
                GetFileIDListOperation.this.postGetFileIDList(rq, fileIDList, error);
            }
        });
    }

    private void postGetFileIDList(OSDRequest rq, ArrayList<String> fileIDList, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            try {
                OSD.xtreemfs_internal_get_fileid_listResponse.Builder responseBuilder = OSD.xtreemfs_internal_get_fileid_listResponse.newBuilder();
                for (String fileID : fileIDList) {
                    responseBuilder.addFileIds(fileID);
                }
                rq.sendSuccess(responseBuilder.build(), null);
            }
            catch (Exception e) {
                rq.sendError(ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, e.toString()));
            }
        }
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        return null;
    }

    @Override
    public boolean requiresCapability() {
        return false;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

