/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class GetObjectSetOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public GetObjectSetOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 44;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        final OSD.xtreemfs_internal_get_object_setRequest args = (OSD.xtreemfs_internal_get_object_setRequest)rq.getRequestArgs();
        this.master.getStorageStage().getObjectSet(args.getFileId(), rq.getLocationList().getLocalReplica().getStripingPolicy(), rq, new StorageStage.GetObjectListCallback(){

            @Override
            public void getObjectSetComplete(ObjectSet result, RPC.RPCHeader.ErrorResponse error) {
                GetObjectSetOperation.this.postReadObjectList(rq, args, result, error);
            }
        });
    }

    public void postReadObjectList(OSDRequest rq, OSD.xtreemfs_internal_get_object_setRequest args, ObjectSet result, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            try {
                byte[] serialized = result.getSerializedBitSet();
                OSD.ObjectList objList = OSD.ObjectList.newBuilder().setSet(ByteString.copyFrom(serialized)).setStripeWidth(result.getStripeWidth()).setFirst(result.getFirstObjectNo()).build();
                rq.sendSuccess(objList, null);
            }
            catch (IOException e) {
                rq.sendInternalServerError(e);
            }
        }
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_internal_get_object_setRequest rpcrq = (OSD.xtreemfs_internal_get_object_setRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

