/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import java.io.IOException;
import java.util.List;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class InternalGetFileSizeOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public InternalGetFileSizeOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 42;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        final OSD.xtreemfs_internal_get_file_sizeRequest args = (OSD.xtreemfs_internal_get_file_sizeRequest)rq.getRequestArgs();
        StripingPolicyImpl sp = rq.getLocationList().getLocalReplica().getStripingPolicy();
        String replUpdatePolicy = args.getFileCredentials().getXlocs().getReplicaUpdatePolicy();
        if (replUpdatePolicy.equals("") || replUpdatePolicy.equals("ronly")) {
            this.master.getStorageStage().getFilesize(args.getFileId(), sp, rq.getCapability().getSnapTimestamp(), rq, new StorageStage.GetFileSizeCallback(){

                @Override
                public void getFileSizeComplete(long fileSize, RPC.RPCHeader.ErrorResponse error) {
                    InternalGetFileSizeOperation.this.step2(rq, args, fileSize, error);
                }
            });
        } else {
            this.rwReplicatedGetFS(rq, args);
        }
    }

    public void step2(OSDRequest rq, OSD.xtreemfs_internal_get_file_sizeRequest args, long localFS, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else if (rq.getLocationList().getLocalReplica().isStriped()) {
            this.stripedGetFS(rq, args, localFS);
        } else {
            this.sendResponse(rq, localFS);
        }
    }

    private void stripedGetFS(final OSDRequest rq, final OSD.xtreemfs_internal_get_file_sizeRequest args, final long localFS) {
        try {
            List<ServiceUUID> osds = rq.getLocationList().getLocalReplica().getOSDs();
            final RPCResponse[] gmaxRPCs = new RPCResponse[osds.size() - 1];
            int cnt = 0;
            for (ServiceUUID osd : osds) {
                if (osd.equals(this.localUUID)) continue;
                gmaxRPCs[cnt++] = this.master.getOSDClient().xtreemfs_internal_get_gmax(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, args.getFileCredentials(), args.getFileId());
            }
            this.waitForResponses(gmaxRPCs, new OSDOperation.ResponsesListener(){

                @Override
                public void responsesAvailable() {
                    InternalGetFileSizeOperation.this.stripedReadAnalyzeGmax(rq, args, localFS, gmaxRPCs);
                }
            });
        }
        catch (IOException ex) {
            rq.sendInternalServerError(ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripedReadAnalyzeGmax(OSDRequest rq, OSD.xtreemfs_internal_get_file_sizeRequest args, long localFS, RPCResponse[] gmaxRPCs) {
        long maxFS = localFS;
        try {
            for (int i = 0; i < gmaxRPCs.length; ++i) {
                OSD.InternalGmax gmax = (OSD.InternalGmax)gmaxRPCs[i].get();
                if (gmax.getFileSize() <= maxFS) continue;
                maxFS = gmax.getFileSize();
            }
            this.sendResponse(rq, maxFS);
        }
        catch (Exception ex) {
            rq.sendInternalServerError(ex);
        }
        finally {
            for (RPCResponse r : gmaxRPCs) {
                r.freeBuffers();
            }
        }
    }

    private void rwReplicatedGetFS(final OSDRequest rq, final OSD.xtreemfs_internal_get_file_sizeRequest args) {
        this.master.getRWReplicationStage().prepareOperation(args.getFileCredentials(), rq.getLocationList(), 0L, 0L, RWReplicationStage.Operation.READ, new RWReplicationStage.RWReplicationCallback(){

            @Override
            public void success(long newObjectVersion) {
                StripingPolicyImpl sp = rq.getLocationList().getLocalReplica().getStripingPolicy();
                long snapVerTS = rq.getCapability().getSnapConfig() == GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP ? rq.getCapability().getSnapTimestamp() : 0L;
                InternalGetFileSizeOperation.this.master.getStorageStage().getFilesize(args.getFileId(), sp, snapVerTS, rq, new StorageStage.GetFileSizeCallback(){

                    @Override
                    public void getFileSizeComplete(long fileSize, RPC.RPCHeader.ErrorResponse error) {
                        if (error != null) {
                            rq.sendError(error);
                        } else {
                            InternalGetFileSizeOperation.this.sendResponse(rq, fileSize);
                        }
                    }
                });
            }

            @Override
            public void redirect(String redirectTo) {
                rq.getRPCRequest().sendRedirect(redirectTo);
            }

            @Override
            public void failed(RPC.RPCHeader.ErrorResponse err) {
                rq.sendError(err);
            }
        }, rq);
    }

    public void sendResponse(OSDRequest rq, long fileSize) {
        OSD.xtreemfs_internal_get_file_sizeResponse response = OSD.xtreemfs_internal_get_file_sizeResponse.newBuilder().setFileSize(fileSize).build();
        rq.sendSuccess(response, null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_internal_get_file_sizeRequest rpcrq = (OSD.xtreemfs_internal_get_file_sizeRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

