/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class InternalGetGmaxOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public InternalGetGmaxOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 40;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        OSD.xtreemfs_internal_get_gmaxRequest args = (OSD.xtreemfs_internal_get_gmaxRequest)rq.getRequestArgs();
        this.master.getStorageStage().internalGetGmax(args.getFileId(), rq.getLocationList().getLocalReplica().getStripingPolicy(), rq.getCapability().getSnapConfig() == GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP ? rq.getCapability().getSnapTimestamp() : 0L, rq, new StorageStage.InternalGetGmaxCallback(){

            @Override
            public void gmaxComplete(OSD.InternalGmax result, RPC.RPCHeader.ErrorResponse error) {
                if (error != null) {
                    rq.sendError(error);
                } else {
                    InternalGetGmaxOperation.this.sendResponse(rq, result);
                }
            }
        });
    }

    public void sendResponse(OSDRequest rq, OSD.InternalGmax result) {
        rq.sendSuccess(result, null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_internal_get_gmaxRequest rpcrq = (OSD.xtreemfs_internal_get_gmaxRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

