/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.stages.PreprocStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class InternalRWRAuthStateInvalidatedOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public InternalRWRAuthStateInvalidatedOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 82;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        OSD.xtreemfs_rwr_auth_stateRequest args = (OSD.xtreemfs_rwr_auth_stateRequest)rq.getRequestArgs();
        this.master.getPreprocStage().invalidateXLocSet(rq, args.getFileCredentials(), false, new PreprocStage.InvalidateXLocSetCallback(){

            @Override
            public void invalidateComplete(GlobalTypes.LeaseState leaseState, RPC.RPCHeader.ErrorResponse error) {
                if (error != null) {
                    rq.sendError(error);
                } else {
                    InternalRWRAuthStateInvalidatedOperation.this.postInvalidation(rq);
                }
            }
        });
    }

    private void postInvalidation(final OSDRequest rq) {
        String fileId = rq.getFileId();
        this.master.getStorageStage().internalGetReplicaState(fileId, rq.getLocationList().getLocalReplica().getStripingPolicy(), 0L, new StorageStage.InternalGetReplicaStateCallback(){

            @Override
            public void getReplicaStateComplete(OSD.ReplicaStatus localState, RPC.RPCHeader.ErrorResponse error) {
                if (error != null) {
                    rq.sendError(error);
                } else {
                    InternalRWRAuthStateInvalidatedOperation.this.startFetch(rq, localState);
                }
            }
        });
    }

    private void startFetch(final OSDRequest rq, OSD.ReplicaStatus localState) {
        String fileId = rq.getFileId();
        XLocations xloc = rq.getLocationList();
        OSD.xtreemfs_rwr_auth_stateRequest args = (OSD.xtreemfs_rwr_auth_stateRequest)rq.getRequestArgs();
        this.master.getRWReplicationStage().fetchInvalidated(fileId, args.getState(), localState, args.getFileCredentials(), xloc, new RWReplicationStage.RWReplicationCallback(){

            @Override
            public void success(long newObjectVersion) {
                rq.sendSuccess(Common.emptyResponse.getDefaultInstance(), null);
            }

            @Override
            public void failed(RPC.RPCHeader.ErrorResponse ex) {
                rq.sendError(ex);
            }

            @Override
            public void redirect(String redirectTo) {
                rq.sendError(ErrorUtils.getErrorResponse(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "FetchInvalidated called the redirect method. This should never happen"));
            }
        }, rq);
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_rwr_auth_stateRequest rpcrq = (OSD.xtreemfs_rwr_auth_stateRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public boolean bypassViewValidation() {
        return true;
    }
}

