/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class InternalRWRAuthStateOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public InternalRWRAuthStateOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 79;
    }

    @Override
    public void startRequest(OSDRequest rq) {
        OSD.xtreemfs_rwr_auth_stateRequest args = (OSD.xtreemfs_rwr_auth_stateRequest)rq.getRequestArgs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "RWR auth state request for file %s", args.getFileId());
        }
        this.getLocalReplicaState(rq, args);
    }

    public void getLocalReplicaState(final OSDRequest rq, final OSD.xtreemfs_rwr_auth_stateRequest args) {
        this.master.getStorageStage().internalGetReplicaState(rq.getFileId(), rq.getLocationList().getLocalReplica().getStripingPolicy(), 0L, new StorageStage.InternalGetReplicaStateCallback(){

            @Override
            public void getReplicaStateComplete(OSD.ReplicaStatus localState, RPC.RPCHeader.ErrorResponse error) {
                if (error == null) {
                    InternalRWRAuthStateOperation.this.master.getRWReplicationStage().eventBackupReplicaReset(rq.getFileId(), args.getState(), localState, args.getFileCredentials(), rq.getLocationList());
                    rq.sendSuccess(Common.emptyResponse.getDefaultInstance(), null);
                } else {
                    InternalRWRAuthStateOperation.this.sendResult(rq, null, error);
                }
            }
        });
    }

    public void sendResult(OSDRequest rq, InternalObjectData response, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            rq.sendSuccess(response.getMetadata(), response.getData());
        }
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_rwr_auth_stateRequest rpcrq = (OSD.xtreemfs_rwr_auth_stateRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

