/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class InternalRWRFetchOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public InternalRWRFetchOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 73;
    }

    @Override
    public void startRequest(OSDRequest rq) {
        OSD.xtreemfs_rwr_fetchRequest args = (OSD.xtreemfs_rwr_fetchRequest)rq.getRequestArgs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "RWR fetch request for file %s-%d", args.getFileId(), args.getObjectNumber());
        }
        this.fetchObject(rq, args);
    }

    public void fetchObject(final OSDRequest rq, OSD.xtreemfs_rwr_fetchRequest args) {
        this.master.getStorageStage().readObject(rq.getFileId(), args.getObjectNumber(), rq.getLocationList().getLocalReplica().getStripingPolicy(), 0, -1, 0L, rq, new StorageStage.ReadObjectCallback(){

            @Override
            public void readComplete(ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
                if (error != null) {
                    InternalRWRFetchOperation.this.sendResult(rq, null, error);
                } else {
                    InternalObjectData odata = new InternalObjectData(0, false, 0, result.getData());
                    InternalRWRFetchOperation.this.sendResult(rq, odata, null);
                }
            }
        });
    }

    public void sendResult(OSDRequest rq, InternalObjectData response, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            rq.sendSuccess(response.getMetadata(), response.getData());
        }
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_rwr_fetchRequest rpcrq = (OSD.xtreemfs_rwr_fetchRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public boolean bypassViewValidation() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

