/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class InternalRWRTruncateOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public InternalRWRTruncateOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 74;
    }

    @Override
    public void startRequest(OSDRequest rq) {
        OSD.xtreemfs_rwr_truncateRequest args = (OSD.xtreemfs_rwr_truncateRequest)rq.getRequestArgs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "RWR truncate for file %s objVer %d", args.getFileId(), args.getObjectVersion());
        }
        this.prepareLocalTruncate(rq, args);
    }

    public void localTruncate(final OSDRequest rq, OSD.xtreemfs_rwr_truncateRequest args) {
        if (args.getNewFileSize() < 0L) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "new_file_size for truncate must be >= 0");
            return;
        }
        this.master.getStorageStage().truncate(args.getFileId(), args.getNewFileSize(), rq.getLocationList().getLocalReplica().getStripingPolicy(), rq.getLocationList().getLocalReplica(), rq.getCapability().getEpochNo(), rq.getCowPolicy(), args.getObjectVersion(), true, rq, new StorageStage.TruncateCallback(){

            @Override
            public void truncateComplete(GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
                InternalRWRTruncateOperation.this.sendResult(rq, error);
            }
        });
    }

    public void prepareLocalTruncate(final OSDRequest rq, final OSD.xtreemfs_rwr_truncateRequest args) {
        this.master.getRWReplicationStage().prepareOperation(args.getFileCredentials(), rq.getLocationList(), 0L, args.getObjectVersion(), RWReplicationStage.Operation.INTERNAL_TRUNCATE, new RWReplicationStage.RWReplicationCallback(){

            @Override
            public void success(long newObjectVersion) {
                InternalRWRTruncateOperation.this.localTruncate(rq, args);
            }

            @Override
            public void redirect(String redirectTo) {
                rq.getRPCRequest().sendRedirect(redirectTo);
            }

            @Override
            public void failed(RPC.RPCHeader.ErrorResponse err) {
                rq.sendError(err);
            }
        }, rq);
    }

    public void sendResult(OSDRequest rq, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            this.sendResponse(rq);
        }
    }

    public void sendResponse(OSDRequest rq) {
        rq.sendSuccess(null, null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_rwr_truncateRequest rpcrq = (OSD.xtreemfs_rwr_truncateRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

