/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.storage.CowPolicy;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class InternalRWRUpdateOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public InternalRWRUpdateOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 72;
    }

    @Override
    public void startRequest(OSDRequest rq) {
        OSD.xtreemfs_rwr_updateRequest args = (OSD.xtreemfs_rwr_updateRequest)rq.getRequestArgs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "RWR update for file %s-%d", args.getFileId(), args.getObjectNumber());
        }
        this.prepareLocalWrite(rq, args);
    }

    public void localWrite(final OSDRequest rq, OSD.xtreemfs_rwr_updateRequest args) {
        this.master.replicatedDataReceived(rq.getRPCRequest().getData().capacity());
        ReusableBuffer viewBuffer = rq.getRPCRequest().getData().createViewBuffer();
        this.master.getStorageStage().writeObject(args.getFileId(), args.getObjectNumber(), rq.getLocationList().getLocalReplica().getStripingPolicy(), args.getOffset(), viewBuffer, CowPolicy.PolicyNoCow, rq.getLocationList(), false, args.getObjectVersion(), rq, viewBuffer, new StorageStage.WriteObjectCallback(){

            @Override
            public void writeComplete(GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
                InternalRWRUpdateOperation.this.sendResult(rq, error);
            }
        });
    }

    public void prepareLocalWrite(final OSDRequest rq, final OSD.xtreemfs_rwr_updateRequest args) {
        this.master.getRWReplicationStage().prepareOperation(args.getFileCredentials(), rq.getLocationList(), args.getObjectNumber(), args.getObjectVersion(), RWReplicationStage.Operation.INTERNAL_UPDATE, new RWReplicationStage.RWReplicationCallback(){

            @Override
            public void success(long newObjectVersion) {
                InternalRWRUpdateOperation.this.localWrite(rq, args);
            }

            @Override
            public void redirect(String redirectTo) {
                rq.getRPCRequest().sendRedirect(redirectTo);
            }

            @Override
            public void failed(RPC.RPCHeader.ErrorResponse err) {
                rq.sendError(err);
            }
        }, rq);
    }

    public void sendResult(OSDRequest rq, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            this.sendResponse(rq);
        }
    }

    public void sendResponse(OSDRequest rq) {
        rq.sendSuccess(null, null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_rwr_updateRequest rpcrq = (OSD.xtreemfs_rwr_updateRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

