/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.PreprocStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class InvalidateXLocSetOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public InvalidateXLocSetOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 81;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        OSD.xtreemfs_xloc_set_invalidateRequest rpcrq = (OSD.xtreemfs_xloc_set_invalidateRequest)rq.getRequestArgs();
        this.master.getPreprocStage().invalidateXLocSet(rq, rpcrq.getFileCredentials(), true, new PreprocStage.InvalidateXLocSetCallback(){

            @Override
            public void invalidateComplete(GlobalTypes.LeaseState leaseState, RPC.RPCHeader.ErrorResponse error) {
                if (error != null) {
                    rq.sendError(error);
                } else {
                    InvalidateXLocSetOperation.this.postInvalidation(rq, leaseState);
                }
            }
        });
    }

    private void postInvalidation(final OSDRequest rq, final GlobalTypes.LeaseState leaseState) {
        if (rq.getLocationList().getReplicaUpdatePolicy().equals("ronly")) {
            this.invalidationFinished(rq, leaseState, null);
        } else {
            this.master.getStorageStage().internalGetReplicaState(rq.getFileId(), rq.getLocationList().getLocalReplica().getStripingPolicy(), 0L, new StorageStage.InternalGetReplicaStateCallback(){

                @Override
                public void getReplicaStateComplete(OSD.ReplicaStatus localState, RPC.RPCHeader.ErrorResponse error) {
                    if (error != null) {
                        rq.sendError(error);
                    } else {
                        InvalidateXLocSetOperation.this.invalidationFinished(rq, leaseState, localState);
                    }
                }
            });
        }
    }

    private void invalidationFinished(OSDRequest rq, GlobalTypes.LeaseState leaseState, OSD.ReplicaStatus localState) {
        OSD.xtreemfs_xloc_set_invalidateResponse.Builder response = OSD.xtreemfs_xloc_set_invalidateResponse.newBuilder();
        response.setLeaseState(leaseState);
        if (localState != null) {
            response.setReplicaStatus(localState);
        }
        rq.sendSuccess(response.build(), null);
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_xloc_set_invalidateRequest rpcrq = (OSD.xtreemfs_xloc_set_invalidateRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public boolean bypassViewValidation() {
        return true;
    }
}

