/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class LocalReadOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public LocalReadOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 43;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        final OSD.xtreemfs_internal_read_localRequest args = (OSD.xtreemfs_internal_read_localRequest)rq.getRequestArgs();
        if (args.getObjectNumber() < 0L) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "object number must be >= 0");
            return;
        }
        StripingPolicyImpl sp = rq.getLocationList().getLocalReplica().getStripingPolicy();
        this.master.getStorageStage().readObject(args.getFileId(), args.getObjectNumber(), sp, args.getOffset(), args.getLength(), rq.getCapability().getSnapConfig() == GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP ? rq.getCapability().getSnapTimestamp() : 0L, rq, new StorageStage.ReadObjectCallback(){

            @Override
            public void readComplete(ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
                LocalReadOperation.this.postRead(rq, args, result, error);
            }
        });
    }

    public void postRead(final OSDRequest rq, final OSD.xtreemfs_internal_read_localRequest args, final ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else if (args.getAttachObjectList()) {
            this.master.getStorageStage().getObjectSet(args.getFileId(), rq.getLocationList().getLocalReplica().getStripingPolicy(), rq, new StorageStage.GetObjectListCallback(){

                @Override
                public void getObjectSetComplete(ObjectSet objectSet, RPC.RPCHeader.ErrorResponse error) {
                    LocalReadOperation.this.postReadObjectSet(rq, args, result, objectSet, error);
                }
            });
        } else {
            this.readFinish(rq, args, result, null);
        }
    }

    public void postReadObjectSet(OSDRequest rq, OSD.xtreemfs_internal_read_localRequest args, ObjectInformation data, ObjectSet result, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            Object objectSetBuffer = null;
            try {
                byte[] serialized = result.getSerializedBitSet();
                OSD.ObjectList objList = OSD.ObjectList.newBuilder().setSet(ByteString.copyFrom(serialized)).setFirst(result.getFirstObjectNo()).setStripeWidth(result.getStripeWidth()).build();
                this.readFinish(rq, args, data, objList);
            }
            catch (IOException e) {
                rq.sendInternalServerError(e);
            }
        }
    }

    private void readFinish(OSDRequest rq, OSD.xtreemfs_internal_read_localRequest args, ObjectInformation result, OSD.ObjectList objectList) {
        InternalObjectData data = null;
        if (result.getStatus() == ObjectInformation.ObjectStatus.EXISTS) {
            boolean isRangeRequested;
            boolean bl = isRangeRequested = args.getOffset() > 0 || args.getLength() < result.getStripeSize();
            data = isRangeRequested ? result.getObjectData(true, args.getOffset(), args.getLength()) : new InternalObjectData(0, result.isChecksumInvalidOnOSD(), 0, result.getData());
        } else if (result.getStatus() == ObjectInformation.ObjectStatus.PADDING_OBJECT) {
            boolean isRangeRequested;
            boolean bl = isRangeRequested = args.getOffset() > 0 || args.getLength() < result.getStripeSize();
            data = isRangeRequested ? result.getObjectData(true, args.getOffset(), args.getLength()) : result.getObjectData(false, 0, args.getLength());
        } else {
            data = new InternalObjectData(0, result.isChecksumInvalidOnOSD(), 0, null);
        }
        this.master.objectSent();
        if (data.getData() != null) {
            this.master.dataSent(data.getData().capacity());
        }
        this.sendResponse(rq, data, objectList);
    }

    public void sendResponse(OSDRequest rq, InternalObjectData result, OSD.ObjectList objectList) {
        OSD.InternalReadLocalResponse.Builder readLocalResponse = OSD.InternalReadLocalResponse.newBuilder().setData(result.getMetadata());
        if (objectList != null) {
            readLocalResponse.addObjectSet(objectList);
        }
        rq.sendSuccess(readLocalResponse.build(), result.getData());
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_internal_read_localRequest rpcrq = (OSD.xtreemfs_internal_read_localRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

