/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.PreprocStage;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class LockReleaseOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public LockReleaseOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 52;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        final OSD.lockRequest args = (OSD.lockRequest)rq.getRequestArgs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.all, this, "lock_release for file %s by %010d%s", args.getFileCredentials().getXcap().getFileId(), args.getLockRequest().getClientPid(), args.getLockRequest().getClientUuid(), args.getLockRequest().getOffset(), args.getLockRequest().getLength());
        }
        this.master.getPreprocStage().unlock(args.getLockRequest().getClientUuid(), args.getLockRequest().getClientPid(), args.getFileCredentials().getXcap().getFileId(), rq, new PreprocStage.LockOperationCompleteCallback(){

            @Override
            public void parseComplete(OSD.Lock result, RPC.RPCHeader.ErrorResponse error) {
                LockReleaseOperation.this.postAcquireLock(rq, args, result, error);
            }
        });
    }

    public void postAcquireLock(OSDRequest rq, OSD.lockRequest args, OSD.Lock lock, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            rq.sendSuccess(lock, null);
        }
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.lockRequest rpcrq = (OSD.lockRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileCredentials().getXcap().getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

