/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;

public abstract class OSDOperation {
    protected OSDRequestDispatcher master;

    public OSDOperation(OSDRequestDispatcher master) {
        this.master = master;
    }

    public abstract int getProcedureId();

    public abstract void startRequest(OSDRequest var1);

    public abstract void startInternalEvent(Object[] var1);

    public abstract RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest var1);

    public abstract boolean requiresCapability();

    public boolean bypassViewValidation() {
        return false;
    }

    public void waitForResponses(final RPCResponse[] responses, final ResponsesListener listener) {
        assert (responses.length > 0);
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicReferenceArray stackTracePerRequest = new AtomicReferenceArray(responses.length);
        RPCResponseAvailableListener l = new RPCResponseAvailableListener(){

            public void responseAvailable(RPCResponse r) {
                for (int i = 0; i < responses.length; ++i) {
                    if (responses[i] != r) continue;
                    if (stackTracePerRequest.compareAndSet(i, null, Thread.currentThread().getStackTrace())) break;
                    StackTraceElement[] previousStackTrace = (StackTraceElement[])stackTracePerRequest.get(i);
                    StringBuffer strace = new StringBuffer();
                    for (int i1 = previousStackTrace.length - 1; i1 >= 0; --i1) {
                        strace.append("\t");
                        strace.append(previousStackTrace[i1].toString());
                    }
                    throw new RuntimeException("responseAvailable() was already called here:\n" + strace.toString());
                }
                if (count.incrementAndGet() == responses.length) {
                    listener.responsesAvailable();
                }
            }
        };
        for (RPCResponse r : responses) {
            r.registerListener(l);
        }
    }

    public static interface ResponsesListener {
        public void responsesAvailable();
    }
}

