/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.PreprocStage;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public final class RWRNotifyOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public RWRNotifyOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 75;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        GlobalTypes.FileCredentials args = (GlobalTypes.FileCredentials)rq.getRequestArgs();
        if (!rq.getLocationList().containsOSD(this.localUUID)) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "RWR notify for file %s: REMOVE REPLICA", args.getXcap().getFileId());
            }
            this.master.getPreprocStage().checkDeleteOnClose(args.getXcap().getFileId(), new PreprocStage.DeleteOnCloseCallback(){

                @Override
                public void deleteOnCloseResult(boolean isDeleteOnClose, RPC.RPCHeader.ErrorResponse error) {
                    RWRNotifyOperation.this.sendResult(rq, error);
                }
            });
        } else {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "RWR notify for file %s: FORCE RESET", args.getXcap().getFileId());
            }
            this.master.getRWReplicationStage().eventForceReset(args, rq.getLocationList());
            this.sendResult(rq, null);
        }
    }

    public void sendResult(OSDRequest rq, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            this.sendResponse(rq);
        }
    }

    public void sendResponse(OSDRequest rq) {
        rq.sendSuccess(null, null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            GlobalTypes.FileCredentials rpcrq = (GlobalTypes.FileCredentials)rq.getRequestArgs();
            rq.setFileId(rpcrq.getXcap().getFileId());
            rq.setCapability(new Capability(rpcrq.getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

