/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import java.io.IOException;
import java.util.List;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.ReplicaUpdatePolicies;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.stages.ReplicationStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class ReadOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public ReadOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 10;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        final OSD.readRequest args = (OSD.readRequest)rq.getRequestArgs();
        if (args.getObjectNumber() < 0L) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "object number must be >= 0");
            return;
        }
        if (args.getOffset() < 0) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "offset must be >= 0");
            return;
        }
        if (args.getLength() < 0) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "length must be >= 0");
            return;
        }
        StripingPolicyImpl sp = rq.getLocationList().getLocalReplica().getStripingPolicy();
        if (args.getLength() + args.getOffset() > sp.getStripeSizeForObject(0L)) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "length + ofset must be <= " + sp.getStripeSizeForObject(0L) + " (stripe size)");
            return;
        }
        if (rq.getLocationList().getNumReplicas() > 1 && ReplicaUpdatePolicies.isRwReplicated(rq.getLocationList().getReplicaUpdatePolicy())) {
            this.rwReplicatedRead(rq, args);
        } else {
            long snapVerTS = rq.getCapability().getSnapConfig() == GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP ? rq.getCapability().getSnapTimestamp() : 0L;
            this.master.getStorageStage().readObject(args.getFileId(), args.getObjectNumber(), sp, args.getOffset(), args.getLength(), snapVerTS, rq, new StorageStage.ReadObjectCallback(){

                @Override
                public void readComplete(ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
                    ReadOperation.this.postRead(rq, args, result, error);
                }
            });
        }
    }

    public void rwReplicatedRead(final OSDRequest rq, final OSD.readRequest args) {
        this.master.getRWReplicationStage().prepareOperation(args.getFileCredentials(), rq.getLocationList(), args.getObjectNumber(), args.getObjectVersion(), RWReplicationStage.Operation.READ, new RWReplicationStage.RWReplicationCallback(){

            @Override
            public void success(long newObjectVersion) {
                StripingPolicyImpl sp = rq.getLocationList().getLocalReplica().getStripingPolicy();
                long snapVerTS = rq.getCapability().getSnapConfig() == GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP ? rq.getCapability().getSnapTimestamp() : 0L;
                ReadOperation.this.master.getStorageStage().readObject(args.getFileId(), args.getObjectNumber(), sp, args.getOffset(), args.getLength(), snapVerTS, rq, new StorageStage.ReadObjectCallback(){

                    @Override
                    public void readComplete(ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
                        ReadOperation.this.postRead(rq, args, result, error);
                    }
                });
            }

            @Override
            public void redirect(String redirectTo) {
                rq.getRPCRequest().sendRedirect(redirectTo);
            }

            @Override
            public void failed(RPC.RPCHeader.ErrorResponse err) {
                rq.sendError(err);
            }
        }, rq);
    }

    public void postRead(OSDRequest rq, OSD.readRequest args, ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else if (result.getStatus() == ObjectInformation.ObjectStatus.DOES_NOT_EXIST && rq.getLocationList().getReplicaUpdatePolicy().equals("ronly") && rq.getLocationList().getNumReplicas() > 1 && !rq.getLocationList().getLocalReplica().isComplete()) {
            this.readReplica(rq, args);
        } else if (rq.getLocationList().getLocalReplica().isStriped()) {
            this.stripedRead(rq, args, result);
        } else {
            this.nonStripedRead(rq, args, result);
        }
    }

    private void nonStripedRead(OSDRequest rq, OSD.readRequest args, ObjectInformation result) {
        boolean isLastObjectOrEOF = result.getLastLocalObjectNo() <= args.getObjectNumber();
        this.readFinish(rq, args, result, isLastObjectOrEOF);
    }

    private void stripedRead(final OSDRequest rq, final OSD.readRequest args, final ObjectInformation result) {
        boolean isLastObjectLocallyKnown;
        long objNo = args.getObjectNumber();
        long lastKnownObject = Math.max(result.getLastLocalObjectNo(), result.getGlobalLastObjectNo());
        boolean bl = isLastObjectLocallyKnown = lastKnownObject <= objNo;
        if (objNo > lastKnownObject || objNo == lastKnownObject && result.getData() != null && result.getData().remaining() < result.getStripeSize()) {
            try {
                List<ServiceUUID> osds = rq.getLocationList().getLocalReplica().getOSDs();
                final RPCResponse[] gmaxRPCs = new RPCResponse[osds.size() - 1];
                int cnt = 0;
                for (ServiceUUID osd : osds) {
                    if (osd.equals(this.localUUID)) continue;
                    gmaxRPCs[cnt++] = this.master.getOSDClient().xtreemfs_internal_get_gmax(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, args.getFileCredentials(), args.getFileId());
                }
                this.waitForResponses(gmaxRPCs, new OSDOperation.ResponsesListener(){

                    @Override
                    public void responsesAvailable() {
                        ReadOperation.this.stripedReadAnalyzeGmax(rq, args, result, gmaxRPCs);
                    }
                });
            }
            catch (IOException ex) {
                rq.sendInternalServerError(ex);
                return;
            }
        } else {
            this.readFinish(rq, args, result, isLastObjectLocallyKnown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripedReadAnalyzeGmax(OSDRequest rq, OSD.readRequest args, ObjectInformation result, RPCResponse[] gmaxRPCs) {
        long maxObjNo = -1L;
        long maxTruncate = -1L;
        try {
            for (int i = 0; i < gmaxRPCs.length; ++i) {
                OSD.InternalGmax gmax = (OSD.InternalGmax)gmaxRPCs[i].get();
                if (gmax.getLastObjectId() <= maxObjNo || gmax.getEpoch() < maxTruncate) continue;
                maxObjNo = gmax.getLastObjectId();
                maxTruncate = gmax.getEpoch();
            }
            boolean isLastObjectLocallyKnown = maxObjNo <= args.getObjectNumber();
            this.readFinish(rq, args, result, isLastObjectLocallyKnown);
            if (args.getFileCredentials().getXcap().getSnapConfig() == GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP) {
                return;
            }
            this.master.getStorageStage().receivedGMAX_ASYNC(args.getFileId(), maxTruncate, maxObjNo);
        }
        catch (Exception ex) {
            rq.sendInternalServerError(ex);
        }
        finally {
            for (RPCResponse r : gmaxRPCs) {
                r.freeBuffers();
            }
        }
    }

    private void readFinish(OSDRequest rq, OSD.readRequest args, ObjectInformation result, boolean isLastObjectOrEOF) {
        InternalObjectData data = result.getObjectData(isLastObjectOrEOF, args.getOffset(), args.getLength());
        int datasize = 0;
        if (data.getData() != null) {
            datasize = data.getData().remaining();
        }
        assert (isLastObjectOrEOF && (datasize += data.getZero_padding()) <= args.getLength() || !isLastObjectOrEOF && datasize == args.getLength());
        if (Logging.isDebug() && datasize == 0) {
            Logging.logMessage(7, Logging.Category.stage, this, "zero data response (EOF), file %s", args.getFileId());
        }
        this.master.objectSent();
        if (data.getData() != null) {
            this.master.dataSent(data.getData().capacity());
        }
        this.sendResponse(rq, data);
    }

    private void readReplica(final OSDRequest rq, final OSD.readRequest args) {
        XLocations xLoc = rq.getLocationList();
        StripingPolicyImpl sp = xLoc.getLocalReplica().getStripingPolicy();
        if (args.getObjectNumber() > sp.getObjectNoForOffset(xLoc.getXLocSet().getReadOnlyFileSize() - 1L)) {
            ObjectInformation objectInfo = new ObjectInformation(ObjectInformation.ObjectStatus.DOES_NOT_EXIST, null, sp.getStripeSizeForObject(args.getObjectNumber()));
            objectInfo.setGlobalLastObjectNo(xLoc.getXLocSet().getReadOnlyFileSize());
            this.readFinish(rq, args, objectInfo, true);
        } else {
            this.master.getReplicationStage().fetchObject(args.getFileId(), args.getObjectNumber(), xLoc, rq.getCapability(), rq.getCowPolicy(), rq, new ReplicationStage.FetchObjectCallback(){

                @Override
                public void fetchComplete(ObjectInformation objectInfo, RPC.RPCHeader.ErrorResponse error) {
                    ReadOperation.this.postReadReplica(rq, args, objectInfo, error);
                }
            });
        }
    }

    public void postReadReplica(OSDRequest rq, OSD.readRequest args, ObjectInformation result, RPC.RPCHeader.ErrorResponse error) {
        XLocations xLoc = rq.getLocationList();
        StripingPolicyImpl sp = xLoc.getLocalReplica().getStripingPolicy();
        if (error != null) {
            rq.sendError(error);
        } else {
            try {
                if ((args.getOffset() > 0 || args.getLength() < result.getStripeSize()) && result.getStatus() == ObjectInformation.ObjectStatus.EXISTS) {
                    int availData = result.getData().remaining();
                    if (availData - args.getOffset() <= 0) {
                        BufferPool.free(result.getData());
                        result.setData(BufferPool.allocate(0));
                    } else if (availData - args.getOffset() >= args.getLength()) {
                        result.getData().range(args.getOffset(), args.getLength());
                    } else {
                        result.getData().range(args.getOffset(), availData - args.getOffset());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                rq.sendInternalServerError(ex);
                return;
            }
            if (args.getObjectNumber() == sp.getObjectNoForOffset(xLoc.getXLocSet().getReadOnlyFileSize() - 1L)) {
                this.readFinish(rq, args, result, true);
            } else {
                this.readFinish(rq, args, result, false);
            }
        }
    }

    public void sendResponse(OSDRequest rq, InternalObjectData result) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.net, this, result.toString(), new Object[0]);
        }
        rq.sendSuccess(result.getMetadata(), result.getData());
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.readRequest rpcrq = (OSD.readRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileCredentials().getXcap().getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

