/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.ReplicationStage;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class RepairObjectOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public RepairObjectOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 36;
    }

    @Override
    public void startRequest(OSDRequest rq) {
        String replPolicy;
        OSD.xtreemfs_repair_objectRequest args = (OSD.xtreemfs_repair_objectRequest)rq.getRequestArgs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "Repair object request for file %s-%d", args.getFileId(), args.getObjectNumber());
        }
        if ((replPolicy = rq.getLocationList().getReplicaUpdatePolicy()).equals("ronly")) {
            this.repairROnlyObject(rq, args);
        } else {
            this.repairRWObject(rq, args);
        }
    }

    private void repairROnlyObject(final OSDRequest rq, OSD.xtreemfs_repair_objectRequest args) {
        if (rq.getLocationList().getLocalReplica().isComplete()) {
            rq.getLocationList().getLocalReplica().resetCompleteFlagAndRestoreStrageyFlag();
        }
        this.master.getReplicationStage().fetchObject(args.getFileId(), args.getObjectNumber(), rq.getLocationList(), rq.getCapability(), rq.getCowPolicy(), rq, new ReplicationStage.FetchObjectCallback(){

            @Override
            public void fetchComplete(ObjectInformation objectInfo, RPC.RPCHeader.ErrorResponse error) {
                if (error == null) {
                    rq.sendSuccess(null, null);
                } else {
                    rq.sendError(error);
                }
            }
        });
    }

    private void repairRWObject(OSDRequest rq, OSD.xtreemfs_repair_objectRequest args) {
    }

    @Override
    public void startInternalEvent(Object[] args) {
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.xtreemfs_repair_objectRequest rpcrq = (OSD.xtreemfs_repair_objectRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }
}

