/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;

public class ShutdownOperation
extends OSDOperation {
    public ShutdownOperation(OSDRequestDispatcher master) {
        super(master);
    }

    @Override
    public int getProcedureId() {
        return 70;
    }

    @Override
    public void startRequest(OSDRequest rq) {
        RPC.Auth authData = rq.getRPCRequest().getHeader().getRequestHeader().getAuthData();
        if (this.master.getConfig().getAdminPassword().length() > 0 && !this.master.getConfig().getAdminPassword().equals(authData.getAuthPasswd())) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "this operation requires an admin password");
            return;
        }
        try {
            rq.sendSuccess(null, null);
            Thread.sleep(100L);
            this.master.asyncShutdown();
        }
        catch (Throwable thr) {
            Logging.logMessage(3, this, "exception during shutdown", new Object[0]);
            Logging.logError(3, this, thr);
        }
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        rq.setFileId("");
        return null;
    }

    @Override
    public boolean requiresCapability() {
        return false;
    }
}

