/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import java.io.IOException;
import java.util.List;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.ReplicaUpdatePolicies;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class TruncateOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public TruncateOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 11;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        final OSD.truncateRequest args = (OSD.truncateRequest)rq.getRequestArgs();
        if (args.getNewFileSize() < 0L) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "new_file_size for truncate must be >= 0");
            return;
        }
        if (!rq.getLocationList().getLocalReplica().getHeadOsd().equals(this.localUUID)) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "truncate must be executed at the head OSD (first OSD in replica)");
            return;
        }
        if (rq.getLocationList().getReplicaUpdatePolicy().equals("ronly")) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EPERM, "Cannot write on read-only files.");
            return;
        }
        if (rq.getLocationList().getNumReplicas() > 1 && ReplicaUpdatePolicies.isRwReplicated(rq.getLocationList().getReplicaUpdatePolicy())) {
            this.rwReplicatedTruncate(rq, args);
        } else {
            this.master.getStorageStage().truncate(args.getFileId(), args.getNewFileSize(), rq.getLocationList().getLocalReplica().getStripingPolicy(), rq.getLocationList().getLocalReplica(), rq.getCapability().getEpochNo(), rq.getCowPolicy(), null, false, rq, new StorageStage.TruncateCallback(){

                @Override
                public void truncateComplete(GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
                    TruncateOperation.this.step2(rq, args, result, error);
                }
            });
        }
    }

    public void rwReplicatedTruncate(final OSDRequest rq, final OSD.truncateRequest args) {
        this.master.getRWReplicationStage().prepareOperation(args.getFileCredentials(), rq.getLocationList(), 0L, 0L, RWReplicationStage.Operation.TRUNCATE, new RWReplicationStage.RWReplicationCallback(){

            @Override
            public void success(final long newObjectVersion) {
                StripingPolicyImpl sp = rq.getLocationList().getLocalReplica().getStripingPolicy();
                TruncateOperation.this.master.getStorageStage().truncate(args.getFileId(), args.getNewFileSize(), rq.getLocationList().getLocalReplica().getStripingPolicy(), rq.getLocationList().getLocalReplica(), rq.getCapability().getEpochNo(), rq.getCowPolicy(), newObjectVersion, true, rq, new StorageStage.TruncateCallback(){

                    @Override
                    public void truncateComplete(GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
                        TruncateOperation.this.replicateTruncate(rq, newObjectVersion, args, result, error);
                    }
                });
            }

            @Override
            public void redirect(String redirectTo) {
                rq.getRPCRequest().sendRedirect(redirectTo);
            }

            @Override
            public void failed(RPC.RPCHeader.ErrorResponse err) {
                rq.sendError(err);
            }
        }, rq);
    }

    public void replicateTruncate(final OSDRequest rq, long newObjVersion, final OSD.truncateRequest args, final GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            this.step2(rq, args, result, error);
        } else {
            this.master.getRWReplicationStage().replicateTruncate(args.getFileCredentials(), rq.getLocationList(), args.getNewFileSize(), newObjVersion, new RWReplicationStage.RWReplicationCallback(){

                @Override
                public void success(long newObjectVersion) {
                    TruncateOperation.this.step2(rq, args, result, null);
                }

                @Override
                public void redirect(String redirectTo) {
                    rq.getRPCRequest().sendRedirect(redirectTo);
                }

                @Override
                public void failed(RPC.RPCHeader.ErrorResponse err) {
                    rq.sendError(err);
                }
            }, rq);
        }
    }

    public void step2(OSDRequest rq, OSD.truncateRequest args, GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else if (rq.getLocationList().getLocalReplica().isStriped()) {
            this.disseminateTruncates(rq, args, result);
        } else {
            this.sendResponse(rq, result);
        }
    }

    private void disseminateTruncates(final OSDRequest rq, OSD.truncateRequest args, final GlobalTypes.OSDWriteResponse result) {
        try {
            List<ServiceUUID> osds = rq.getLocationList().getLocalReplica().getOSDs();
            final RPCResponse[] gmaxRPCs = new RPCResponse[osds.size() - 1];
            int cnt = 0;
            for (ServiceUUID osd : osds) {
                if (osd.equals(this.localUUID)) continue;
                gmaxRPCs[cnt++] = this.master.getOSDClient().xtreemfs_internal_truncate(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, args.getFileCredentials(), args.getFileId(), args.getNewFileSize());
            }
            this.waitForResponses(gmaxRPCs, new OSDOperation.ResponsesListener(){

                @Override
                public void responsesAvailable() {
                    TruncateOperation.this.analyzeTruncateResponses(rq, result, gmaxRPCs);
                }
            });
        }
        catch (IOException ex) {
            rq.sendInternalServerError(ex);
        }
        catch (Throwable ex) {
            rq.sendInternalServerError(ex);
            Logging.logError(3, this, ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeTruncateResponses(OSDRequest rq, GlobalTypes.OSDWriteResponse result, RPCResponse[] gmaxRPCs) {
        try {
            for (int i = 0; i < gmaxRPCs.length; ++i) {
                gmaxRPCs[i].get();
            }
            this.sendResponse(rq, result);
        }
        catch (IOException ex) {
            rq.sendInternalServerError(ex);
        }
        catch (Throwable ex) {
            rq.sendInternalServerError(ex);
            Logging.logError(3, this, ex);
        }
        finally {
            for (RPCResponse r : gmaxRPCs) {
                r.freeBuffers();
            }
        }
    }

    public void sendResponse(OSDRequest rq, GlobalTypes.OSDWriteResponse result) {
        rq.sendSuccess(result, null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.truncateRequest rpcrq = (OSD.truncateRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

