/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import java.net.InetSocketAddress;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.stages.VivaldiStage;
import org.xtreemfs.osd.vivaldi.VivaldiNode;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class VivaldiPingOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public VivaldiPingOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 60;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        OSD.xtreemfs_pingMesssage args = (OSD.xtreemfs_pingMesssage)rq.getRequestArgs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.all, this, "vivaldi ping with coordinates %s", VivaldiNode.coordinatesToString(args.getCoordinates()));
        }
        if (rq.getRPCRequest().getConnection().getChannel() == null) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.all, this, "Async Ping", new Object[0]);
            }
            this.master.getVivaldiStage().getVivaldiCoordinatesAsync(args, (InetSocketAddress)rq.getRPCRequest().getSenderAddress(), rq);
        } else {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.all, this, "Sync Ping", new Object[0]);
            }
            this.master.getVivaldiStage().getVivaldiCoordinatesSync(args, rq, new VivaldiStage.VivaldiPingCallback(){

                @Override
                public void coordinatesCallback(GlobalTypes.VivaldiCoordinates myCoordinates, RPC.RPCHeader.ErrorResponse error) {
                    OSD.xtreemfs_pingMesssage msg = OSD.xtreemfs_pingMesssage.newBuilder().setCoordinates(myCoordinates).setRequestResponse(false).build();
                    rq.sendSuccess(msg, null);
                }
            });
        }
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        rq.setFileId("");
        return null;
    }

    @Override
    public boolean requiresCapability() {
        return false;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

