/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.common.ReplicaUpdatePolicies;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public final class WriteOperation
extends OSDOperation {
    final String sharedSecret;
    final ServiceUUID localUUID;

    public WriteOperation(OSDRequestDispatcher master) {
        super(master);
        this.sharedSecret = master.getConfig().getCapabilitySecret();
        this.localUUID = master.getConfig().getUUID();
    }

    @Override
    public int getProcedureId() {
        return 13;
    }

    @Override
    public void startRequest(final OSDRequest rq) {
        OSD.writeRequest args = (OSD.writeRequest)rq.getRequestArgs();
        if (args.getObjectNumber() < 0L) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "object number must be >= 0");
            return;
        }
        if (args.getOffset() < 0) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "offset must be >= 0");
            return;
        }
        StripingPolicyImpl sp = rq.getLocationList().getLocalReplica().getStripingPolicy();
        if (args.getOffset() >= sp.getStripeSizeForObject(args.getObjectNumber())) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "offset must be < stripe size");
            return;
        }
        if (rq.getLocationList().getReplicaUpdatePolicy().equals("ronly")) {
            rq.sendError(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EPERM, "Cannot write on read-only files.");
        } else {
            boolean syncWrite = (rq.getCapability().getAccessMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_SYNC.getNumber()) > 0;
            this.master.objectReceived();
            this.master.dataReceived(rq.getRPCRequest().getData().capacity());
            if (rq.getLocationList().getNumReplicas() > 1 && ReplicaUpdatePolicies.isRwReplicated(rq.getLocationList().getReplicaUpdatePolicy())) {
                this.replicatedWrite(rq, args, syncWrite);
            } else {
                ReusableBuffer viewBuffer = rq.getRPCRequest().getData().createViewBuffer();
                this.master.getStorageStage().writeObject(args.getFileId(), args.getObjectNumber(), sp, args.getOffset(), viewBuffer, rq.getCowPolicy(), rq.getLocationList(), syncWrite, null, rq, viewBuffer, new StorageStage.WriteObjectCallback(){

                    @Override
                    public void writeComplete(GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
                        WriteOperation.this.sendResult(rq, result, error);
                    }
                });
            }
        }
    }

    public void replicatedWrite(final OSDRequest rq, final OSD.writeRequest args, final boolean syncWrite) {
        this.master.getRWReplicationStage().prepareOperation(args.getFileCredentials(), rq.getLocationList(), args.getObjectNumber(), args.getObjectVersion(), RWReplicationStage.Operation.WRITE, new RWReplicationStage.RWReplicationCallback(){

            @Override
            public void success(final long newObjectVersion) {
                assert (newObjectVersion > 0L);
                ReusableBuffer viewBuffer = rq.getRPCRequest().getData().createViewBuffer();
                WriteOperation.this.master.getStorageStage().writeObject(args.getFileId(), args.getObjectNumber(), rq.getLocationList().getLocalReplica().getStripingPolicy(), args.getOffset(), viewBuffer, rq.getCowPolicy(), rq.getLocationList(), syncWrite, newObjectVersion, rq, viewBuffer, new StorageStage.WriteObjectCallback(){

                    @Override
                    public void writeComplete(GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
                        if (error != null) {
                            WriteOperation.this.sendResult(rq, null, error);
                        } else {
                            WriteOperation.this.sendUpdates(rq, args, result, newObjectVersion);
                        }
                    }
                });
            }

            @Override
            public void redirect(String redirectTo) {
                rq.getRPCRequest().sendRedirect(redirectTo);
            }

            @Override
            public void failed(RPC.RPCHeader.ErrorResponse err) {
                rq.sendError(err);
            }
        }, rq);
    }

    public void sendUpdates(final OSDRequest rq, final OSD.writeRequest args, final GlobalTypes.OSDWriteResponse result, final long newObjVersion) {
        final StripingPolicyImpl sp = rq.getLocationList().getLocalReplica().getStripingPolicy();
        if (rq.getRPCRequest().getData().remaining() == sp.getStripeSizeForObject(args.getObjectNumber())) {
            ReusableBuffer viewBuffer = rq.getRPCRequest().getData().createViewBuffer();
            this.sendUpdates2(rq, args, result, newObjVersion, new InternalObjectData(args.getObjectData(), viewBuffer), viewBuffer);
        } else {
            this.master.getStorageStage().readObject(args.getFileId(), args.getObjectNumber(), sp, 0, -1, 0L, rq, new StorageStage.ReadObjectCallback(){

                @Override
                public void readComplete(ObjectInformation result2, RPC.RPCHeader.ErrorResponse error) {
                    if (error != null) {
                        WriteOperation.this.sendResult(rq, null, error);
                    } else {
                        InternalObjectData od = result2.getObjectData(false, 0, sp.getStripeSizeForObject(args.getObjectNumber()));
                        WriteOperation.this.sendUpdates2(rq, args, result, newObjVersion, od, null);
                    }
                }
            });
        }
    }

    public void sendUpdates2(final OSDRequest rq, OSD.writeRequest args, final GlobalTypes.OSDWriteResponse result, long newObjVersion, InternalObjectData data, ReusableBuffer createdViewBuffer) {
        this.master.getRWReplicationStage().replicatedWrite(args.getFileCredentials(), rq.getLocationList(), args.getObjectNumber(), newObjVersion, data, createdViewBuffer, new RWReplicationStage.RWReplicationCallback(){

            @Override
            public void success(long newObjectVersion) {
                WriteOperation.this.sendResult(rq, result, null);
            }

            @Override
            public void redirect(String redirectTo) {
                rq.getRPCRequest().sendRedirect(redirectTo);
            }

            @Override
            public void failed(RPC.RPCHeader.ErrorResponse err) {
                rq.sendError(err);
            }
        }, rq);
    }

    public void sendResult(OSDRequest rq, GlobalTypes.OSDWriteResponse result, RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            rq.sendError(error);
        } else {
            this.sendResponse(rq, result);
        }
    }

    public void sendResponse(OSDRequest rq, GlobalTypes.OSDWriteResponse result) {
        rq.sendSuccess(result, null);
    }

    @Override
    public RPC.RPCHeader.ErrorResponse parseRPCMessage(OSDRequest rq) {
        try {
            OSD.writeRequest rpcrq = (OSD.writeRequest)rq.getRequestArgs();
            rq.setFileId(rpcrq.getFileCredentials().getXcap().getFileId());
            rq.setCapability(new Capability(rpcrq.getFileCredentials().getXcap(), this.sharedSecret));
            rq.setLocationList(new XLocations(rpcrq.getFileCredentials().getXlocs(), this.localUUID));
            return null;
        }
        catch (InvalidXLocationsException ex) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, ex.toString());
        }
        catch (Throwable ex) {
            return ErrorUtils.getInternalServerError(ex);
        }
    }

    @Override
    public boolean requiresCapability() {
        return true;
    }

    @Override
    public void startInternalEvent(Object[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

