/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.LRUCache;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.monitoring.Monitoring;
import org.xtreemfs.foundation.monitoring.MonitoringLog;
import org.xtreemfs.foundation.monitoring.NumberMonitoring;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.replication.ReplicatingFile;
import org.xtreemfs.osd.replication.transferStrategies.TransferStrategy;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.storage.CowPolicy;

public class ObjectDissemination {
    private final OSDRequestDispatcher master;
    private static final int MAX_OBJECTS_IN_PROGRESS_OVERALL = 20;
    private ConcurrentHashMap<String, ReplicatingFile> filesInProgress;
    LRUCache<String, ReplicatingFile> lastCompletedFilesCache;
    private Thread monitoringThread = null;
    private NumberMonitoring monitoring;
    private AtomicLong monitoringReadDataSizeInLastXs;
    public static final String MONITORING_KEY_THROUGHPUT_OF_LAST_X_SECONDS = "REPLICATION: average throughput over all files of last X seconds (KB/s)";
    public static final int MONITORING_THROUGHPUT_INTERVAL = 1000;

    public ObjectDissemination(OSDRequestDispatcher master) {
        this.master = master;
        this.filesInProgress = new ConcurrentHashMap();
        this.lastCompletedFilesCache = new LRUCache(20);
        this.monitoring = new NumberMonitoring();
        this.monitoringReadDataSizeInLastXs = new AtomicLong(0L);
        if (Monitoring.isEnabled()) {
            try {
                MonitoringLog.initialize("");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            MonitoringLog.registerFor(this.monitoring, MONITORING_KEY_THROUGHPUT_OF_LAST_X_SECONDS);
            this.monitoringThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.interrupted()) {
                            Thread.sleep(1000L);
                            long sizeInLastXs = ObjectDissemination.this.monitoringReadDataSizeInLastXs.getAndSet(0L);
                            if (sizeInLastXs <= 0L) continue;
                            ObjectDissemination.this.monitoring.put(ObjectDissemination.MONITORING_KEY_THROUGHPUT_OF_LAST_X_SECONDS, (double)sizeInLastXs / 1024.0 / 1.0);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.monitoringThread.setDaemon(true);
            this.monitoringThread.start();
        }
    }

    public void fetchObject(String fileID, long objectNo, XLocations xLoc, Capability capability, CowPolicy cow, Stage.StageRequest rq) {
        ReplicatingFile file = this.filesInProgress.get(fileID);
        if (file == null) {
            file = (ReplicatingFile)this.lastCompletedFilesCache.get(fileID);
            if (file == null || file != null && file.hasXLocChanged(xLoc)) {
                file = new ReplicatingFile(fileID, xLoc, capability, cow, this.master);
            }
            this.filesInProgress.put(fileID, file);
            ReplicatingFile.setMaxObjectsInProgressPerFile(20 / this.filesInProgress.size());
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "%s - start replicating file", fileID);
            }
        }
        file.update(capability, xLoc, cow);
        if (file.isObjectInProgress(objectNo)) {
            file.addObjectForReplication(objectNo, rq);
        } else {
            block9: {
                file.addObjectForReplication(objectNo, rq);
                try {
                    file.replicate();
                }
                catch (TransferStrategy.TransferStrategyException e) {
                    if (e.getErrorCode() == TransferStrategy.TransferStrategyException.ErrorCode.NO_OSD_FOUND) {
                        file.reportError(ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, "no OSD could be found for fetching an object", e.getStackTrace().toString()));
                    }
                    if (e.getErrorCode() != TransferStrategy.TransferStrategyException.ErrorCode.NO_OSD_REACHABLE) break block9;
                    file.reportError(ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, "no OSD is reachable for fetching an object", e.getStackTrace().toString()));
                }
            }
            if (!file.isReplicating()) {
                this.fileCompleted(file.fileID);
            }
        }
    }

    public void objectFetched(String fileID, long objectNo, ServiceUUID usedOSD, InternalObjectData data) {
        ReplicatingFile file = this.filesInProgress.get(fileID);
        assert (file != null);
        this.monitoringReadDataSizeInLastXs.addAndGet(data.getData().limit());
        file.objectFetched(objectNo, usedOSD, data);
    }

    public void objectNotFetched(String fileID, ServiceUUID usedOSD, long objectNo, InternalObjectData data) {
        ReplicatingFile file = this.filesInProgress.get(fileID);
        assert (file != null);
        file.objectNotFetched(objectNo, usedOSD, data);
        if (!file.isReplicating()) {
            this.fileCompleted(file.fileID);
        }
    }

    public void objectNotFetchedBecauseError(String fileID, ServiceUUID usedOSD, long objectNo, RPC.RPCHeader.ErrorResponse error) {
        ReplicatingFile file = this.filesInProgress.get(fileID);
        assert (file != null);
        file.objectNotFetchedBecauseError(objectNo, usedOSD, error);
        if (!file.isReplicating()) {
            this.fileCompleted(file.fileID);
        }
    }

    private void fileCompleted(String fileID) {
        ReplicatingFile completedFile = this.filesInProgress.remove(fileID);
        assert (completedFile != null);
        if (completedFile.isStopped()) {
            this.lastCompletedFilesCache.remove(fileID);
        } else {
            this.lastCompletedFilesCache.put(fileID, completedFile);
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "%s - stop replicating file", fileID);
        }
        if (this.filesInProgress.size() == 0) {
            ReplicatingFile.setMaxObjectsInProgressPerFile(20);
        } else {
            ReplicatingFile.setMaxObjectsInProgressPerFile(20 / this.filesInProgress.size());
        }
    }

    public void cancelFile(String fileID) {
        ReplicatingFile file = this.filesInProgress.get(fileID);
        if (file != null) {
            if (file.isReplicating()) {
                file.stopReplicatingFile();
            } else {
                this.filesInProgress.remove(fileID);
            }
        }
    }

    public void objectSetFetched(String fileID, ServiceUUID osd, ObjectSet objectSet, long objectSetBytes) {
        ReplicatingFile file = this.filesInProgress.get(fileID);
        if (file != null) {
            file.objectSetFetched(osd, objectSet);
        }
    }

    public void sendError(String fileID, RPC.RPCHeader.ErrorResponse e) {
        ReplicatingFile file = this.filesInProgress.get(fileID);
        assert (file != null);
        file.reportError(e);
    }

    public void shutdown() {
        if (Monitoring.isEnabled() && this.monitoringThread != null) {
            this.monitoringThread.interrupt();
        }
    }

    public void startNewReplication(String fileID) {
        ReplicatingFile file = this.filesInProgress.get(fileID);
        if (file != null) {
            try {
                file.startNewReplication();
                if (!file.isReplicating()) {
                    this.fileCompleted(file.fileID);
                }
            }
            catch (TransferStrategy.TransferStrategyException e) {
                e.printStackTrace();
            }
        }
    }
}

