/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class ObjectSet
implements Iterable<Long> {
    public static final int DEFAULT_INITIAL_SIZE = 1024;
    protected BitSet objects;
    protected int stripeWidth;
    protected int firstObjectNo;
    protected Random random;

    public ObjectSet() {
        this(1, 0, 1024);
    }

    public ObjectSet(int initialSize) {
        this(1, 0, initialSize);
    }

    public ObjectSet(int stripeWidth, int firstObjectNo) {
        this(stripeWidth, firstObjectNo, 1024);
    }

    public ObjectSet(int stripeWidth, int firstObjectNo, int initialSize) {
        if (stripeWidth <= 0) {
            throw new IllegalArgumentException("stripeWidth must be > 0.");
        }
        if (firstObjectNo < 0) {
            throw new IllegalArgumentException("firstObjectNo must be >= 0.");
        }
        this.stripeWidth = stripeWidth;
        this.firstObjectNo = firstObjectNo;
        this.objects = new BitSet(initialSize);
    }

    public ObjectSet(int stripeWidth, int firstObjectNo, byte[] serializedBitSet) throws ClassCastException, IOException, ClassNotFoundException {
        this.objects = ObjectSet.deserializeAndDecompress(serializedBitSet);
        this.stripeWidth = stripeWidth;
        this.firstObjectNo = firstObjectNo;
    }

    public ObjectSet(ObjectSet objectSet) {
        this.stripeWidth = objectSet.stripeWidth;
        this.firstObjectNo = objectSet.firstObjectNo;
        this.objects = new BitSet(objectSet.objects.size());
        this.objects.or(objectSet.objects);
    }

    public boolean add(Long object) {
        if (!this.objects.get((int)(object / (long)this.stripeWidth))) {
            this.objects.set((int)(object / (long)this.stripeWidth));
            return true;
        }
        return false;
    }

    public boolean contains(Long object) {
        return this.objects.get((int)(object / (long)this.stripeWidth));
    }

    public Long getFirst() {
        return this.firstObjectNo + this.objects.nextSetBit(0) * this.stripeWidth;
    }

    public Long getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        int highestSetBit = this.objects.length();
        int randomIndex = this.random.nextInt(highestSetBit);
        int index = this.objects.nextSetBit(randomIndex);
        assert (index != -1);
        return this.firstObjectNo + index * this.stripeWidth;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            int currentPosition = -1;

            @Override
            public Long next() {
                this.currentPosition = ObjectSet.this.objects.nextSetBit(this.currentPosition + 1);
                if (this.currentPosition == -1) {
                    throw new NoSuchElementException("iteration has no more elements");
                }
                return ObjectSet.this.firstObjectNo + this.currentPosition * ObjectSet.this.stripeWidth;
            }

            @Override
            public boolean hasNext() {
                return ObjectSet.this.objects.nextSetBit(this.currentPosition + 1) != -1;
            }

            @Override
            public void remove() {
                ObjectSet.this.objects.clear(this.currentPosition);
            }
        };
    }

    public boolean remove(Long object) {
        if (this.objects.get((int)(object / (long)this.stripeWidth))) {
            this.objects.clear((int)(object / (long)this.stripeWidth));
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public int size() {
        return this.objects.cardinality();
    }

    public void clear() {
        this.objects.clear();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectSet) {
            ObjectSet otherSet = (ObjectSet)obj;
            return this.stripeWidth == otherSet.stripeWidth && this.firstObjectNo == otherSet.firstObjectNo && this.objects.equals(otherSet.objects);
        }
        return false;
    }

    public boolean intersection(ObjectSet otherSet) {
        if (this.stripeWidth != otherSet.stripeWidth || this.firstObjectNo != otherSet.firstObjectNo) {
            throw new IllegalArgumentException("The sets are not compatible. They must have the same stripe width and first object number.");
        }
        int previousLength = this.objects.cardinality();
        this.objects.and(otherSet.objects);
        return this.objects.cardinality() != previousLength;
    }

    public boolean union(ObjectSet otherSet) {
        if (this.stripeWidth != otherSet.stripeWidth || this.firstObjectNo != otherSet.firstObjectNo) {
            throw new IllegalArgumentException("The sets are not compatible. They must have the same stripe width and first object number.");
        }
        int previousLength = this.objects.cardinality();
        this.objects.or(otherSet.objects);
        return this.objects.cardinality() != previousLength;
    }

    public boolean complement(int lastObject) {
        int indexOfLastObject = lastObject / this.stripeWidth;
        int previousLength = this.objects.size();
        if (this.objects.size() - 1 < indexOfLastObject) {
            this.objects.clear(indexOfLastObject);
        }
        this.objects.flip(0, this.objects.size());
        return this.objects.size() != previousLength;
    }

    public String toString() {
        return "stripe width: " + this.stripeWidth + ", first objectNo: " + this.firstObjectNo + ", objects: " + this.objects.toString();
    }

    public ObjectSet clone() throws CloneNotSupportedException {
        ObjectSet clone = new ObjectSet(this.stripeWidth, this.firstObjectNo, this.objects.size());
        clone.objects.or(this.objects);
        return clone;
    }

    public int getStripeWidth() {
        return this.stripeWidth;
    }

    public int getFirstObjectNo() {
        return this.firstObjectNo;
    }

    public byte[] getSerializedBitSet() throws IOException {
        return ObjectSet.serializeAndCompress(this.objects);
    }

    protected static byte[] serialize(BitSet set) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(set);
        oos.flush();
        oos.close();
        bos.close();
        return bos.toByteArray();
    }

    protected static byte[] serializeAndCompress(BitSet set) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DeflaterOutputStream gz = new DeflaterOutputStream(bos);
        ObjectOutputStream oos = new ObjectOutputStream(gz);
        oos.writeObject(set);
        oos.flush();
        oos.close();
        gz.close();
        bos.close();
        return bos.toByteArray();
    }

    protected static BitSet deserialize(byte[] set) throws IOException, ClassNotFoundException, ClassCastException {
        ByteArrayInputStream bis = new ByteArrayInputStream(set);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object o = ois.readObject();
        ois.close();
        bis.close();
        return (BitSet)o;
    }

    protected static BitSet deserializeAndDecompress(byte[] set) throws IOException, ClassNotFoundException, ClassCastException {
        ByteArrayInputStream bis = new ByteArrayInputStream(set);
        InflaterInputStream gz = new InflaterInputStream(bis);
        ObjectInputStream ois = new ObjectInputStream(gz);
        Object o = ois.readObject();
        ois.close();
        bis.close();
        return (BitSet)o;
    }
}

