/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.ServiceAvailability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.common.xloc.ReplicationFlags;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.operations.EventInsertPaddingObject;
import org.xtreemfs.osd.operations.EventWriteObject;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.replication.transferStrategies.RandomStrategy;
import org.xtreemfs.osd.replication.transferStrategies.RarestFirstStrategy;
import org.xtreemfs.osd.replication.transferStrategies.SequentialPrefetchingStrategy;
import org.xtreemfs.osd.replication.transferStrategies.SequentialStrategy;
import org.xtreemfs.osd.replication.transferStrategies.TransferStrategy;
import org.xtreemfs.osd.stages.ReplicationStage;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.storage.CowPolicy;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

class ReplicatingFile {
    private static final int MAX_MAX_OBJECTS_IN_PROGRESS = 5;
    private final OSDRequestDispatcher master;
    private static int maxObjectsInProgress;
    public final String fileID;
    private final TransferStrategy strategy;
    private final long lastObject;
    private XLocations xLoc;
    private Capability cap;
    private CowPolicy cow;
    private InetSocketAddress mrcAddress = null;
    private boolean cancelled;
    public boolean isFullReplica;
    private final ServiceAvailability osdAvailability;
    private final HashMap<Long, ReplicatingObject> objectsInProgress;
    private final HashMap<Long, ReplicatingObject> waitingRequests;

    public ReplicatingFile(String fileID, XLocations xLoc, Capability cap, CowPolicy cow, OSDRequestDispatcher master) {
        this.master = master;
        this.osdAvailability = master.getServiceAvailability();
        this.fileID = fileID;
        this.xLoc = xLoc;
        this.cap = cap;
        this.cow = cow;
        this.cancelled = false;
        this.objectsInProgress = new HashMap();
        this.waitingRequests = new HashMap();
        StripingPolicyImpl sp = xLoc.getLocalReplica().getStripingPolicy();
        assert (this.checkEqualStripeSizeOfReplicas(xLoc.getReplicas()));
        this.lastObject = sp.getObjectNoForOffset(xLoc.getXLocSet().getReadOnlyFileSize() - 1L);
        if (ReplicationFlags.isRandomStrategy(xLoc.getLocalReplica().getTransferStrategyFlags())) {
            this.strategy = new RandomStrategy(fileID, xLoc, this.osdAvailability);
        } else if (ReplicationFlags.isSequentialStrategy(xLoc.getLocalReplica().getTransferStrategyFlags())) {
            this.strategy = new SequentialStrategy(fileID, xLoc, this.osdAvailability);
        } else if (ReplicationFlags.isSequentialPrefetchingStrategy(xLoc.getLocalReplica().getTransferStrategyFlags())) {
            this.strategy = new SequentialPrefetchingStrategy(fileID, xLoc, this.osdAvailability);
        } else if (ReplicationFlags.isRarestFirstStrategy(xLoc.getLocalReplica().getTransferStrategyFlags())) {
            this.strategy = new RarestFirstStrategy(fileID, xLoc, this.osdAvailability);
        } else {
            throw new IllegalArgumentException("Set Replication Strategy not known (" + xLoc.getLocalReplica().getTransferStrategyFlags() + ").");
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "%s - using strategy: %s", fileID, this.strategy.getClass().getName());
        }
        boolean bl = this.isFullReplica = !xLoc.getLocalReplica().isPartialReplica();
        if (this.isFullReplica) {
            int coloumn = xLoc.getLocalReplica().getOSDs().indexOf(master.getConfig().getUUID());
            Iterator<Long> objectsIt = sp.getObjectsOfOSD(coloumn, 0L, this.lastObject);
            while (objectsIt.hasNext()) {
                this.strategy.addObject(objectsIt.next(), false);
            }
        }
    }

    public boolean update(Capability cap, XLocations xLoc, CowPolicy cow) {
        boolean changed = false;
        this.cow = cow;
        if (cap.getExpires() > this.cap.getExpires() || cap.getEpochNo() > this.cap.getEpochNo()) {
            this.cap = cap;
            changed = true;
        }
        if (this.hasXLocChanged(xLoc)) {
            this.xLoc = xLoc;
            this.strategy.updateXLoc(xLoc);
            changed = true;
        }
        return changed;
    }

    public boolean hasXLocChanged(XLocations xLoc) {
        return xLoc.getXLocSet().getVersion() > this.xLoc.getXLocSet().getVersion();
    }

    public boolean addObjectForReplication(Long objectNo, Stage.StageRequest rq) {
        assert (rq != null);
        ReplicatingObject info = this.objectsInProgress.get(objectNo);
        if (info == null && (info = this.waitingRequests.get(objectNo)) == null) {
            info = new ReplicatingObject(objectNo);
            this.waitingRequests.put(objectNo, info);
            this.strategy.addObject(objectNo, true);
        }
        info.getWaitingRequests().add(rq);
        return true;
    }

    private boolean processObject(Long objectNo) {
        if (!this.isObjectInProgress(objectNo)) {
            ReplicatingObject object = this.waitingRequests.remove(objectNo);
            if (object != null) {
                this.objectsInProgress.put(objectNo, object);
            } else {
                this.objectsInProgress.put(objectNo, new ReplicatingObject(objectNo));
            }
            return true;
        }
        return false;
    }

    public boolean isObjectInProgress(Long objectNo) {
        return this.objectsInProgress.containsKey(objectNo);
    }

    public boolean isReplicating() {
        return !this.objectsInProgress.isEmpty();
    }

    public boolean isStopped() {
        return this.cancelled;
    }

    public int getNumberOfObjectsInProgress() {
        return this.objectsInProgress.size();
    }

    public int getNumberOfWaitingObjects() {
        return this.waitingRequests.size();
    }

    public void replicate() throws TransferStrategy.TransferStrategyException {
        while (this.objectsInProgress.size() < maxObjectsInProgress) {
            this.strategy.selectNext();
            TransferStrategy.NextRequest next = this.strategy.getNext();
            if (next == null) break;
            this.processObject(next.objectNo);
            if (Logging.isDebug()) {
                if (next.attachObjectSet) {
                    Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - fetch object from OSD %s with object set", this.fileID, next.objectNo, next.osd);
                } else {
                    Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - fetch object from OSD %s", this.fileID, next.objectNo, next.osd);
                }
            }
            try {
                this.sendFetchObjectRequest(next.objectNo, next.osd, next.attachObjectSet);
            }
            catch (IOException e) {
                this.objectsInProgress.get(next.objectNo).replicateObject();
            }
        }
    }

    public void objectFetched(long objectNo, ServiceUUID usedOSD, InternalObjectData data) {
        ReplicatingObject object = this.objectsInProgress.get(objectNo);
        assert (object != null) : objectNo + ", " + usedOSD.toString();
        try {
            boolean objectCompleted = object.objectFetched(data, usedOSD);
            if (objectCompleted) {
                this.objectReplicationCompleted(objectNo);
            }
        }
        catch (TransferStrategy.TransferStrategyException e) {
            object.sendError(ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, e.getMessage()));
            this.objectReplicationCompleted(objectNo);
        }
    }

    public void objectNotFetched(long objectNo, ServiceUUID usedOSD, InternalObjectData data) {
        ReplicatingObject object = this.objectsInProgress.get(objectNo);
        assert (object != null);
        try {
            boolean objectCompleted = object.objectNotFetched(data, usedOSD);
            if (objectCompleted) {
                this.objectReplicationCompleted(objectNo);
                if (!this.strategy.isObjectListEmpty()) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.replication, this, "background replication: replicate next object for file %s", this.fileID);
                    }
                    this.replicate();
                }
            }
        }
        catch (TransferStrategy.TransferStrategyException e) {
            object.sendError(ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, e.getMessage()));
            this.objectReplicationCompleted(objectNo);
        }
    }

    public void objectNotFetchedBecauseError(long objectNo, ServiceUUID usedOSD, RPC.RPCHeader.ErrorResponse error) {
        ReplicatingObject object = this.objectsInProgress.get(objectNo);
        assert (object != null);
        try {
            boolean objectCompleted = object.objectNotFetchedBecauseError(error, usedOSD);
            if (objectCompleted) {
                this.objectReplicationCompleted(objectNo);
                if (!this.strategy.isObjectListEmpty()) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.replication, this, "background replication: replicate next object for file %s", this.fileID);
                    }
                    this.replicate();
                }
            }
        }
        catch (TransferStrategy.TransferStrategyException e) {
            object.sendError(ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, e.getMessage()));
            this.objectReplicationCompleted(objectNo);
        }
    }

    public void objectReplicationCompleted(long objectNo) {
        this.strategy.removeObject(objectNo);
        ReplicatingObject replicatingObject = this.objectsInProgress.remove(objectNo);
        if (replicatingObject.hasDataFromEarlierResponses()) {
            BufferPool.free(replicatingObject.data.getData());
        }
    }

    public void stopReplicatingFile() {
        this.cancelled = true;
    }

    public void objectSetFetched(ServiceUUID osd, ObjectSet objectSet) {
        this.strategy.setOSDsObjectSet(objectSet, osd);
    }

    private void sendFetchObjectRequest(final long objectNo, final ServiceUUID osd, boolean attachObjectSet) throws UnknownUUIDException, IOException {
        try {
            this.checkCap();
        }
        catch (IOException e1) {
            Logging.logMessage(3, Logging.Category.misc, this, "cannot update capability for file %s due to " + e1.getLocalizedMessage(), this.fileID);
        }
        assert (this.objectsInProgress.size() <= 5);
        OSDServiceClient client = this.master.getOSDClientForReplication();
        GlobalTypes.FileCredentials fcred = GlobalTypes.FileCredentials.newBuilder().setXcap(this.cap.getXCap()).setXlocs(this.xLoc.getXLocSet()).build();
        RPCResponse<OSD.InternalReadLocalResponse> response = client.xtreemfs_internal_read_local(osd.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, fcred, this.fileID, objectNo, 0L, 0, this.xLoc.getLocalReplica().getStripingPolicy().getStripeSizeForObject(objectNo), attachObjectSet, new ArrayList<OSD.ObjectList>(0));
        response.registerListener(new RPCResponseAvailableListener<OSD.InternalReadLocalResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void responseAvailable(RPCResponse<OSD.InternalReadLocalResponse> r) {
                OSD.InternalReadLocalResponse internalReadLocalResponse = null;
                try {
                    internalReadLocalResponse = r.get();
                    OSD.ObjectData metadata = internalReadLocalResponse.getData();
                    InternalObjectData data = new InternalObjectData(metadata, r.getData());
                    OSD.ObjectList objectList = null;
                    if (internalReadLocalResponse.getObjectSetCount() == 1) {
                        objectList = internalReadLocalResponse.getObjectSet(0);
                    }
                    ReplicatingFile.this.master.getReplicationStage().internalObjectFetched(ReplicatingFile.this.fileID, objectNo, osd, data, objectList, null);
                }
                catch (PBRPCException e) {
                    ReplicatingFile.this.osdAvailability.setServiceWasNotAvailable(osd);
                    ReplicatingFile.this.master.getReplicationStage().internalObjectFetched(ReplicatingFile.this.fileID, objectNo, osd, null, null, e.getErrorResponse());
                }
                catch (IOException e) {
                    ReplicatingFile.this.osdAvailability.setServiceWasNotAvailable(osd);
                    ReplicatingFile.this.master.getReplicationStage().internalObjectFetched(ReplicatingFile.this.fileID, objectNo, osd, null, null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, e.toString()));
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    r.freeBuffers();
                }
            }
        });
    }

    public void reportError(RPC.RPCHeader.ErrorResponse error) {
        Logging.logMessage(3, this, ErrorUtils.formatError(error), new Object[0]);
        for (ReplicatingObject object : this.waitingRequests.values()) {
            object.sendError(error);
        }
        for (ReplicatingObject object : this.objectsInProgress.values()) {
            object.sendError(error);
        }
    }

    public void checkCap() throws IOException {
        block7: {
            try {
                block8: {
                    long curTime = TimeSync.getGlobalTime() / 1000L;
                    if (this.cap.getExpires() - curTime >= 60000L) break block7;
                    if (this.mrcAddress == null) {
                        String volume = null;
                        try {
                            volume = new MRCHelper.GlobalFileIdResolver(this.fileID).getVolumeId();
                            DIR.ServiceSet sSet = this.master.getDIRClient().xtreemfs_service_get_by_uuid(null, RPCAuthentication.authNone, RPCAuthentication.userService, volume);
                            if (sSet.getServicesCount() != 0) {
                                for (GlobalTypes.KeyValuePair kvp : sSet.getServices(0).getData().getDataList()) {
                                    if (!kvp.getKey().equals("mrc")) continue;
                                    this.mrcAddress = new ServiceUUID(kvp.getValue()).getAddress();
                                }
                                break block8;
                            }
                            throw new IOException("Cannot find a MRC.");
                        }
                        catch (UserException e) {
                            Logging.logMessage(3, Logging.Category.misc, this, e.getLocalizedMessage() + "; for file %s", this.fileID);
                        }
                    }
                }
                RPCResponse<GlobalTypes.XCap> r = this.master.getMRCClient().xtreemfs_renew_capability(this.mrcAddress, RPCAuthentication.authNone, RPCAuthentication.userService, this.cap.getXCap());
                GlobalTypes.XCap xCap = r.get();
                r.freeBuffers();
                this.cap = new Capability(xCap, this.master.getConfig().getCapabilitySecret());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void setMaxObjectsInProgressPerFile(int maxObjects) {
        maxObjectsInProgress = maxObjects >= 1 ? (maxObjects <= 5 ? maxObjects : 5) : 1;
    }

    private boolean checkEqualStripeSizeOfReplicas(List<Replica> replicas) {
        boolean allEqual = true;
        int stripeSize = replicas.get(0).getStripingPolicy().getStripeSizeForObject(0L);
        for (Replica replica : replicas) {
            if (stripeSize == replica.getStripingPolicy().getStripeSizeForObject(0L)) continue;
            allEqual = false;
        }
        return allEqual;
    }

    public void startNewReplication() throws TransferStrategy.TransferStrategyException {
        if (!this.strategy.isObjectListEmpty()) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "background replication: replicate next object for file %s", this.fileID);
            }
            this.replicate();
        }
    }

    private class ReplicatingObject {
        public final long objectNo;
        private List<Stage.StageRequest> waitingRequests = null;
        InternalObjectData data = null;

        public ReplicatingObject(long objectNo) {
            this.objectNo = objectNo;
        }

        public List<Stage.StageRequest> getWaitingRequests() {
            if (this.waitingRequests == null) {
                this.waitingRequests = new LinkedList<Stage.StageRequest>();
            }
            return this.waitingRequests;
        }

        public boolean hasWaitingRequests() {
            return this.waitingRequests == null ? false : !this.getWaitingRequests().isEmpty();
        }

        public boolean hasDataFromEarlierResponses() {
            return this.data != null;
        }

        public void replicateObject() throws TransferStrategy.TransferStrategyException {
            ReplicatingFile.this.strategy.selectNextOSD(this.objectNo);
            TransferStrategy.NextRequest next = ReplicatingFile.this.strategy.getNext();
            if (next != null) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - fetch object from OSD %s", ReplicatingFile.this.fileID, next.objectNo, next.osd);
                }
                try {
                    ReplicatingFile.this.sendFetchObjectRequest(next.objectNo, next.osd, next.attachObjectSet);
                }
                catch (IOException e) {
                    this.replicateObject();
                }
            } else {
                this.sendError(ErrorUtils.getErrorResponse(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_EIO, "transfer strategy returns neither a value nor an exception"));
                Logging.logMessage(3, Logging.Category.replication, this, "transfer strategy returns neither a value nor an exception", new Object[0]);
                ReplicatingFile.this.objectReplicationCompleted(this.objectNo);
            }
        }

        public boolean objectFetched(InternalObjectData data, ServiceUUID usedOSD) throws TransferStrategy.TransferStrategyException {
            if (!data.getInvalid_checksum_on_osd()) {
                if (this.hasWaitingRequests()) {
                    this.sendResponses(data.getData(), ObjectInformation.ObjectStatus.EXISTS);
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - OBJECT FETCHED", ReplicatingFile.this.fileID, this.objectNo);
                }
                if (!ReplicatingFile.this.isStopped()) {
                    OSDOperation writeObjectEvent = ReplicatingFile.this.master.getInternalEvent(EventWriteObject.class);
                    writeObjectEvent.startInternalEvent(new Object[]{ReplicatingFile.this.fileID, this.objectNo, data.getData(), ReplicatingFile.this.xLoc, ReplicatingFile.this.cow});
                }
                return true;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - fetched object has an invalid checksum", ReplicatingFile.this.fileID, this.objectNo);
            }
            this.data = data;
            ReplicatingFile.this.strategy.addObject(this.objectNo, this.hasWaitingRequests());
            this.replicateObject();
            return false;
        }

        public boolean objectNotFetched(InternalObjectData data, ServiceUUID usedOSD) throws TransferStrategy.TransferStrategyException {
            if (ReplicatingFile.this.xLoc.getReplica(usedOSD).isComplete()) {
                if (this.hasDataFromEarlierResponses() && this.hasWaitingRequests()) {
                    this.sendResponses(this.data.getData(), ObjectInformation.ObjectStatus.EXISTS);
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - OBJECT FETCHED, but with wrong checksum", ReplicatingFile.this.fileID, this.objectNo);
                    }
                } else {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - OBJECT COULD NOT BE FETCHED FROM A COMPLETE REPLICA; MUST BE A HOLE.", ReplicatingFile.this.fileID, this.objectNo);
                    }
                    if (this.hasWaitingRequests()) {
                        this.sendResponses(null, ObjectInformation.ObjectStatus.PADDING_OBJECT);
                    }
                    OSDOperation writeObjectEvent = ReplicatingFile.this.master.getInternalEvent(EventInsertPaddingObject.class);
                    writeObjectEvent.startInternalEvent(new Object[]{ReplicatingFile.this.fileID, this.objectNo, ReplicatingFile.this.xLoc, data.getZero_padding()});
                }
                return true;
            }
            return this.objectNotFetchedBecauseError(null, usedOSD);
        }

        public boolean objectNotFetchedBecauseError(RPC.RPCHeader.ErrorResponse error, ServiceUUID usedOSD) throws TransferStrategy.TransferStrategyException {
            if (Logging.isDebug() && error != null) {
                Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - an error occurred while fetching the object from OSD %s: %s", ReplicatingFile.this.fileID, this.objectNo, usedOSD.toString(), error.getErrorMessage());
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - object could not be fetched from OSD => try next OSD", ReplicatingFile.this.fileID, this.objectNo);
            }
            ReplicatingFile.this.strategy.addObject(this.objectNo, this.hasWaitingRequests());
            this.replicateObject();
            return false;
        }

        private void sendResponses(ReusableBuffer data, ObjectInformation.ObjectStatus status) {
            List<Stage.StageRequest> reqs = this.getWaitingRequests();
            StripingPolicyImpl sp = ReplicatingFile.this.xLoc.getLocalReplica().getStripingPolicy();
            for (Stage.StageRequest rq : reqs) {
                ObjectInformation objectInfo = status == ObjectInformation.ObjectStatus.EXISTS ? new ObjectInformation(status, data.createViewBuffer(), sp.getStripeSizeForObject(this.objectNo)) : new ObjectInformation(status, null, sp.getStripeSizeForObject(this.objectNo));
                objectInfo.setGlobalLastObjectNo(ReplicatingFile.this.lastObject);
                ReplicationStage.FetchObjectCallback callback = (ReplicationStage.FetchObjectCallback)rq.getCallback();
                callback.fetchComplete(objectInfo, null);
            }
        }

        public void sendError(RPC.RPCHeader.ErrorResponse error) {
            List<Stage.StageRequest> reqs = this.getWaitingRequests();
            for (Stage.StageRequest rq : reqs) {
                ReplicationStage.FetchObjectCallback callback = (ReplicationStage.FetchObjectCallback)rq.getCallback();
                callback.fetchComplete(null, error);
            }
        }
    }
}

