/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication.selection;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.replication.transferStrategies.TransferStrategy;

public class RarestFirstObjectSelection {
    protected TreeMap<Integer, ObjectSet> rarestObjects = new TreeMap();
    protected long objectsCount = 0L;

    public long selectNextObject(ObjectSet objects, Map<ServiceUUID, TransferStrategy.ObjectSetInfo> objectsOnOSDsMap) throws TransferStrategy.TransferStrategyException {
        assert (!objects.isEmpty());
        if (this.objectsCount <= 0L) {
            this.buildQueue(objects, objectsOnOSDsMap);
        }
        assert (this.objectsCount > 0L);
        Long objectNo = null;
        for (ObjectSet objectWithOccurrence : this.rarestObjects.values()) {
            if (objectWithOccurrence.isEmpty()) continue;
            objectNo = objectWithOccurrence.getRandom();
            break;
        }
        return objectNo;
    }

    public void buildQueue(ObjectSet objects, Map<ServiceUUID, TransferStrategy.ObjectSetInfo> objectsOnOSDsMap) {
        for (Long objectNo : objects) {
            this.addObject((long)objectNo, objectsOnOSDsMap);
        }
    }

    public void addObject(long objectNo, Map<ServiceUUID, TransferStrategy.ObjectSetInfo> objectsOnOSDsMap) {
        Collection<TransferStrategy.ObjectSetInfo> objectsOnOSDs = objectsOnOSDsMap.values();
        int counter = 0;
        for (TransferStrategy.ObjectSetInfo setInfo : objectsOnOSDs) {
            if (!setInfo.set.contains(objectNo)) continue;
            ++counter;
        }
        if (counter == 0) {
            counter = Integer.MAX_VALUE;
        }
        this.addObject((Long)objectNo, counter);
    }

    private void addObject(Long objectNo, Integer occurrence) {
        ObjectSet objectWithOccurrence = this.rarestObjects.get(occurrence);
        if (objectWithOccurrence == null) {
            objectWithOccurrence = new ObjectSet();
            this.rarestObjects.put(occurrence, objectWithOccurrence);
        }
        objectWithOccurrence.add(objectNo);
        ++this.objectsCount;
    }

    public void invalidateQueue() {
        for (ObjectSet set : this.rarestObjects.values()) {
            set.clear();
        }
        this.objectsCount = 0L;
    }

    public void newObjectSetArrived(ObjectSet objects, ObjectSet oldObjectSet, ObjectSet newObjectSet) {
        ObjectSet objectSet = oldObjectSet == null ? new ObjectSet() : new ObjectSet(oldObjectSet);
        objectSet.complement(newObjectSet.size() - 1);
        objectSet.intersection(newObjectSet);
        objectSet.intersection(objects);
        block0: for (Long objectNo : objectSet) {
            for (Map.Entry<Integer, ObjectSet> e : this.rarestObjects.entrySet()) {
                if (!e.getValue().contains(objectNo)) continue;
                e.getValue().remove(objectNo);
                --this.objectsCount;
                this.addObject(objectNo, e.getKey() + 1);
                continue block0;
            }
        }
    }

    public void removeObject(long objectNo) {
        for (ObjectSet objectWithOccurrence : this.rarestObjects.values()) {
            if (!objectWithOccurrence.remove(objectNo)) continue;
            --this.objectsCount;
            break;
        }
    }
}

