/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication.selection;

import java.util.HashMap;
import java.util.List;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.osd.replication.transferStrategies.TransferStrategy;

public class RoundRobinOSDSelection {
    private HashMap<Integer, Integer> nextOSDforObject;
    private final int maxStripeWidth;
    private int lastKnownNumberOfReplicas;

    public RoundRobinOSDSelection(int maxStripeWidth) {
        this.maxStripeWidth = maxStripeWidth;
        this.nextOSDforObject = new HashMap(maxStripeWidth);
        this.lastKnownNumberOfReplicas = 0;
        for (int i = 0; i < maxStripeWidth; ++i) {
            this.nextOSDforObject.put(i, 0);
        }
    }

    public ServiceUUID selectNextOSD(List<ServiceUUID> osds, long objectNo) throws TransferStrategy.TransferStrategyException {
        assert (osds.size() > 0);
        if (this.lastKnownNumberOfReplicas != osds.size()) {
            this.lastKnownNumberOfReplicas = osds.size();
        }
        int positionOfNextOSD = this.getPositionOfNextOSD(objectNo);
        this.increasePositionOfOSD(objectNo);
        return osds.get(positionOfNextOSD);
    }

    protected int getPositionOfNextOSD(long objectNo) {
        return this.nextOSDforObject.get((int)(objectNo % (long)this.maxStripeWidth));
    }

    protected void increasePositionOfOSD(long objectNo) {
        int oldPosition = this.nextOSDforObject.get((int)(objectNo % (long)this.maxStripeWidth));
        this.nextOSDforObject.put((int)(objectNo % (long)this.maxStripeWidth), ++oldPosition % this.lastKnownNumberOfReplicas);
    }
}

