/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication.transferStrategies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.ServiceAvailability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.replication.transferStrategies.TransferStrategy;

public abstract class MasqueradingTransferStrategy
extends TransferStrategy {
    private final int defaultNumberOfRequests = 20;
    private static final ObjectSet dummyObjectSet = new ObjectSet(0);
    protected Map<Long, List<ServiceUUID>> availableOSDsForObject = new HashMap<Long, List<ServiceUUID>>();
    protected int timeSinceLastRandomRequest = 0;
    protected long lastObjectNo;
    protected boolean fetchObjectSets;

    public MasqueradingTransferStrategy(String fileID, XLocations xLoc, ServiceAvailability osdAvailability, boolean fetchObjectSets) {
        super(fileID, xLoc, osdAvailability);
        this.fetchObjectSets = fetchObjectSets;
        StripingPolicyImpl sp = xLoc.getLocalReplica().getStripingPolicy();
        this.lastObjectNo = sp.getObjectNoForOffset(xLoc.getXLocSet().getReadOnlyFileSize() - 1L);
    }

    @Override
    public TransferStrategy.NextRequest getNext() {
        List<ServiceUUID> osds;
        TransferStrategy.NextRequest next = super.getNext();
        if (next != null && (osds = this.availableOSDsForObject.get(next.objectNo)) != null) {
            osds.remove(next.osd);
        }
        return next;
    }

    @Override
    public boolean removeObject(long objectNo) {
        boolean contained = null != this.availableOSDsForObject.remove(objectNo);
        contained = contained || super.removeObjectFromList(objectNo);
        return contained;
    }

    @Override
    protected TransferStrategy.NextRequest selectNextHook() throws TransferStrategy.TransferStrategyException {
        long objectNo = this.selectObject(this.preferredObjects, this.requiredObjects);
        try {
            return this.selectNextOSDHook(objectNo);
        }
        catch (TransferStrategy.TransferStrategyException e) {
            ObjectSet copyOfPreferredObjects = null;
            ObjectSet copyOfRequiredObjects = null;
            try {
                copyOfPreferredObjects = this.preferredObjects.clone();
                copyOfRequiredObjects = this.requiredObjects.clone();
            }
            catch (CloneNotSupportedException e2) {
                // empty catch block
            }
            assert (copyOfPreferredObjects != null && copyOfRequiredObjects != null);
            while (true) {
                objectNo = this.selectObject(copyOfPreferredObjects, copyOfRequiredObjects);
                try {
                    return this.selectNextOSDHook(objectNo);
                }
                catch (TransferStrategy.TransferStrategyException e1) {
                    if (copyOfPreferredObjects.contains(objectNo)) {
                        copyOfPreferredObjects.remove(objectNo);
                        continue;
                    }
                    if (!copyOfRequiredObjects.contains(objectNo)) continue;
                    copyOfRequiredObjects.remove(objectNo);
                    if (!copyOfPreferredObjects.isEmpty() || !copyOfRequiredObjects.isEmpty()) continue;
                    throw e;
                }
                break;
            }
        }
    }

    protected abstract long selectObject(ObjectSet var1, ObjectSet var2) throws TransferStrategy.TransferStrategyException;

    @Override
    protected TransferStrategy.NextRequest selectNextOSDHook(long objectNo) throws TransferStrategy.TransferStrategyException {
        TransferStrategy.NextRequest next = new TransferStrategy.NextRequest(this);
        next.objectNo = objectNo;
        List<ServiceUUID> availableOSDsForObject = this.getAvailableOSDsForObject(objectNo);
        if (availableOSDsForObject.size() == 0) {
            throw new TransferStrategy.TransferStrategyException("No OSD could be found for object " + objectNo + ". Maybe it is a hole.", TransferStrategy.TransferStrategyException.ErrorCode.NO_OSD_FOUND);
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - available OSDs for file: %s", this.fileID, objectNo, availableOSDsForObject.toString());
        }
        if (this.fetchObjectSets) {
            next.attachObjectSet = this.isTimeForNewObjectSet();
        }
        ServiceUUID osd = this.selectOSD(availableOSDsForObject, objectNo, next.attachObjectSet);
        if (this.fetchObjectSets && !this.objectsOnOSDs.containsKey(osd)) {
            next.attachObjectSet = true;
        }
        if (this.osdAvailability.isServiceAvailable(osd)) {
            availableOSDsForObject.remove(osd);
            next.osd = osd;
        } else {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "OSD %s is not available", osd.toString());
            }
            ArrayList<ServiceUUID> testedOSDs = new ArrayList<ServiceUUID>(availableOSDsForObject);
            while (testedOSDs.size() != 0) {
                osd = this.selectOSD(testedOSDs, objectNo, next.attachObjectSet);
                if (this.osdAvailability.isServiceAvailable(osd)) {
                    next.osd = osd;
                    break;
                }
                testedOSDs.remove(osd);
                if (!Logging.isDebug()) continue;
                Logging.logMessage(7, Logging.Category.replication, this, "OSD %s is not available", osd.toString());
            }
        }
        if (next.osd == null) {
            throw new TransferStrategy.TransferStrategyException("At the moment no OSD is reachable for object " + objectNo, TransferStrategy.TransferStrategyException.ErrorCode.NO_OSD_REACHABLE);
        }
        if (this.fetchObjectSets) {
            if (next.attachObjectSet) {
                this.timeSinceLastRandomRequest = 0;
                if (!this.objectsOnOSDs.containsKey(next.osd)) {
                    super.setOSDsObjectSet(dummyObjectSet, next.osd);
                }
            } else {
                ++this.timeSinceLastRandomRequest;
            }
        }
        return next;
    }

    protected abstract ServiceUUID selectOSD(List<ServiceUUID> var1, long var2, boolean var4) throws TransferStrategy.TransferStrategyException;

    protected List<ServiceUUID> getAvailableOSDsForObject(long objectNo) {
        List<ServiceUUID> list = this.availableOSDsForObject.get(objectNo);
        if (list == null) {
            list = this.xLoc.getOSDsForObject(objectNo, this.xLoc.getLocalReplica());
            this.availableOSDsForObject.put(objectNo, list);
        }
        return list;
    }

    protected boolean isTimeForNewObjectSet() {
        double ratio;
        double d = ratio = this.lastObjectNo == 0L ? 1.0 : (double)(super.getObjectsCount() / this.lastObjectNo);
        return this.timeSinceLastRandomRequest > 20;
    }
}

