/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication.transferStrategies;

import org.xtreemfs.common.ServiceAvailability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.replication.selection.RarestFirstObjectSelection;
import org.xtreemfs.osd.replication.transferStrategies.RandomStrategy;
import org.xtreemfs.osd.replication.transferStrategies.TransferStrategy;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class RarestFirstStrategy
extends RandomStrategy {
    public static final GlobalTypes.REPL_FLAG REPLICATION_FLAG = GlobalTypes.REPL_FLAG.REPL_FLAG_STRATEGY_RAREST_FIRST;
    protected RarestFirstObjectSelection objectSelection = new RarestFirstObjectSelection();

    public RarestFirstStrategy(String fileId, XLocations xLoc, ServiceAvailability osdAvailability) {
        super(fileId, xLoc, osdAvailability);
    }

    @Override
    protected long selectObject(ObjectSet preferredObjects, ObjectSet requiredObjects) throws TransferStrategy.TransferStrategyException {
        long objectNo = !preferredObjects.isEmpty() ? ((RandomStrategy)this).objectSelection.selectNextObject(preferredObjects) : this.objectSelection.selectNextObject(requiredObjects, this.objectsOnOSDs);
        return objectNo;
    }

    @Override
    public boolean addObject(long objectNo, boolean preferred) {
        boolean returnValue = super.addObject(objectNo, preferred);
        if (!preferred) {
            this.objectSelection.addObject(objectNo, this.objectsOnOSDs);
        }
        return returnValue;
    }

    @Override
    public void setOSDsObjectSet(ObjectSet set, ServiceUUID osd) {
        this.objectSelection.invalidateQueue();
        super.setOSDsObjectSet(set, osd);
    }

    @Override
    protected boolean removeObjectFromList(long objectNo) {
        this.objectSelection.removeObject(objectNo);
        return super.removeObjectFromList(objectNo);
    }
}

