/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication.transferStrategies;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.xtreemfs.common.ServiceAvailability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.replication.selection.SequentialObjectSelection;
import org.xtreemfs.osd.replication.transferStrategies.RandomStrategy;
import org.xtreemfs.osd.replication.transferStrategies.TransferStrategy;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class SequentialPrefetchingStrategy
extends RandomStrategy {
    public static final GlobalTypes.REPL_FLAG REPLICATION_FLAG = GlobalTypes.REPL_FLAG.REPL_FLAG_STRATEGY_SEQUENTIAL_PREFETCHING;
    public static int DEFAULT_PREFETCHING_COUNT = 10;
    protected SequentialObjectSelection objectSelection = new SequentialObjectSelection();
    private StripingPolicyImpl stripingPolicy = this.xLoc.getLocalReplica().getStripingPolicy();
    private int osdIndex = -1;
    protected ObjectSet alreadyPrefetchedObjects = new ObjectSet();

    public SequentialPrefetchingStrategy(String fileId, XLocations loc, ServiceAvailability osdAvailability) {
        super(fileId, loc, osdAvailability);
    }

    @Override
    protected TransferStrategy.NextRequest selectNextHook() throws TransferStrategy.TransferStrategyException {
        TransferStrategy.NextRequest next = super.selectNextHook();
        if (next != null) {
            if (this.osdIndex < 0) {
                ServiceUUID localOSD = this.xLoc.getLocalReplica().getOSDForObject(next.objectNo);
                this.osdIndex = this.xLoc.getLocalReplica().getOSDs().indexOf(localOSD);
            }
            int prefetchingCount = DEFAULT_PREFETCHING_COUNT + this.preferredObjects.size();
            try {
                if (this.preferredObjects.contains(next.objectNo)) {
                    Iterator<Long> objectsIt = this.stripingPolicy.getObjectsOfOSD(this.osdIndex, next.objectNo, this.lastObjectNo);
                    objectsIt.next();
                    for (int i = 0; i < prefetchingCount && objectsIt.hasNext(); ++i) {
                        Long object = objectsIt.next();
                        if (this.preferredObjects.contains(object) || this.alreadyPrefetchedObjects.contains(object)) continue;
                        this.addObject(object, false);
                        this.alreadyPrefetchedObjects.add(object);
                        if (!Logging.isDebug()) continue;
                        Logging.logMessage(7, Logging.Category.replication, this, "%s:%d - prefetch object", this.fileID, object);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return next;
    }

    @Override
    protected long selectObject(ObjectSet preferredObjects, ObjectSet requiredObjects) throws TransferStrategy.TransferStrategyException {
        long objectNo = !preferredObjects.isEmpty() ? this.objectSelection.selectNextObject(preferredObjects) : this.objectSelection.selectNextObject(requiredObjects);
        return objectNo;
    }
}

