/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication.transferStrategies;

import java.util.Iterator;
import java.util.List;
import org.xtreemfs.common.ServiceAvailability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.replication.selection.RandomOSDSelection;
import org.xtreemfs.osd.replication.selection.SequentialObjectSelection;
import org.xtreemfs.osd.replication.transferStrategies.MasqueradingTransferStrategy;
import org.xtreemfs.osd.replication.transferStrategies.TransferStrategy;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class SequentialStrategy
extends MasqueradingTransferStrategy {
    public static final GlobalTypes.REPL_FLAG REPLICATION_FLAG = GlobalTypes.REPL_FLAG.REPL_FLAG_STRATEGY_SEQUENTIAL;
    protected SequentialObjectSelection objectSelection = new SequentialObjectSelection();
    protected RandomOSDSelection osdSelection = new RandomOSDSelection();

    public SequentialStrategy(String fileId, XLocations xLoc, ServiceAvailability osdAvailability) {
        super(fileId, xLoc, osdAvailability, false);
    }

    @Override
    protected long selectObject(ObjectSet preferredObjects, ObjectSet requiredObjects) throws TransferStrategy.TransferStrategyException {
        long objectNo = !preferredObjects.isEmpty() ? this.objectSelection.selectNextObject(preferredObjects) : this.objectSelection.selectNextObject(requiredObjects);
        return objectNo;
    }

    @Override
    protected ServiceUUID selectOSD(List<ServiceUUID> availableOSDsForObject, long objectNo, boolean timeForNewObjectSet) throws TransferStrategy.TransferStrategyException {
        return this.osdSelection.selectNextOSD(availableOSDsForObject);
    }

    @Override
    protected List<ServiceUUID> getAvailableOSDsForObject(long objectNo) {
        assert (this.requiredObjects.contains(objectNo) || this.preferredObjects.contains(objectNo));
        List<ServiceUUID> list = (List<ServiceUUID>)this.availableOSDsForObject.get(objectNo);
        if (list == null) {
            list = this.xLoc.getOSDsForObject(objectNo, this.xLoc.getLocalReplica());
            Iterator<ServiceUUID> iterator = list.iterator();
            while (iterator.hasNext()) {
                ServiceUUID osd = iterator.next();
                if (this.xLoc.getReplica(osd).isComplete()) continue;
                iterator.remove();
            }
            this.availableOSDsForObject.put(objectNo, list);
        }
        return list;
    }
}

