/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.replication.transferStrategies;

import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.common.ServiceAvailability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.osd.replication.ObjectSet;

public abstract class TransferStrategy {
    protected String fileID;
    protected XLocations xLoc;
    private NextRequest next;
    protected ObjectSet requiredObjects;
    protected ObjectSet preferredObjects;
    protected final ServiceAvailability osdAvailability;
    protected Map<ServiceUUID, ObjectSetInfo> objectsOnOSDs;

    protected TransferStrategy(String fileID, XLocations xLoc, ServiceAvailability osdAvailability) {
        this.xLoc = xLoc;
        this.fileID = fileID;
        this.requiredObjects = new ObjectSet();
        this.preferredObjects = new ObjectSet();
        this.objectsOnOSDs = new HashMap<ServiceUUID, ObjectSetInfo>();
        this.osdAvailability = osdAvailability;
        this.next = null;
    }

    public void updateXLoc(XLocations xLoc) {
        this.xLoc = xLoc;
    }

    public void selectNext() throws TransferStrategyException {
        this.next = null;
        if (this.getObjectsCount() > 0L) {
            assert (!this.preferredObjects.isEmpty() || !this.requiredObjects.isEmpty());
            NextRequest next = this.selectNextHook();
            if (next != null && next.isAllSet()) {
                this.next = next;
            }
        }
    }

    protected abstract NextRequest selectNextHook() throws TransferStrategyException;

    public void selectNextOSD(long objectNo) throws TransferStrategyException {
        this.next = null;
        NextRequest next = this.selectNextOSDHook(objectNo);
        if (next != null && next.isAllSet()) {
            this.next = next;
        }
    }

    protected abstract NextRequest selectNextOSDHook(long var1) throws TransferStrategyException;

    public NextRequest getNext() {
        if (this.next != null) {
            this.removeObjectFromList(this.next.objectNo);
        }
        return this.next;
    }

    public boolean addObject(long objectNo, boolean preferred) {
        if (preferred) {
            if (this.requiredObjects.contains(objectNo)) {
                this.requiredObjects.remove(objectNo);
            }
            return this.preferredObjects.add(objectNo);
        }
        if (this.preferredObjects.contains(objectNo)) {
            this.preferredObjects.remove(objectNo);
        }
        return this.requiredObjects.add(objectNo);
    }

    protected boolean removeObjectFromList(long objectNo) {
        boolean contained = this.preferredObjects.remove(objectNo);
        contained = contained || this.requiredObjects.remove(objectNo);
        return contained;
    }

    public abstract boolean removeObject(long var1);

    public long getObjectsCount() {
        return this.preferredObjects.size() + this.requiredObjects.size();
    }

    public boolean isObjectListEmpty() {
        return this.preferredObjects.isEmpty() && this.requiredObjects.isEmpty();
    }

    public void setOSDsObjectSet(ObjectSet set, ServiceUUID osd) {
        ObjectSetInfo objectSetInfo = this.objectsOnOSDs.get(osd);
        if (objectSetInfo == null) {
            objectSetInfo = new ObjectSetInfo();
            this.objectsOnOSDs.put(osd, objectSetInfo);
        }
        objectSetInfo.set = set;
    }

    public static class ObjectSetInfo {
        public ObjectSet set = null;
        public int lastRequestSinceXrequests = 0;
        public boolean complete = false;
    }

    public static class TransferStrategyException
    extends Exception {
        private final ErrorCode errorCode;

        public TransferStrategyException(String message, ErrorCode errorCode) {
            super(message);
            this.errorCode = errorCode;
        }

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        public static enum ErrorCode {
            NO_OSD_REACHABLE,
            NO_OSD_FOUND;

        }
    }

    public class NextRequest {
        public ServiceUUID osd = null;
        public long objectNo = -1L;
        public boolean attachObjectSet = false;

        boolean isAllSet() {
            return this.osd != null && this.objectNo != -1L;
        }
    }
}

