/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.rwre;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.flease.Flease;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.rwre.RedirectToMasterException;
import org.xtreemfs.osd.rwre.ReplicaUpdatePolicy;
import org.xtreemfs.osd.rwre.ReplicatedFileState;
import org.xtreemfs.osd.rwre.RetryException;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public abstract class CoordinatedReplicaUpdatePolicy
extends ReplicaUpdatePolicy {
    private final OSDServiceClient client;

    public CoordinatedReplicaUpdatePolicy(List<ServiceUUID> remoteOSDUUIDs, String localUUID, String fileId, OSDServiceClient client) {
        super(remoteOSDUUIDs, fileId, localUUID);
        this.client = client;
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) created %s for %s", localUUID, this.getClass().getSimpleName(), this.cellId);
        }
    }

    public abstract int getNumRequiredAcks(RWReplicationStage.Operation var1);

    public abstract boolean backupCanRead();

    @Override
    public void closeFile() {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) closed %s for %s", this.localUUID, this.getClass().getSimpleName(), this.cellId);
        }
    }

    @Override
    public boolean requiresLease() {
        return true;
    }

    @Override
    public void executeReset(final GlobalTypes.FileCredentials credentials, final OSD.ReplicaStatus localReplicaState, final ReplicaUpdatePolicy.ExecuteResetCallback callback) {
        final String fileId = credentials.getXcap().getFileId();
        final int numAcksRequired = this.getNumRequiredAcks(RWReplicationStage.Operation.INTERNAL_UPDATE);
        final int numRequests = this.remoteOSDUUIDs.size();
        final int maxErrors = numRequests - numAcksRequired;
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) fetching replica state for %s from %d replicas (majority: %d), local max: %d", this.localUUID, fileId, numRequests, numAcksRequired, this.localObjVersion);
        }
        final RPCResponse[] responses = new RPCResponse[this.remoteOSDUUIDs.size()];
        try {
            for (int i = 0; i < responses.length; ++i) {
                responses[i] = this.client.xtreemfs_rwr_status(((ServiceUUID)this.remoteOSDUUIDs.get(i)).getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, credentials, credentials.getXcap().getFileId(), 0L);
            }
        }
        catch (IOException ex) {
            callback.failed(ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString(), ex));
            return;
        }
        RPCResponseAvailableListener listener = new RPCResponseAvailableListener(){
            int numResponses = 0;
            int numErrors = 0;
            boolean exceptionSent = false;
            OSD.ReplicaStatus[] states;
            {
                this.states = new OSD.ReplicaStatus[CoordinatedReplicaUpdatePolicy.this.remoteOSDUUIDs.size() + 1];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void responseAvailable(RPCResponse r) {
                if (this.numResponses < numAcksRequired) {
                    int osdNum = -1;
                    for (int i = 0; i < numRequests; ++i) {
                        if (responses[i] != r) continue;
                        osdNum = i;
                        break;
                    }
                    assert (osdNum > -1);
                    try {
                        this.states[osdNum] = (OSD.ReplicaStatus)r.get();
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) received status response for %s from %s", CoordinatedReplicaUpdatePolicy.this.localUUID, fileId, CoordinatedReplicaUpdatePolicy.this.remoteOSDUUIDs.get(osdNum));
                        }
                        ++this.numResponses;
                    }
                    catch (Exception ex) {
                        ++this.numErrors;
                        Logging.logMessage(7, Logging.Category.replication, this, "no status response from %s fro %s due to exception: %s (acks: %d, errs: %d, maxErrs: %d)", CoordinatedReplicaUpdatePolicy.this.remoteOSDUUIDs.get(osdNum), fileId, ex.toString(), this.numResponses, this.numErrors, maxErrors);
                        if (this.numErrors > maxErrors && !this.exceptionSent) {
                            this.exceptionSent = true;
                            String errorMessage = String.format("(R:%s) read status FAILED for %s on %s (this is request #%d out of %d which failed)", CoordinatedReplicaUpdatePolicy.this.localUUID, fileId, CoordinatedReplicaUpdatePolicy.this.remoteOSDUUIDs.get(osdNum), this.numErrors, CoordinatedReplicaUpdatePolicy.this.remoteOSDUUIDs.size());
                            if (Logging.isDebug()) {
                                Logging.logMessage(7, Logging.Category.replication, this, errorMessage, new Object[0]);
                            }
                            callback.failed(ErrorUtils.getInternalServerError(ex, errorMessage));
                        }
                        return;
                    }
                    finally {
                        r.freeBuffers();
                    }
                }
                try {
                    r.get();
                }
                catch (Exception e) {
                    // empty catch block
                }
                r.freeBuffers();
                return;
                if (this.numResponses == numAcksRequired) {
                    this.states[this.states.length - 1] = localReplicaState;
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) received enough status responses for %s", CoordinatedReplicaUpdatePolicy.this.localUUID, fileId);
                    }
                    OSD.AuthoritativeReplicaState auth = CoordinatedReplicaUpdatePolicy.this.CalculateAuthoritativeState(this.states, fileId);
                    RPCResponseAvailableListener listener2 = new RPCResponseAvailableListener(){

                        public void responseAvailable(RPCResponse r) {
                            r.freeBuffers();
                        }
                    };
                    for (int i = 0; i < CoordinatedReplicaUpdatePolicy.this.remoteOSDUUIDs.size(); ++i) {
                        try {
                            RPCResponse r2 = CoordinatedReplicaUpdatePolicy.this.client.xtreemfs_rwr_auth_state(((ServiceUUID)CoordinatedReplicaUpdatePolicy.this.remoteOSDUUIDs.get(i)).getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, credentials, credentials.getXcap().getFileId(), auth);
                            r2.registerListener(listener2);
                            if (!Logging.isDebug()) continue;
                            Logging.logMessage(7, Logging.Category.replication, this, "sent auth state to backup %s for file %s", CoordinatedReplicaUpdatePolicy.this.remoteOSDUUIDs.get(i), fileId);
                            continue;
                        }
                        catch (Exception ex) {
                            Logging.logMessage(4, Logging.Category.replication, this, "(R:%s) cannot send auth state to backup: %s", CoordinatedReplicaUpdatePolicy.this.localUUID, ex.toString());
                        }
                    }
                    callback.finished(auth);
                }
            }
        };
        for (int i = 0; i < responses.length; ++i) {
            responses[i].registerListener(listener);
        }
    }

    public OSD.AuthoritativeReplicaState CalculateAuthoritativeState(OSD.ReplicaStatus[] states, String fileId) {
        return CoordinatedReplicaUpdatePolicy.CalculateAuthoritativeState(states, fileId, this.localUUID, this.remoteOSDUUIDs);
    }

    public static OSD.AuthoritativeReplicaState CalculateAuthoritativeState(OSD.ReplicaStatus[] states, String fileId, String localUUID, List<ServiceUUID> remoteOSDUUIDs) {
        StringBuilder stateStr = new StringBuilder();
        HashMap<Long, OSD.TruncateRecord> truncateLog = new HashMap<Long, OSD.TruncateRecord>();
        HashMap<Long, OSD.ObjectVersionMapping.Builder> all_objects = new HashMap<Long, OSD.ObjectVersionMapping.Builder>();
        long maxTruncateEpoch = 0L;
        long maxObjectVersion = 0L;
        for (int i = 0; i < states.length; ++i) {
            OSD.ReplicaStatus replicaStatus = states[i];
            if (replicaStatus == null) continue;
            if (replicaStatus.getTruncateEpoch() > maxTruncateEpoch) {
                maxTruncateEpoch = replicaStatus.getTruncateEpoch();
            }
            for (OSD.TruncateRecord trec : replicaStatus.getTruncateLog().getRecordsList()) {
                truncateLog.put(trec.getVersion(), trec);
            }
            for (OSD.ObjectVersion over : replicaStatus.getObjectVersionsList()) {
                OSD.ObjectVersionMapping.Builder omr;
                long onum = over.getObjectNumber();
                if (over.getObjectVersion() > maxObjectVersion) {
                    maxObjectVersion = over.getObjectVersion();
                }
                if ((omr = (OSD.ObjectVersionMapping.Builder)all_objects.get(onum)) == null || omr.getObjectVersion() < over.getObjectVersion()) {
                    omr = OSD.ObjectVersionMapping.newBuilder();
                    omr.setObjectVersion(over.getObjectVersion());
                    omr.setObjectNumber(onum);
                    all_objects.put(onum, omr);
                }
                if (omr.getObjectVersion() != over.getObjectVersion()) continue;
                if (i < states.length - 1) {
                    omr.addOsdUuids(remoteOSDUUIDs.get(i).toString());
                    continue;
                }
                omr.addOsdUuids(localUUID);
            }
        }
        for (OSD.TruncateRecord truncateRecord : truncateLog.values()) {
            Iterator iter = all_objects.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                if ((Long)e.getKey() <= truncateRecord.getLastObjectNumber() || ((OSD.ObjectVersionMapping.Builder)e.getValue()).getObjectVersion() >= truncateRecord.getVersion()) continue;
                iter.remove();
            }
        }
        if (Logging.isDebug()) {
            stateStr.append("tlog={");
            for (OSD.TruncateRecord truncateRecord : truncateLog.values()) {
                stateStr.append("(");
                stateStr.append(truncateRecord.getVersion());
                stateStr.append(",");
                stateStr.append(truncateRecord.getLastObjectNumber());
                stateStr.append("),");
            }
            stateStr.append("} ");
            stateStr.append("objs={");
            for (Map.Entry entry : all_objects.entrySet()) {
                stateStr.append("(");
                stateStr.append(entry.getKey());
                stateStr.append(",");
                stateStr.append(((OSD.ObjectVersionMapping.Builder)entry.getValue()).getObjectVersion());
                stateStr.append("),");
            }
            stateStr.append("} maxV=");
            stateStr.append(maxObjectVersion);
            stateStr.append(" maxTE=");
            stateStr.append(maxTruncateEpoch);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, (Object)null, "(R:%s) AUTH state for %s: %s", localUUID, fileId, stateStr.toString());
            }
        }
        OSD.AuthoritativeReplicaState.Builder auth = OSD.AuthoritativeReplicaState.newBuilder();
        auth.setTruncateEpoch(0L);
        OSD.TruncateLog.Builder builder = OSD.TruncateLog.newBuilder();
        builder.addAllRecords(truncateLog.values());
        auth.setTruncateLog(builder);
        auth.setTruncateEpoch(maxTruncateEpoch);
        auth.setMaxObjVersion(maxObjectVersion);
        for (OSD.ObjectVersionMapping.Builder obj : all_objects.values()) {
            auth.addObjectVersions(obj);
        }
        return auth.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeWrite(GlobalTypes.FileCredentials credentials, long objNo, long objVersion, InternalObjectData data, ReplicaUpdatePolicy.ClientOperationCallback callback) {
        String fileId = credentials.getXcap().getFileId();
        int numAcksRequired = this.getNumRequiredAcks(RWReplicationStage.Operation.WRITE);
        int numRequests = this.remoteOSDUUIDs.size();
        int maxErrors = numRequests - numAcksRequired;
        RPCResponse[] responses = new RPCResponse[this.remoteOSDUUIDs.size()];
        RPCResponseAvailableListener l = this.getResponseListener(callback, maxErrors, numAcksRequired, fileId, RWReplicationStage.Operation.WRITE);
        try {
            for (int i = 0; i < responses.length; ++i) {
                responses[i] = this.client.xtreemfs_rwr_update(((ServiceUUID)this.remoteOSDUUIDs.get(i)).getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, credentials, credentials.getXcap().getFileId(), 0L, objNo, objVersion, 0, data.getMetadata(), data.getData().createViewBuffer());
                responses[i].registerListener(l);
            }
        }
        catch (IOException ex) {
            callback.failed(ErrorUtils.getInternalServerError(ex));
        }
        finally {
            BufferPool.free(data.getData());
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) sent update for %s", this.localUUID, fileId);
        }
    }

    @Override
    public void executeTruncate(GlobalTypes.FileCredentials credentials, long newFileSize, long newObjectVersion, ReplicaUpdatePolicy.ClientOperationCallback callback) {
        String fileId = credentials.getXcap().getFileId();
        int numAcksRequired = this.getNumRequiredAcks(RWReplicationStage.Operation.TRUNCATE);
        int numRequests = this.remoteOSDUUIDs.size();
        int maxErrors = numRequests - numAcksRequired;
        RPCResponseAvailableListener l = this.getResponseListener(callback, maxErrors, numAcksRequired, fileId, RWReplicationStage.Operation.TRUNCATE);
        RPCResponse[] responses = new RPCResponse[this.remoteOSDUUIDs.size()];
        try {
            for (int i = 0; i < responses.length; ++i) {
                responses[i] = this.client.xtreemfs_rwr_truncate(((ServiceUUID)this.remoteOSDUUIDs.get(i)).getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, credentials, credentials.getXcap().getFileId(), newFileSize, newObjectVersion);
                responses[i].registerListener(l);
            }
        }
        catch (IOException ex) {
            callback.failed(ErrorUtils.getInternalServerError(ex));
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) sent truncate update for %s", this.localUUID, fileId);
        }
    }

    protected RPCResponseAvailableListener getResponseListener(final ReplicaUpdatePolicy.ClientOperationCallback callback, final int maxErrors, final int numAcksRequired, final String fileId, final RWReplicationStage.Operation operation) {
        assert (numAcksRequired <= this.remoteOSDUUIDs.size());
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) new response listener for %s (acks %d, errs %d)", this.localUUID, fileId, numAcksRequired, maxErrors);
        }
        assert (maxErrors >= 0);
        RPCResponseAvailableListener listener = new RPCResponseAvailableListener(){
            int numAcks = 0;
            int numErrors = 0;
            boolean responseSent = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void responseAvailable(RPCResponse r) {
                try {
                    r.get();
                    ++this.numAcks;
                }
                catch (Exception ex) {
                    ++this.numErrors;
                    Logging.logMessage(7, Logging.Category.replication, this, "exception for %s/%s (acks: %d, errs: %d, maxErrs: %d)", new Object[]{operation, fileId, this.numAcks, this.numErrors, maxErrors});
                    if (this.numErrors > maxErrors && !this.responseSent) {
                        this.responseSent = true;
                        Logging.logMessage(6, Logging.Category.replication, this, "replicated %s FAILED for %s (acks: %d, errs: %d, maxErrs: %d)", new Object[]{operation, fileId, this.numAcks, this.numErrors, maxErrors});
                        callback.failed(ErrorUtils.getInternalServerError(ex));
                    }
                    return;
                }
                finally {
                    r.freeBuffers();
                }
                if (this.numAcks == numAcksRequired) {
                    this.responseSent = true;
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.replication, this, "replicated %s successfull for %s", new Object[]{operation, fileId});
                    }
                    callback.finished();
                }
            }
        };
        return listener;
    }

    @Override
    public long onClientOperation(RWReplicationStage.Operation operation, long objVersion, ReplicatedFileState.ReplicaState currentState, Flease lease) throws RedirectToMasterException, IOException {
        if (currentState == ReplicatedFileState.ReplicaState.PRIMARY) {
            long tmpObjVer;
            if (operation != RWReplicationStage.Operation.READ) {
                if (this.localObjVersion == -1L) {
                    this.localObjVersion = 0L;
                }
                assert (this.localObjVersion > -1L);
                tmpObjVer = ++this.localObjVersion;
            } else {
                tmpObjVer = this.localObjVersion;
            }
            long nextObjVer = tmpObjVer;
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) prepared op for %s with objVer %d", this.localUUID, this.cellId, nextObjVer);
            }
            return nextObjVer;
        }
        if (currentState == ReplicatedFileState.ReplicaState.BACKUP) {
            if (this.backupCanRead() && operation == RWReplicationStage.Operation.READ) {
                return this.localObjVersion;
            }
            if (lease == null || lease.isEmptyLease()) {
                Logging.logMessage(4, Logging.Category.replication, this, "unknown lease state for %s: %s", this.cellId, lease);
                throw new RetryException("unknown lease state for cell " + this.cellId + ", can't redirect to master. Please retry.");
            }
            Logging.logMessage(7, Logging.Category.replication, this, "(R:%s) local is backup, redirecting for fileid %s to %s", this.localUUID, this.cellId, lease.getLeaseHolder().toString());
            throw new RedirectToMasterException(lease.getLeaseHolder().toString());
        }
        throw new IOException("invalid state: " + (Object)((Object)currentState));
    }

    @Override
    public boolean onRemoteUpdate(long objVersion, ReplicatedFileState.ReplicaState state) throws IOException {
        if (state == ReplicatedFileState.ReplicaState.PRIMARY) {
            throw new IOException("no accepting updates in PRIMARY mode");
        }
        if (objVersion == 1L && this.localObjVersion == -1L) {
            this.localObjVersion = 1L;
            return false;
        }
        if (objVersion <= this.localObjVersion) {
            Logging.logMessage(4, Logging.Category.replication, this, "Received object version %d, local is %d for file %s", objVersion, this.localObjVersion, this.cellId.toString());
        }
        if (objVersion > this.localObjVersion) {
            this.localObjVersion = objVersion;
        }
        return false;
    }

    @Override
    public boolean acceptRemoteUpdate(long objVersion) throws IOException {
        return objVersion >= this.localObjVersion;
    }

    @Override
    public boolean onPrimary(int masterEpoch) throws IOException {
        if ((long)masterEpoch != -1L) {
            this.localObjVersion = (long)masterEpoch << 32;
        }
        return true;
    }

    @Override
    public boolean onBackup() throws IOException {
        return false;
    }

    @Override
    public void onFailed() throws IOException {
    }

    private static final class ObjectMapRecord {
        public long version;
        public List<InetSocketAddress> osds;

        private ObjectMapRecord() {
        }
    }
}

