/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.rwre;

import java.io.IOException;
import org.xtreemfs.foundation.flease.MasterEpochHandlerInterface;
import org.xtreemfs.foundation.flease.comm.FleaseMessage;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.osd.rwre.ReplicaUpdatePolicy;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.storage.StorageLayout;

public class FleaseMasterEpochThread
extends Stage
implements MasterEpochHandlerInterface {
    private static final int STAGEOP_GET_MEPOCH = 1;
    private static final int STAGEOP_SET_MEPOCH = 2;
    private final StorageLayout layout;

    public FleaseMasterEpochThread(StorageLayout layout, int maxRequestsQueueLength) {
        super("FlMEpoThr", maxRequestsQueueLength);
        this.layout = layout;
    }

    @Override
    protected void processMethod(Stage.StageRequest method) {
        MasterEpochHandlerInterface.Continuation callback = (MasterEpochHandlerInterface.Continuation)method.getCallback();
        FleaseMessage message = (FleaseMessage)method.getArgs()[0];
        String fileId = ReplicaUpdatePolicy.cellToFileId(message.getCellId());
        switch (method.getStageMethod()) {
            case 1: {
                try {
                    message.setMasterEpochNumber((long)this.layout.getMasterEpoch(fileId));
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "fetched master epoch for %s: %d", fileId, message.getMasterEpochNumber());
                    }
                }
                catch (IOException ex) {
                    Logging.logError(3, this, ex);
                    message.setMasterEpochNumber(-1L);
                }
                callback.processingFinished();
                break;
            }
            case 2: {
                try {
                    this.layout.setMasterEpoch(fileId, (int)message.getMasterEpochNumber());
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "set master epoch for %s: %d", fileId, message.getMasterEpochNumber());
                    }
                    callback.processingFinished();
                }
                catch (IOException ex) {
                    Logging.logError(3, this, ex);
                }
                break;
            }
            default: {
                throw new IllegalStateException("no such operation: " + method.getStageMethod());
            }
        }
    }

    public void sendMasterEpoch(FleaseMessage fm, MasterEpochHandlerInterface.Continuation cntntn) {
        this.enqueueOperation(1, new Object[]{fm}, null, cntntn);
    }

    public void storeMasterEpoch(FleaseMessage fm, MasterEpochHandlerInterface.Continuation cntntn) {
        this.enqueueOperation(2, new Object[]{fm}, null, cntntn);
    }
}

