/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.rwre;

import java.net.InetSocketAddress;
import java.util.List;

public class ObjectFetchRecord {
    private static final long NO_TRUNCATE = -1L;
    private final long objNumber;
    private long objVersion;
    private final List<InetSocketAddress> osds;
    private int osdToUse;
    private final long newFileSize;
    private final long newTruncateEpoch;

    public ObjectFetchRecord(long objNo, long objVer, List<InetSocketAddress> osds) {
        this.objNumber = objNo;
        this.objVersion = objVer;
        this.osds = osds;
        this.osdToUse = 0;
        this.newFileSize = -1L;
        this.newTruncateEpoch = 0L;
    }

    public ObjectFetchRecord(long newFileSize, long newTruncateEpoch) {
        this.newFileSize = newFileSize;
        this.newTruncateEpoch = newTruncateEpoch;
        this.objNumber = -1L;
        this.osds = null;
    }

    public boolean isTruncate() {
        return this.newFileSize != -1L;
    }

    public long getObjNumber() {
        return this.objNumber;
    }

    public long getObjVersion() {
        return this.objVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        try {
            ObjectFetchRecord ofr = (ObjectFetchRecord)o;
            return ofr.objNumber == this.objNumber;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public InetSocketAddress getNextOSD() {
        if (this.osdToUse < this.osds.size()) {
            return this.osds.get(this.osdToUse++);
        }
        return null;
    }

    List<InetSocketAddress> getOsds() {
        return this.osds;
    }

    public void setObjVersion(long objVersion) {
        this.objVersion = objVersion;
    }

    public String toString() {
        return this.objNumber + "@" + this.objVersion + " osds: " + this.osds;
    }

    public long getNewFileSize() {
        return this.newFileSize;
    }

    public long getNewTruncateEpoch() {
        return this.newTruncateEpoch;
    }
}

