/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.rwre;

import java.io.IOException;
import java.util.List;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.buffer.ASCIIString;
import org.xtreemfs.foundation.flease.Flease;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.rwre.RedirectToMasterException;
import org.xtreemfs.osd.rwre.ReplicatedFileState;
import org.xtreemfs.osd.rwre.WaR1UpdatePolicy;
import org.xtreemfs.osd.rwre.WaRaUpdatePolicy;
import org.xtreemfs.osd.rwre.WqRqUpdatePolicy;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public abstract class ReplicaUpdatePolicy {
    public static final long UNLIMITED_RESET = -1L;
    public static final String FILE_CELLID_PREFIX = "/file/";
    protected List<ServiceUUID> remoteOSDUUIDs;
    protected final ASCIIString cellId;
    protected long localObjVersion;
    protected final String localUUID;

    public static ReplicaUpdatePolicy newReplicaUpdatePolicy(String replicaUpdatePolicy, List<ServiceUUID> remoteOSDUUIDs, String localUUID, String fileId, OSDServiceClient client) {
        if (replicaUpdatePolicy.equals("WaR1")) {
            return new WaR1UpdatePolicy(remoteOSDUUIDs, localUUID, fileId, client);
        }
        if (replicaUpdatePolicy.equals("WaRa")) {
            return new WaRaUpdatePolicy(remoteOSDUUIDs, localUUID, fileId, client);
        }
        if (replicaUpdatePolicy.equals("WqRq")) {
            return new WqRqUpdatePolicy(remoteOSDUUIDs, localUUID, fileId, client);
        }
        throw new IllegalArgumentException("unsupported replica update mode: " + replicaUpdatePolicy);
    }

    protected ReplicaUpdatePolicy(List<ServiceUUID> remoteOSDUUIDs, String fileId, String localUUID) {
        this.remoteOSDUUIDs = remoteOSDUUIDs;
        this.cellId = ReplicaUpdatePolicy.fileToCellId(fileId);
        this.localUUID = localUUID;
        this.localObjVersion = -1L;
    }

    public static String cellToFileId(ASCIIString cellId) {
        return cellId.toString().substring(FILE_CELLID_PREFIX.length());
    }

    public static ASCIIString fileToCellId(String fileId) {
        return new ASCIIString(FILE_CELLID_PREFIX + fileId);
    }

    public List<ServiceUUID> getRemoteOSDUUIDs() {
        return this.remoteOSDUUIDs;
    }

    public ASCIIString getCellId() {
        return this.cellId;
    }

    public void objectFetched(long objVersion) {
        if (objVersion > this.localObjVersion) {
            this.localObjVersion = objVersion;
        }
    }

    public void setLocalObjectVersion(long localMaxObjVer) {
        this.localObjVersion = localMaxObjVer;
    }

    public abstract boolean requiresLease();

    public abstract void executeReset(GlobalTypes.FileCredentials var1, OSD.ReplicaStatus var2, ExecuteResetCallback var3);

    public abstract void executeWrite(GlobalTypes.FileCredentials var1, long var2, long var4, InternalObjectData var6, ClientOperationCallback var7);

    public abstract void executeTruncate(GlobalTypes.FileCredentials var1, long var2, long var4, ClientOperationCallback var6);

    public abstract long onClientOperation(RWReplicationStage.Operation var1, long var2, ReplicatedFileState.ReplicaState var4, Flease var5) throws RedirectToMasterException, IOException;

    public abstract boolean onRemoteUpdate(long var1, ReplicatedFileState.ReplicaState var3) throws IOException;

    public abstract boolean acceptRemoteUpdate(long var1) throws IOException;

    public abstract boolean onPrimary(int var1) throws IOException;

    public abstract boolean onBackup() throws IOException;

    public abstract void onFailed() throws IOException;

    public abstract void closeFile();

    public static interface ClientOperationCallback {
        public void finished();

        public void failed(RPC.RPCHeader.ErrorResponse var1);
    }

    public static interface ExecuteResetCallback {
        public void finished(OSD.AuthoritativeReplicaState var1);

        public void failed(RPC.RPCHeader.ErrorResponse var1);
    }
}

