/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.rwre;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.flease.Flease;
import org.xtreemfs.foundation.flease.FleaseStage;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.rwre.ReplicaUpdatePolicy;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class ReplicatedFileState {
    private final AtomicInteger queuedData = new AtomicInteger();
    private List<ServiceUUID> remoteOSDs;
    private ReplicaUpdatePolicy policy;
    private final String fileId;
    private ReplicaState state;
    private List<OSD.ObjectVersionMapping> objectsToFetch;
    private List<Stage.StageRequest> pendingRequests = new LinkedList<Stage.StageRequest>();
    private Flease lease;
    private boolean localIsPrimary;
    private GlobalTypes.FileCredentials credentials;
    private boolean cellOpen;
    private int numObjectsPending;
    private boolean primaryReset;
    private boolean forceReset;
    private XLocations loc;
    private long masterEpoch;
    private boolean invalidated;
    private boolean invalidatedReset;

    public ReplicatedFileState(String fileId, XLocations locations, ServiceUUID localUUID, FleaseStage fstage, OSDServiceClient client) throws UnknownUUIDException, IOException {
        this.fileId = fileId;
        this.state = ReplicaState.INITIALIZING;
        this.primaryReset = false;
        this.loc = locations;
        this.lease = Flease.EMPTY_LEASE;
        this.forceReset = false;
        this.masterEpoch = -1L;
        this.invalidated = false;
        this.invalidatedReset = false;
        this.remoteOSDs = new ArrayList<ServiceUUID>(locations.getNumReplicas() - 1);
        for (Replica r : locations.getReplicas()) {
            ServiceUUID headOSD = r.getHeadOsd();
            if (headOSD.equals(localUUID)) continue;
            this.remoteOSDs.add(headOSD);
        }
        this.policy = ReplicaUpdatePolicy.newReplicaUpdatePolicy(locations.getReplicaUpdatePolicy(), this.remoteOSDs, localUUID.toString(), fileId, client);
    }

    public GlobalTypes.FileCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(GlobalTypes.FileCredentials credentials) {
        this.credentials = credentials;
    }

    public String getFileId() {
        return this.fileId;
    }

    public boolean isCellOpen() {
        return this.cellOpen;
    }

    public void setCellOpen(boolean cellOpen) {
        this.cellOpen = cellOpen;
    }

    public int getNumObjectsPending() {
        return this.numObjectsPending;
    }

    public void setNumObjectsPending(int numObjectsPending) {
        this.numObjectsPending = numObjectsPending;
    }

    public boolean isPrimaryReset() {
        return this.primaryReset;
    }

    public void setPrimaryReset(boolean primaryReset) {
        this.primaryReset = primaryReset;
    }

    public StripingPolicyImpl getsPolicy() {
        return this.loc.getLocalReplica().getStripingPolicy();
    }

    public Replica getLocalReplica() {
        return this.loc.getLocalReplica();
    }

    public boolean isForceReset() {
        return this.forceReset;
    }

    public void setForceReset(boolean forceReset) {
        this.forceReset = forceReset;
    }

    public long getMasterEpoch() {
        return this.masterEpoch;
    }

    public void setMasterEpoch(long masterEpoch) {
        this.masterEpoch = masterEpoch;
    }

    public int getDataQueueLength() {
        return this.queuedData.get();
    }

    public ReplicaUpdatePolicy getPolicy() {
        return this.policy;
    }

    public void addPendingRequest(Stage.StageRequest request) {
        this.pendingRequests.add(request);
    }

    public Stage.StageRequest removePendingRequest() {
        Stage.StageRequest req = null;
        if (this.hasPendingRequests()) {
            req = this.pendingRequests.remove(0);
        }
        return req;
    }

    public void clearPendingRequests(RPC.RPCHeader.ErrorResponse error) {
        if (error != null) {
            for (Stage.StageRequest rq : this.pendingRequests) {
                Object callback = rq.getCallback();
                if (callback == null || !(callback instanceof RWReplicationStage.RWReplicationCallback)) continue;
                ((RWReplicationStage.RWReplicationCallback)callback).failed(error);
            }
        }
        this.pendingRequests.clear();
    }

    public boolean hasPendingRequests() {
        return !this.pendingRequests.isEmpty();
    }

    public int sizeOfPendingRequests() {
        return this.pendingRequests.size();
    }

    public ReplicaState getState() {
        return this.state;
    }

    public void setState(ReplicaState state) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "fileId %s changed state from: %s to: %s", new Object[]{this.fileId, this.state, state});
        }
        this.state = state;
    }

    public List<OSD.ObjectVersionMapping> getObjectsToFetch() {
        return this.objectsToFetch;
    }

    public void setObjectsToFetch(List<OSD.ObjectVersionMapping> objectsToFetch) {
        this.objectsToFetch = objectsToFetch;
    }

    public Flease getLease() {
        return this.lease;
    }

    public void setLease(Flease lease) {
        this.lease = lease;
    }

    public boolean isLocalIsPrimary() {
        return this.localIsPrimary;
    }

    public void setLocalIsPrimary(boolean localIsPrimary) {
        this.localIsPrimary = localIsPrimary;
    }

    public XLocations getLocations() {
        return this.loc;
    }

    public void setInvalidated(boolean invalidated) {
        this.invalidated = invalidated;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public void setInvalidatedReset(boolean invalidatedReset) {
        this.invalidatedReset = invalidatedReset;
    }

    public boolean isInvalidatedReset() {
        return this.invalidatedReset;
    }

    public static enum ReplicaState {
        INITIALIZING,
        OPEN,
        RESET,
        WAITING_FOR_LEASE,
        BACKUP,
        PRIMARY,
        INVALIDATED;

    }
}

