/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.rwre;

import java.util.List;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.osd.rwre.CoordinatedReplicaUpdatePolicy;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class WqRqUpdatePolicy
extends CoordinatedReplicaUpdatePolicy {
    final int numResponses;

    public WqRqUpdatePolicy(List<ServiceUUID> remoteOSDUUIDs, String localUUID, String fileId, OSDServiceClient client) {
        super(remoteOSDUUIDs, localUUID, fileId, client);
        this.numResponses = (int)Math.ceil((double)remoteOSDUUIDs.size() / 2.0);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.replication, this, "remote majority (excluding local replica) for %s is %d", fileId, this.numResponses);
        }
    }

    @Override
    public int getNumRequiredAcks(RWReplicationStage.Operation operation) {
        return this.numResponses;
    }

    @Override
    public boolean backupCanRead() {
        return false;
    }
}

