/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.stages;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.storage.FileMetadata;
import org.xtreemfs.osd.storage.MetadataCache;
import org.xtreemfs.osd.storage.StorageLayout;

public class DeletionStage
extends Stage {
    public static final int STAGEOP_DELETE_OBJECTS = 0;
    private MetadataCache cache;
    private StorageLayout layout;
    private OSDRequestDispatcher master;
    private DeleteThread deletor;
    private long numFilesDeleted;

    public DeletionStage(OSDRequestDispatcher master, MetadataCache cache, StorageLayout layout, int maxRequestsQueueLength) {
        super("OSD DelSt", maxRequestsQueueLength);
        this.master = master;
        this.cache = cache;
        this.layout = layout;
        this.deletor = new DeleteThread(layout);
    }

    @Override
    public void start() {
        super.start();
        this.deletor.start();
        this.deletor.setPriority(1);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.deletor.shutdown();
    }

    public void deleteObjects(String fileId, FileMetadata fi, boolean isCow, OSDRequest request, boolean deleteMetadata, DeleteObjectsCallback listener) {
        this.enqueueOperation(0, new Object[]{fileId, isCow, fi, deleteMetadata}, request, listener);
    }

    public long getNumFilesDeleted() {
        return this.numFilesDeleted;
    }

    @Override
    protected void processMethod(Stage.StageRequest method) {
        try {
            switch (method.getStageMethod()) {
                case 0: {
                    ++this.numFilesDeleted;
                    this.processDeleteObjects(method);
                    break;
                }
                default: {
                    method.sendInternalServerError(new RuntimeException("unknown stage op request"));
                    break;
                }
            }
        }
        catch (Throwable exc) {
            Logging.logError(3, this, exc);
            method.sendInternalServerError(exc);
            return;
        }
    }

    private void processDeleteObjects(Stage.StageRequest rq) {
        DeleteObjectsCallback cback = (DeleteObjectsCallback)rq.getCallback();
        String fileId = (String)rq.getArgs()[0];
        boolean cow = (Boolean)rq.getArgs()[1];
        FileMetadata fi = (FileMetadata)rq.getArgs()[2];
        boolean deleteMetadata = (Boolean)rq.getArgs()[3];
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.proc, this, "deleting objects of file %s", fileId);
        }
        if (fi == null) {
            fi = this.cache.getFileInfo(fileId);
        }
        this.cache.removeFileInfo(fileId);
        if (this.layout.fileExists(fileId)) {
            this.deletor.enqueueFileForDeletion(fileId, cow, fi, deleteMetadata);
        }
        cback.deleteComplete(null);
    }

    private static final class DeleteThread
    extends Thread {
        private transient boolean quit = false;
        private final StorageLayout layout;
        private final LinkedBlockingQueue<Object[]> files;

        public DeleteThread(StorageLayout layout) {
            this.layout = layout;
            this.files = new LinkedBlockingQueue();
        }

        public void shutdown() {
            this.quit = true;
            this.interrupt();
        }

        public void enqueueFileForDeletion(String fileID, boolean cow, FileMetadata fi, boolean deleteMetadata) {
            assert (this.isAlive());
            assert (fileID != null);
            this.files.add(new Object[]{fileID, cow, fi, deleteMetadata});
        }

        @Override
        public void run() {
            try {
                do {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.lifecycle, this, "DeleteThread started", new Object[0]);
                    }
                    Object[] file = this.files.take();
                    String fileId = (String)file[0];
                    boolean cow = (Boolean)file[1];
                    FileMetadata fi = (FileMetadata)file[2];
                    boolean deleteMetadata = (Boolean)file[3];
                    try {
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, Logging.Category.proc, this, "deleting objects for %s", fileId);
                        }
                        if (cow) {
                            if (fi == null) {
                                Logging.logMessage(3, this, "Deleting objects failed for COW enabled file %s, because FileMetadata is missing.", fileId);
                                continue;
                            }
                            if (fi.getVersionTable().getVersionCount() == 0L) {
                                this.layout.deleteFile(fileId, deleteMetadata);
                            } else {
                                for (Map.Entry<Long, Long> entry : fi.getLatestObjectVersions()) {
                                    long objNo = entry.getKey();
                                    long objVer = entry.getValue();
                                    if (fi.getVersionTable().isContained(objNo, objVer)) continue;
                                    this.layout.deleteObject(fileId, fi, objNo, objVer);
                                }
                                this.layout.updateCurrentVersionSize(fileId, 0L);
                            }
                        } else {
                            this.layout.deleteFile(fileId, deleteMetadata);
                        }
                        DeleteThread.yield();
                    }
                    catch (IOException ex) {
                        Logging.logError(3, this, ex);
                    }
                } while (!this.quit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.lifecycle, this, "DeleteThread finished", new Object[0]);
            }
        }
    }

    public static interface DeleteObjectsCallback {
        public void deleteComplete(RPC.RPCHeader.ErrorResponse var1);
    }
}

