/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.stages;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.ReplicaUpdatePolicies;
import org.xtreemfs.common.xloc.InvalidXLocationsException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.LRUCache;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.ASCIIString;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.AdvisoryLock;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.OpenFileTable;
import org.xtreemfs.osd.operations.EventCloseFile;
import org.xtreemfs.osd.operations.EventCreateFileVersion;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.rwre.ReplicaUpdatePolicy;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.storage.CowPolicy;
import org.xtreemfs.osd.storage.MetadataCache;
import org.xtreemfs.osd.storage.StorageLayout;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceConstants;

public class PreprocStage
extends Stage {
    public static final int STAGEOP_PARSE_AUTH_OFTOPEN = 1;
    public static final int STAGEOP_OFT_DELETE = 2;
    public static final int STAGEOP_ACQUIRE_LEASE = 3;
    public static final int STAGEOP_RETURN_LEASE = 4;
    public static final int STAGEOP_VERIFIY_CLEANUP = 5;
    public static final int STAGEOP_ACQUIRE_LOCK = 10;
    public static final int STAGEOP_CHECK_LOCK = 11;
    public static final int STAGEOP_UNLOCK = 12;
    public static final int STAGEOP_PING_FILE = 14;
    public static final int STAGEOP_CLOSE_FILE = 15;
    public static final int STAGEOP_INVALIDATE_XLOC = 16;
    public static final int STAGEOP_UPDATE_XLOC = 17;
    private static final long OFT_CLEAN_INTERVAL = 60000L;
    private static final long OFT_OPEN_EXTENSION = 30000L;
    private final Map<String, LRUCache<String, Capability>> capCache = new HashMap<String, LRUCache<String, Capability>>();
    private final OpenFileTable oft = new OpenFileTable();
    private long timeToNextOFTclean;
    private long lastOFTcheck;
    private volatile long numRequests;
    private final LRUCache<String, XLocations> xLocCache = new LRUCache(10000);
    private final MetadataCache metadataCache;
    private final StorageLayout layout;
    private final OSDRequestDispatcher master;
    private final boolean ignoreCaps;
    private static final int MAX_CAP_CACHE = 20;

    public PreprocStage(OSDRequestDispatcher master, MetadataCache metadataCache, StorageLayout layout, int maxRequestsQueueLength) {
        super("OSD PreProcSt", maxRequestsQueueLength);
        this.master = master;
        this.metadataCache = metadataCache;
        this.layout = layout;
        this.ignoreCaps = master.getConfig().isIgnoreCaps();
    }

    public void prepareRequest(OSDRequest request, ParseCompleteCallback listener) {
        this.enqueueOperation(1, new Object[]{request}, null, listener);
    }

    private void doPrepareRequest(Stage.StageRequest rq) {
        String fileId;
        OSDRequest request = (OSDRequest)rq.getArgs()[0];
        ParseCompleteCallback callback = (ParseCompleteCallback)rq.getCallback();
        ++this.numRequests;
        if (!this.parseRequest(request)) {
            return;
        }
        if (request.getOperation().requiresCapability()) {
            RPC.RPCHeader.ErrorResponse err;
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.stage, this, "STAGEOP AUTH", new Object[0]);
            }
            if ((err = this.processAuthenticate(request)) != null) {
                callback.parseComplete(request, err);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.net, this, "authentication of request failed: %s", ErrorUtils.formatError(err));
                }
                return;
            }
        }
        if (!request.getOperation().bypassViewValidation() && request.getLocationList() != null) {
            RPC.RPCHeader.ErrorResponse error;
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.stage, this, "STAGEOP VIEW", new Object[0]);
            }
            if ((error = this.processValidateView(request)) != null) {
                callback.parseComplete(request, error);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.misc, this, "request failed with an invalid view: %s", ErrorUtils.formatError(error));
                }
                return;
            }
        }
        if ((fileId = request.getFileId()) != null) {
            boolean write;
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.stage, this, "STAGEOP OPEN", new Object[0]);
            }
            CowPolicy cowPolicy = CowPolicy.PolicyNoCow;
            boolean bl = write = request.getCapability() != null && request.getCapability().getSnapConfig() != GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED && ((GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_WRONLY.getNumber()) & request.getCapability().getAccessMode()) > 0;
            if (this.oft.contains(fileId)) {
                cowPolicy = this.oft.refresh(fileId, TimeSync.getLocalSystemTime() + 30000L, write);
            } else {
                cowPolicy = request.getCapability() == null || request.getCapability().getSnapConfig() == GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED ? CowPolicy.PolicyNoCow : new CowPolicy(CowPolicy.cowMode.COW_ONCE);
                this.oft.openFile(fileId, TimeSync.getLocalSystemTime() + 30000L, cowPolicy, write);
                request.setFileOpen(true);
            }
            request.setCowPolicy(cowPolicy);
        }
        callback.parseComplete(request, null);
    }

    public void pingFile(String fileId) {
        this.enqueueOperation(14, new Object[]{fileId}, null, null);
    }

    private void doPingFile(Stage.StageRequest m) {
        String fileId = (String)m.getArgs()[0];
        this.oft.refresh(fileId, TimeSync.getLocalSystemTime() + 30000L, false);
    }

    public void checkDeleteOnClose(String fileId, DeleteOnCloseCallback listener) {
        this.enqueueOperation(2, new Object[]{fileId}, null, listener);
    }

    private void doCheckDeleteOnClose(Stage.StageRequest m) {
        String fileId = (String)m.getArgs()[0];
        DeleteOnCloseCallback callback = (DeleteOnCloseCallback)m.getCallback();
        boolean deleteOnClose = this.oft.contains(fileId);
        if (deleteOnClose) {
            this.oft.setDeleteOnClose(fileId);
        }
        callback.deleteOnCloseResult(deleteOnClose, null);
    }

    public void acquireLock(String clientUuid, int pid, String fileId, long offset, long length, boolean exclusive, OSDRequest request, LockOperationCompleteCallback listener) {
        this.enqueueOperation(10, new Object[]{clientUuid, pid, fileId, offset, length, exclusive}, request, listener);
    }

    public void doAcquireLock(Stage.StageRequest m) {
        LockOperationCompleteCallback callback = (LockOperationCompleteCallback)m.getCallback();
        try {
            String clientUuid = (String)m.getArgs()[0];
            Integer pid = (Integer)m.getArgs()[1];
            String fileId = (String)m.getArgs()[2];
            Long offset = (Long)m.getArgs()[3];
            Long length = (Long)m.getArgs()[4];
            Boolean exclusive = (Boolean)m.getArgs()[5];
            OpenFileTable.OpenFileTableEntry e = this.oft.getEntry(fileId);
            if (e == null) {
                callback.parseComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_EIO, "no entry in OFT, programmatic error"));
                return;
            }
            AdvisoryLock l = e.acquireLock(clientUuid, pid, offset, length, exclusive);
            if (l != null) {
                OSD.Lock lock = OSD.Lock.newBuilder().setClientPid(l.getClientPid()).setClientUuid(l.getClientUuid()).setLength(l.getLength()).setOffset(l.getOffset()).setExclusive(l.isExclusive()).build();
                callback.parseComplete(lock, null);
            } else {
                callback.parseComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EAGAIN, "conflicting lock"));
            }
        }
        catch (Exception ex) {
            callback.parseComplete(null, ErrorUtils.getInternalServerError(ex));
        }
    }

    public void checkLock(String clientUuid, int pid, String fileId, long offset, long length, boolean exclusive, OSDRequest request, LockOperationCompleteCallback listener) {
        this.enqueueOperation(11, new Object[]{clientUuid, pid, fileId, offset, length, exclusive}, request, listener);
    }

    public void doCheckLock(Stage.StageRequest m) {
        LockOperationCompleteCallback callback = (LockOperationCompleteCallback)m.getCallback();
        try {
            String clientUuid = (String)m.getArgs()[0];
            Integer pid = (Integer)m.getArgs()[1];
            String fileId = (String)m.getArgs()[2];
            Long offset = (Long)m.getArgs()[3];
            Long length = (Long)m.getArgs()[4];
            Boolean exclusive = (Boolean)m.getArgs()[5];
            OpenFileTable.OpenFileTableEntry e = this.oft.getEntry(fileId);
            if (e == null) {
                callback.parseComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_EIO, "no entry in OFT, programmatic error"));
                return;
            }
            AdvisoryLock l = e.checkLock(clientUuid, pid, offset, length, exclusive);
            OSD.Lock lock = OSD.Lock.newBuilder().setClientPid(l.getClientPid()).setClientUuid(l.getClientUuid()).setLength(l.getLength()).setOffset(l.getOffset()).setExclusive(l.isExclusive()).build();
            callback.parseComplete(lock, null);
        }
        catch (Exception ex) {
            callback.parseComplete(null, ErrorUtils.getInternalServerError(ex));
        }
    }

    public void unlock(String clientUuid, int pid, String fileId, OSDRequest request, LockOperationCompleteCallback listener) {
        this.enqueueOperation(12, new Object[]{clientUuid, pid, fileId}, request, listener);
    }

    public void doUnlock(Stage.StageRequest m) {
        LockOperationCompleteCallback callback = (LockOperationCompleteCallback)m.getCallback();
        try {
            String clientUuid = (String)m.getArgs()[0];
            Integer pid = (Integer)m.getArgs()[1];
            String fileId = (String)m.getArgs()[2];
            OpenFileTable.OpenFileTableEntry e = this.oft.getEntry(fileId);
            if (e == null) {
                callback.parseComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_EIO, "no entry in OFT, programmatic error"));
                return;
            }
            e.unlock(clientUuid, pid);
            callback.parseComplete(null, null);
        }
        catch (Exception ex) {
            callback.parseComplete(null, ErrorUtils.getInternalServerError(ex));
        }
    }

    public void close(String fileId, CloseCallback listener) {
        this.enqueueOperation(15, new Object[]{fileId}, null, listener);
    }

    private void doClose(Stage.StageRequest m) {
        String fileId = (String)m.getArgs()[0];
        CloseCallback callback = (CloseCallback)m.getCallback();
        OpenFileTable.OpenFileTableEntry entry = this.oft.close(fileId);
        LRUCache<String, Capability> cachedCaps = this.capCache.remove(entry.getFileId());
        callback.closeResult(entry, null);
    }

    @Override
    public void run() {
        this.notifyStarted();
        this.timeToNextOFTclean = 60000L;
        this.lastOFTcheck = TimeSync.getLocalSystemTime();
        while (!this.quit) {
            try {
                Stage.StageRequest op = (Stage.StageRequest)this.q.poll(this.timeToNextOFTclean, TimeUnit.MILLISECONDS);
                this.checkOpenFileTable(false);
                if (op == null) continue;
                this.processMethod(op);
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (Throwable ex) {
                this.notifyCrashed(ex);
                break;
            }
        }
        this.notifyStopped();
    }

    private void checkOpenFileTable(boolean force) {
        long tPassed = TimeSync.getLocalSystemTime() - this.lastOFTcheck;
        this.timeToNextOFTclean -= tPassed;
        if (force || this.timeToNextOFTclean <= 0L) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "OpenFileTable clean", new Object[0]);
            }
            long currentTime = TimeSync.getLocalSystemTime();
            List<OpenFileTable.OpenFileTableEntry> closedFiles = this.oft.clean(currentTime);
            for (OpenFileTable.OpenFileTableEntry entry : closedFiles) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.stage, this, "send internal close event for %s, deleteOnClose=%b", entry.getFileId(), entry.isDeleteOnClose());
                }
                this.capCache.remove(entry.getFileId());
                OSDOperation closeEvent = this.master.getInternalEvent(EventCloseFile.class);
                closeEvent.startInternalEvent(new Object[]{entry.getFileId(), entry.isDeleteOnClose(), entry.getCowPolicy().cowEnabled(), entry.isWrite()});
            }
            List<OpenFileTable.OpenFileTableEntry> closedWrittenFiles = this.oft.cleanWritten(currentTime);
            for (OpenFileTable.OpenFileTableEntry entry : closedWrittenFiles) {
                if (entry.isClosed() || !entry.isWrite()) continue;
                entry.clearWrite();
                OSDOperation createVersionEvent = this.master.getInternalEvent(EventCreateFileVersion.class);
                createVersionEvent.startInternalEvent(new Object[]{entry.getFileId(), this.metadataCache.getFileInfo(entry.getFileId())});
            }
            this.timeToNextOFTclean = 60000L;
        }
        this.lastOFTcheck = TimeSync.getLocalSystemTime();
    }

    @Override
    protected void processMethod(Stage.StageRequest m) {
        int requestedMethod = m.getStageMethod();
        switch (requestedMethod) {
            case 1: {
                this.doPrepareRequest(m);
                break;
            }
            case 2: {
                this.doCheckDeleteOnClose(m);
                break;
            }
            case 10: {
                this.doAcquireLock(m);
                break;
            }
            case 11: {
                this.doCheckLock(m);
                break;
            }
            case 12: {
                this.doUnlock(m);
                break;
            }
            case 14: {
                this.doPingFile(m);
                break;
            }
            case 15: {
                this.doClose(m);
                break;
            }
            case 16: {
                this.doInvalidateXLocSet(m);
                break;
            }
            case 17: {
                this.doUpdateXLocSetFromFlease(m);
                break;
            }
            default: {
                Logging.logMessage(3, this, "unknown stageop called: %d", requestedMethod);
            }
        }
    }

    private boolean parseRequest(OSDRequest rq) {
        RPC.RPCHeader hdr = rq.getRpcRequest().getHeader();
        if (hdr.getMessageType() != RPC.MessageType.RPC_REQUEST) {
            rq.sendError(RPC.ErrorType.GARBAGE_ARGS, RPC.POSIXErrno.POSIX_ERROR_EIO, "expected RPC request message type but got " + hdr.getMessageType());
            return false;
        }
        RPC.RPCHeader.RequestHeader rqHdr = hdr.getRequestHeader();
        if (rqHdr.getInterfaceId() != 30001) {
            rq.sendError(RPC.ErrorType.INVALID_INTERFACE_ID, RPC.POSIXErrno.POSIX_ERROR_EIO, "invalid interface id. Maybe wrong service address/port configured?");
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.net, this, "invalid version requested (requested=%d avail=%d)", rqHdr.getInterfaceId(), 30001);
            }
            return false;
        }
        OSDOperation op = this.master.getOperation(rqHdr.getProcId());
        if (op == null) {
            rq.sendError(RPC.ErrorType.INVALID_PROC_ID, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "requested operation is not available on this OSD (proc # " + rqHdr.getProcId() + ")");
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.net, this, "requested operation is not available on this OSD (proc #%d)", rqHdr.getProcId());
            }
            return false;
        }
        rq.setOperation(op);
        try {
            RPC.RPCHeader.ErrorResponse err;
            Message rqPrototype = OSDServiceConstants.getRequestMessage(rqHdr.getProcId());
            if (rqPrototype == null) {
                rq.setRequestArgs(null);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.net, this, "received request with empty message", new Object[0]);
                }
            } else if (rq.getRPCRequest().getMessage() != null) {
                rq.setRequestArgs(rqPrototype.newBuilderForType().mergeFrom(new ReusableBufferInputStream(rq.getRPCRequest().getMessage())).build());
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.net, this, "received request of type %s", rq.getRequestArgs().getClass().getName());
                }
            } else {
                rq.setRequestArgs((Message)rqPrototype.getDefaultInstanceForType());
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.net, this, "received request of type %s (empty message)", rq.getRequestArgs().getClass().getName());
                }
            }
            if ((err = op.parseRPCMessage(rq)) != null) {
                rq.getRpcRequest().sendError(err);
                return false;
            }
        }
        catch (Throwable ex) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, OutputUtils.stackTraceToString(ex), new Object[0]);
            }
            rq.getRpcRequest().sendError(ErrorUtils.getInternalServerError(ex));
            return false;
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.stage, this, "request parsed: %d", rq.getRequestId());
        }
        return true;
    }

    private RPC.RPCHeader.ErrorResponse processAuthenticate(OSDRequest rq) {
        Capability cap;
        Capability rqCap = rq.getCapability();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "capability: %s", rqCap.getXCap().toString().replace('\n', '/'));
        }
        if (rqCap.getFileId().length() == 0) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid capability. file_id must not be empty");
        }
        if (rqCap.getEpochNo() < 0) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid capability. epoch must not be < 0");
        }
        if (this.ignoreCaps) {
            return null;
        }
        boolean isValid = false;
        LRUCache<String, Capability> cachedCaps = this.capCache.get(rqCap.getFileId());
        if (cachedCaps != null && (cap = (Capability)cachedCaps.get(rqCap.getSignature())) != null) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "using cached cap: %s %s", cap.getFileId(), cap.getSignature());
            }
            boolean bl = isValid = !cap.hasExpired();
        }
        if (!isValid && (isValid = rqCap.isValid())) {
            if (cachedCaps == null) {
                cachedCaps = new LRUCache(20);
                this.capCache.put(rqCap.getFileId(), cachedCaps);
            }
            cachedCaps.put(rqCap.getSignature(), rqCap);
        }
        if (!isValid) {
            if (rqCap.hasExpired()) {
                return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "capability is not valid (timed out)");
            }
            if (!rqCap.hasValidSignature()) {
                return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "capability is not valid (invalid signature)");
            }
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "capability is not valid (unknown cause)");
        }
        if (!rqCap.getFileId().equals(rq.getFileId())) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "capability was issued for another file than the one requested");
        }
        if (rq.getOperation().getProcedureId() == 10) {
            if ((rqCap.getAccessMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_WRONLY.getNumber()) != 0) {
                return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "capability does not allow read access to file " + rqCap.getFileId());
            }
        } else if (rq.getOperation().getProcedureId() == 13) {
            if ((rqCap.getAccessMode() & (GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_WRONLY.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber())) == 0) {
                return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "capability does not allow write access to file " + rqCap.getFileId());
            }
        } else if (rq.getOperation().getProcedureId() == 11) {
            if ((rqCap.getAccessMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber()) == 0) {
                return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "capability does not allow truncate access to file " + rqCap.getFileId());
            }
        } else if (rq.getOperation().getProcedureId() == 12 && (rqCap.getAccessMode() & 0x200000) == 0) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EACCES, "capability does not allow delete access to file " + rqCap.getFileId());
        }
        return null;
    }

    private RPC.RPCHeader.ErrorResponse processValidateView(OSDRequest request) {
        OSD.XLocSetVersionState state;
        String fileId = request.getFileId();
        if (fileId == null || fileId.length() == 0) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Invalid view. file_id must not be empty.");
        }
        try {
            state = this.layout.getXLocSetVersionState(fileId);
        }
        catch (IOException e) {
            return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, "Invalid view. Local version could not be read.");
        }
        XLocations locset = request.getLocationList();
        if (state.getVersion() == locset.getVersion() && !state.getInvalidated()) {
            return null;
        }
        if (locset.getVersion() > state.getVersion()) {
            OSD.XLocSetVersionState newstate = state.toBuilder().setInvalidated(false).setVersion(locset.getVersion()).setModifiedTime(TimeSync.getGlobalTime()).build();
            try {
                this.layout.setXLocSetVersionState(fileId, newstate);
                if (locset.getNumReplicas() > 1 && ReplicaUpdatePolicies.isRwReplicated(locset.getReplicaUpdatePolicy())) {
                    ASCIIString cellId = ReplicaUpdatePolicy.fileToCellId(fileId);
                    this.master.getRWReplicationStage().setFleaseView(fileId, cellId, newstate);
                }
            }
            catch (IOException e) {
                return ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, "Invalid view. Local version could not be written.");
            }
            return null;
        }
        String errorMessage = state.getInvalidated() ? "Replica is invalidated." : "The request is based on an outdated view(" + locset.getVersion() + " < " + state.getVersion() + ").";
        return ErrorUtils.getErrorResponse(RPC.ErrorType.INVALID_VIEW, RPC.POSIXErrno.POSIX_ERROR_NONE, "View is not valid. " + errorMessage);
    }

    public void updateXLocSetFromFlease(ASCIIString cellId, int version) {
        this.enqueueOperation(17, new Object[]{cellId, version}, null, null);
    }

    private void doUpdateXLocSetFromFlease(Stage.StageRequest m) {
        OSD.XLocSetVersionState state;
        ASCIIString cellId = (ASCIIString)m.getArgs()[0];
        int version = (Integer)m.getArgs()[1];
        String fileId = ReplicaUpdatePolicy.cellToFileId(cellId);
        try {
            state = this.layout.getXLocSetVersionState(fileId);
        }
        catch (IOException e) {
            Logging.logMessage(3, Logging.Category.storage, this, "VersionState could not be read for fileId: %s", fileId);
            return;
        }
        if (state.getVersion() < version) {
            state = state.toBuilder().setInvalidated(false).setVersion(version).setModifiedTime(TimeSync.getGlobalTime()).build();
            try {
                this.layout.setXLocSetVersionState(fileId, state);
                this.master.getRWReplicationStage().setFleaseView(fileId, cellId, state);
            }
            catch (IOException e) {
                Logging.logMessage(3, Logging.Category.storage, this, "VersionState could not be written for fileId: %s", fileId);
                return;
            }
        }
    }

    public void invalidateXLocSet(OSDRequest request, GlobalTypes.FileCredentials fileCreds, boolean validateView, InvalidateXLocSetCallback listener) {
        this.enqueueOperation(16, new Object[]{fileCreds, validateView}, request, listener);
    }

    private void doInvalidateXLocSet(Stage.StageRequest m) {
        OSDRequest request = m.getRequest();
        String fileId = request.getFileId();
        XLocations xLoc = request.getLocationList();
        GlobalTypes.FileCredentials fileCreds = (GlobalTypes.FileCredentials)m.getArgs()[0];
        boolean validateView = (Boolean)m.getArgs()[1];
        InvalidateXLocSetCallback callback = (InvalidateXLocSetCallback)m.getCallback();
        try {
            OSD.XLocSetVersionState.Builder stateBuilder = this.layout.getXLocSetVersionState(fileId).toBuilder();
            if (validateView && !stateBuilder.getInvalidated() && stateBuilder.getVersion() > xLoc.getVersion()) {
                throw new InvalidXLocationsException("View is not valid. The requests is based on an outdated view.");
            }
            if (stateBuilder.getVersion() < xLoc.getVersion()) {
                stateBuilder.setVersion(xLoc.getVersion());
            }
            stateBuilder.setInvalidated(true).setModifiedTime(TimeSync.getGlobalTime());
            OSD.XLocSetVersionState state = stateBuilder.build();
            this.layout.setXLocSetVersionState(fileId, state);
            if (xLoc.getNumReplicas() > 1 && ReplicaUpdatePolicies.isRwReplicated(xLoc.getReplicaUpdatePolicy())) {
                this.master.getRWReplicationStage().invalidateReplica(fileId, fileCreds, xLoc, callback);
            } else {
                callback.invalidateComplete(GlobalTypes.LeaseState.NONE, null);
            }
        }
        catch (InvalidXLocationsException e) {
            RPC.RPCHeader.ErrorResponse error = ErrorUtils.getErrorResponse(RPC.ErrorType.INVALID_VIEW, RPC.POSIXErrno.POSIX_ERROR_NONE, e.getMessage(), e);
            callback.invalidateComplete(GlobalTypes.LeaseState.NONE, error);
        }
        catch (IOException e) {
            Logging.logMessage(3, Logging.Category.storage, this, "VersionState could not be written for fileId: %s", fileId);
            RPC.RPCHeader.ErrorResponse error = ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, "Invalid view. Local version could not be written.");
            callback.invalidateComplete(GlobalTypes.LeaseState.NONE, error);
        }
    }

    public int getNumOpenFiles() {
        return this.oft.getNumOpenFiles();
    }

    public long getNumRequests() {
        return this.numRequests;
    }

    public static interface InvalidateXLocSetCallback {
        public void invalidateComplete(GlobalTypes.LeaseState var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface CloseCallback {
        public void closeResult(OpenFileTable.OpenFileTableEntry var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface LockOperationCompleteCallback {
        public void parseComplete(OSD.Lock var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface DeleteOnCloseCallback {
        public void deleteOnCloseResult(boolean var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface ParseCompleteCallback {
        public void parseComplete(OSDRequest var1, RPC.RPCHeader.ErrorResponse var2);
    }
}

