/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.stages;

import java.io.IOException;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.replication.ObjectDissemination;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.storage.CowPolicy;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class ReplicationStage
extends Stage {
    public static final int STAGEOP_FETCH_OBJECT = 1;
    public static final int STAGEOP_INTERNAL_OBJECT_FETCHED = 2;
    public static final int STAGEOP_CANCEL_REPLICATION_FOR_FILE = 3;
    public static final int STAGEOP_START_NEW_REPLICATION_FOR_FILE = 4;
    private OSDRequestDispatcher master;
    private ObjectDissemination disseminationLayer;

    public ReplicationStage(OSDRequestDispatcher master, int maxRequestsQueueLength) {
        super("OSD ReplSt", maxRequestsQueueLength);
        this.master = master;
        this.disseminationLayer = new ObjectDissemination(master);
    }

    @Override
    public void shutdown() {
        this.disseminationLayer.shutdown();
        super.shutdown();
    }

    public void fetchObject(String fileId, long objectNo, XLocations xLoc, Capability cap, CowPolicy cow, OSDRequest request, FetchObjectCallback listener) {
        this.enqueueOperation(1, new Object[]{fileId, objectNo, xLoc, cap, cow}, request, listener);
    }

    public void internalObjectFetched(String fileId, long objectNo, ServiceUUID usedOSD, InternalObjectData data, OSD.ObjectList objectList, RPC.RPCHeader.ErrorResponse error) {
        this.enqueueOperation(2, new Object[]{fileId, objectNo, usedOSD, data, objectList, error}, null, null);
    }

    public void cancelReplicationForFile(String fileId) {
        this.enqueueOperation(3, new Object[]{fileId}, null, null);
    }

    public void triggerReplicationForFile(String fileId) {
        this.enqueueOperation(4, new Object[]{fileId}, null, null);
    }

    @Override
    protected void processMethod(Stage.StageRequest rq) {
        try {
            switch (rq.getStageMethod()) {
                case 1: {
                    this.processFetchObject(rq);
                    break;
                }
                case 2: {
                    this.processInternalObjectFetched(rq);
                    break;
                }
                case 3: {
                    this.processInternalCancelFile(rq);
                    break;
                }
                case 4: {
                    this.processInternalStartFile(rq);
                    break;
                }
                default: {
                    rq.sendInternalServerError(new RuntimeException("unknown stage op request"));
                    break;
                }
            }
        }
        catch (Throwable exc) {
            Logging.logError(3, this, exc);
            rq.sendInternalServerError(exc);
            return;
        }
    }

    private void processFetchObject(Stage.StageRequest rq) throws IOException, JSONException {
        FetchObjectCallback callback = (FetchObjectCallback)rq.getCallback();
        String fileId = (String)rq.getArgs()[0];
        long objectNo = (Long)rq.getArgs()[1];
        XLocations xLoc = (XLocations)rq.getArgs()[2];
        Capability cap = (Capability)rq.getArgs()[3];
        CowPolicy cow = (CowPolicy)rq.getArgs()[4];
        if (xLoc.getNumReplicas() > 1 && !xLoc.getLocalReplica().isComplete()) {
            this.disseminationLayer.fetchObject(fileId, objectNo, xLoc, cap, cow, rq);
        } else {
            callback.fetchComplete(new ObjectInformation(ObjectInformation.ObjectStatus.PADDING_OBJECT, null, xLoc.getLocalReplica().getStripingPolicy().getStripeSizeForObject(objectNo)), null);
        }
    }

    private void processInternalObjectFetched(Stage.StageRequest rq) {
        String fileId = (String)rq.getArgs()[0];
        long objectNo = (Long)rq.getArgs()[1];
        ServiceUUID usedOSD = (ServiceUUID)rq.getArgs()[2];
        InternalObjectData data = (InternalObjectData)rq.getArgs()[3];
        OSD.ObjectList objectList = (OSD.ObjectList)rq.getArgs()[4];
        RPC.RPCHeader.ErrorResponse error = (RPC.RPCHeader.ErrorResponse)rq.getArgs()[5];
        if (error != null) {
            if (error.getErrorType() == RPC.ErrorType.INVALID_VIEW) {
                this.disseminationLayer.sendError(fileId, error);
            } else {
                this.disseminationLayer.objectNotFetched(fileId, usedOSD, objectNo, data);
                if (data != null && data.getData() != null) {
                    BufferPool.free(data.getData());
                }
            }
        } else {
            if (objectList != null) {
                try {
                    ObjectSet objectSet = new ObjectSet(objectList.getStripeWidth(), objectList.getFirst(), objectList.getSet().toByteArray());
                    this.disseminationLayer.objectSetFetched(fileId, usedOSD, objectSet, objectList.getSet().size());
                }
                catch (IOException e) {
                    Logging.logError(3, this, e);
                }
                catch (ClassNotFoundException e) {
                    Logging.logError(3, this, e);
                }
            }
            if (data != null && data.getData() != null && data.getData().limit() != 0) {
                this.disseminationLayer.objectFetched(fileId, objectNo, usedOSD, data);
            } else {
                this.disseminationLayer.objectNotFetched(fileId, usedOSD, objectNo, data);
                if (data != null) {
                    BufferPool.free(data.getData());
                }
            }
        }
    }

    private void processInternalCancelFile(Stage.StageRequest rq) {
        String fileId = (String)rq.getArgs()[0];
        this.disseminationLayer.cancelFile(fileId);
    }

    private void processInternalStartFile(Stage.StageRequest rq) {
        String fileId = (String)rq.getArgs()[0];
        this.disseminationLayer.startNewReplication(fileId);
    }

    public static interface FetchObjectCallback {
        public void fetchComplete(ObjectInformation var1, RPC.RPCHeader.ErrorResponse var2);
    }
}

