/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.stages;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.OSDRequest;

public abstract class Stage
extends LifeCycleThread {
    protected BlockingQueue<StageRequest> q = new LinkedBlockingQueue<StageRequest>();
    private final int queueCapacity;
    protected volatile boolean quit;
    public AtomicInteger _numRq;
    public AtomicInteger _maxRqTime;
    public AtomicInteger _minRqTime;
    public AtomicLong _sumRqTime;

    public Stage(String stageName, int queueCapacity) {
        super(stageName);
        this.queueCapacity = queueCapacity;
        this.quit = false;
        this._numRq = new AtomicInteger(0);
        this._maxRqTime = new AtomicInteger(0);
        this._minRqTime = new AtomicInteger(Integer.MAX_VALUE);
        this._sumRqTime = new AtomicLong(0L);
    }

    protected void enqueueOperation(int stageOp, Object[] args, OSDRequest request, Object callback) {
        this.enqueueOperation(stageOp, args, request, null, callback);
    }

    protected void enqueueOperation(int stageOp, Object[] args, OSDRequest request, ReusableBuffer createdViewBuffer, Object callback) {
        if (request == null) {
            try {
                this.q.put(new StageRequest(stageOp, args, request, callback));
            }
            catch (InterruptedException e) {
                Logging.logMessage(7, Logging.Category.stage, this, "Failed to queue internal request due to InterruptedException:", new Object[0]);
                Logging.logError(7, this, e);
            }
        } else if (this.q.size() < this.queueCapacity) {
            try {
                this.q.put(new StageRequest(stageOp, args, request, callback));
            }
            catch (InterruptedException e) {
                Logging.logMessage(7, Logging.Category.stage, this, "Failed to queue external request due to InterruptedException:", new Object[0]);
                Logging.logError(7, this, e);
            }
        } else {
            if (createdViewBuffer != null) {
                assert (createdViewBuffer.getRefCount() >= 2);
                BufferPool.free(createdViewBuffer);
            }
            Logging.logMessage(4, this, "stage is overloaded, request %d for %s dropped", request.getRequestId(), request.getFileId());
            request.sendInternalServerError(new IllegalStateException("server overloaded, request dropped"));
        }
    }

    @Override
    public void shutdown() {
        this.quit = true;
        this.interrupt();
    }

    public int getQueueLength() {
        return this.q.size();
    }

    @Override
    public void run() {
        this.notifyStarted();
        while (!this.quit) {
            try {
                StageRequest op = this.q.take();
                this.processMethod(op);
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (Throwable ex) {
                this.notifyCrashed(ex);
                break;
            }
        }
        this.notifyStopped();
    }

    protected void calcRequestDuration(OSDRequest rq) {
    }

    protected abstract void processMethod(StageRequest var1);

    public static final class StageRequest {
        private int stageMethod;
        private Object callback;
        private Object[] args;
        private final OSDRequest request;

        public StageRequest(int stageMethod, Object[] args, OSDRequest request, Object callback) {
            this.args = args;
            this.stageMethod = stageMethod;
            this.callback = callback;
            this.request = request;
        }

        public int getStageMethod() {
            return this.stageMethod;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Object getCallback() {
            return this.callback;
        }

        public OSDRequest getRequest() {
            return this.request;
        }

        public void sendInternalServerError(Throwable cause) {
            if (this.request != null) {
                this.request.sendInternalServerError(cause);
            } else {
                Logging.logMessage(3, this, "internal server error in internal event: %s", cause.toString());
                Logging.logError(3, this, cause);
            }
        }
    }

    public static interface NullCallback {
        public void callback(RPC.RPCHeader.ErrorResponse var1);
    }
}

