/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.stages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.storage.CowPolicy;
import org.xtreemfs.osd.storage.FileMetadata;
import org.xtreemfs.osd.storage.MetadataCache;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.osd.storage.StorageLayout;
import org.xtreemfs.osd.storage.StorageThread;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class StorageStage
extends Stage {
    private StorageThread[] storageThreads;
    private final StorageLayout layout;

    public StorageStage(OSDRequestDispatcher master, MetadataCache cache, StorageLayout layout, int numOfThreads, int maxRequestsQueueLength) throws IOException {
        super("OSD Storage Stage", maxRequestsQueueLength);
        this.layout = layout;
        int numberOfThreads = 5;
        if (numOfThreads > 0) {
            numberOfThreads = numOfThreads;
        }
        this.storageThreads = new StorageThread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            this.storageThreads[i] = new StorageThread(i, master, cache, layout, maxRequestsQueueLength);
            this.storageThreads[i].setLifeCycleListener(master);
        }
    }

    public StorageLayout getStorageLayout() {
        return this.layout;
    }

    public void readObject(String fileId, long objNo, StripingPolicyImpl sp, int offset, int length, long versionTimestamp, OSDRequest request, ReadObjectCallback listener) {
        this.enqueueOperation(fileId, 1, new Object[]{fileId, objNo, sp, offset, length, versionTimestamp}, request, (Object)listener);
    }

    public void getFilesize(String fileId, StripingPolicyImpl sp, long versionTimestamp, OSDRequest request, GetFileSizeCallback listener) {
        this.enqueueOperation(fileId, 7, new Object[]{fileId, sp, versionTimestamp}, request, (Object)listener);
    }

    public void writeObject(String fileId, long objNo, StripingPolicyImpl sp, int offset, ReusableBuffer data, CowPolicy cow, XLocations xloc, boolean sync, Long newVersion, OSDRequest request, ReusableBuffer createdViewBuffer, WriteObjectCallback listener) {
        this.enqueueOperation(fileId, 2, new Object[]{fileId, objNo, sp, offset, data, cow, xloc, false, sync, newVersion}, request, createdViewBuffer, listener);
    }

    public void insertPaddingObject(String fileId, long objNo, StripingPolicyImpl sp, int size, OSDRequest request, WriteObjectCallback listener) {
        this.enqueueOperation(fileId, 9, new Object[]{fileId, objNo, sp, size}, request, (Object)listener);
    }

    public void writeObjectWithoutGMax(String fileId, long objNo, StripingPolicyImpl sp, int offset, ReusableBuffer data, CowPolicy cow, XLocations xloc, boolean sync, Long newVersion, OSDRequest request, WriteObjectCallback listener) {
        this.enqueueOperation(fileId, 2, new Object[]{fileId, objNo, sp, offset, data, cow, xloc, true, sync, newVersion}, request, (Object)listener);
    }

    public void truncate(String fileId, long newFileSize, StripingPolicyImpl sp, Replica currentReplica, long truncateEpoch, CowPolicy cow, Long newObjVer, Boolean createTruncateLogEntry, OSDRequest request, TruncateCallback listener) {
        this.enqueueOperation(fileId, 3, new Object[]{fileId, newFileSize, sp, currentReplica, truncateEpoch, cow, newObjVer, createTruncateLogEntry}, request, (Object)listener);
    }

    public void deleteObjects(String fileId, StripingPolicyImpl sp, long truncateEpoch, Map<Long, Long> objectVersionsToBeDeleted, DeleteObjectsCallback listener) {
        this.enqueueOperation(fileId, 14, new Object[]{fileId, sp, truncateEpoch, objectVersionsToBeDeleted}, null, (Object)listener);
    }

    public void flushCaches(String fileId, CachesFlushedCallback listener) {
        this.enqueueOperation(fileId, 4, new Object[]{fileId}, null, (Object)listener);
    }

    public void receivedGMAX_ASYNC(String fileId, long epoch, long lastObject) {
        this.enqueueOperation(fileId, 5, new Object[]{fileId, epoch, lastObject}, null, null);
    }

    public void internalGetGmax(String fileId, StripingPolicyImpl sp, long snapTimestamp, OSDRequest request, InternalGetGmaxCallback listener) {
        this.enqueueOperation(fileId, 6, new Object[]{fileId, sp, snapTimestamp}, request, (Object)listener);
    }

    public void internalGetMaxObjectNo(String fileId, StripingPolicyImpl sp, InternalGetMaxObjectNoCallback callback) {
        this.enqueueOperation(fileId, 10, new Object[]{fileId, sp}, null, (Object)callback);
    }

    public void internalGetReplicaState(String fileId, StripingPolicyImpl sp, long remoteMaxObjVersion, InternalGetReplicaStateCallback callback) {
        this.enqueueOperation(fileId, 12, new Object[]{fileId, sp, remoteMaxObjVersion}, null, (Object)callback);
    }

    public void getObjectSet(String fileId, StripingPolicyImpl sp, OSDRequest request, GetObjectListCallback listener) {
        this.enqueueOperation(fileId, 8, new Object[]{fileId, sp}, request, (Object)listener);
    }

    public void createFileVersion(String fileId, FileMetadata fi, OSDRequest request, CreateFileVersionCallback listener) {
        this.enqueueOperation(fileId, 11, new Object[]{fileId, fi}, request, (Object)listener);
    }

    public void getFileIDList(OSDRequest request, GetFileIDListCallback listener) {
        this.enqueueOperation("foobar", 13, new Object[0], request, (Object)listener);
    }

    @Override
    public void enqueueOperation(int stageOp, Object[] args, OSDRequest request, Object callback) {
        this.notifyCrashed(new Exception("wrong method call: use enqueueOperation(String fileId, int stageOp, Object[] args, OSDRequest request, Object callback) instead!"));
    }

    public void enqueueOperation(String fileId, int stageOp, Object[] args, OSDRequest request, Object callback) {
        this.enqueueOperation(fileId, stageOp, args, request, null, callback);
    }

    public void enqueueOperation(String fileId, int stageOp, Object[] args, OSDRequest request, ReusableBuffer createdViewBuffer, Object callback) {
        int taskId = this.getTaskId(fileId);
        this.storageThreads[taskId].enqueueOperation(stageOp, args, request, createdViewBuffer, callback);
    }

    @Override
    public void run() {
        for (StorageThread th : this.storageThreads) {
            th.start();
        }
    }

    @Override
    public void shutdown() {
        for (StorageThread th : this.storageThreads) {
            th.shutdown();
        }
    }

    @Override
    public void waitForStartup() throws Exception {
        for (StorageThread th : this.storageThreads) {
            th.waitForStartup();
        }
    }

    @Override
    public void waitForShutdown() throws Exception {
        for (StorageThread th : this.storageThreads) {
            th.waitForShutdown();
        }
    }

    private int getTaskId(String fileId) {
        assert (fileId != null);
        int hash = fileId.hashCode();
        if (hash == Integer.MIN_VALUE) {
            return 0;
        }
        int key = Math.abs(hash);
        int index = key % this.storageThreads.length;
        return index;
    }

    @Override
    protected void processMethod(Stage.StageRequest method) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getQueueLength() {
        int len = 0;
        for (StorageThread th : this.storageThreads) {
            len += th.getQueueLength();
        }
        return len;
    }

    public static interface GetFileIDListCallback {
        public void createGetFileIDListComplete(ArrayList<String> var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface CreateFileVersionCallback {
        public void createFileVersionComplete(long var1, RPC.RPCHeader.ErrorResponse var3);
    }

    public static interface GetObjectListCallback {
        public void getObjectSetComplete(ObjectSet var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface InternalGetReplicaStateCallback {
        public void getReplicaStateComplete(OSD.ReplicaStatus var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface InternalGetMaxObjectNoCallback {
        public void maxObjectNoCompleted(long var1, long var3, long var5, RPC.RPCHeader.ErrorResponse var7);
    }

    public static interface InternalGetGmaxCallback {
        public void gmaxComplete(OSD.InternalGmax var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface CachesFlushedCallback {
        public void cachesFlushed(RPC.RPCHeader.ErrorResponse var1, FileMetadata var2);
    }

    public static interface DeleteObjectsCallback {
        public void deleteObjectsComplete(RPC.RPCHeader.ErrorResponse var1);
    }

    public static interface TruncateCallback {
        public void truncateComplete(GlobalTypes.OSDWriteResponse var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface WriteObjectCallback {
        public void writeComplete(GlobalTypes.OSDWriteResponse var1, RPC.RPCHeader.ErrorResponse var2);
    }

    public static interface GetFileSizeCallback {
        public void getFileSizeComplete(long var1, RPC.RPCHeader.ErrorResponse var3);
    }

    public static interface ReadObjectCallback {
        public void readComplete(ObjectInformation var1, RPC.RPCHeader.ErrorResponse var2);
    }
}

