/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.stages;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.common.uuids.Mapping;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.UDPMessage;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.vivaldi.VivaldiNode;
import org.xtreemfs.osd.vivaldi.ZipfGenerator;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class VivaldiStage
extends Stage {
    private static final int STAGEOP_ASYNC_PING = 1;
    private static final int STAGEOP_SYNC_PING = 2;
    private long lastCheck;
    private final OSDRequestDispatcher master;
    private final DIRClient dirClient;
    private HashMap<InetSocketAddress, SentRequest> sentRequests;
    private HashMap<InetSocketAddress, VivaldiRetry> toBeRetried;
    private VivaldiNode vNode;
    private long nextRecalculationInMS;
    private long nextTimerRunInMS;
    private LinkedList<KnownOSD> knownOSDs;
    private long vivaldiIterations;
    private ZipfGenerator rankGenerator;
    private final double ZIPF_GENERATOR_SKEW = 0.5;
    private final int MAX_RETRIES_FOR_A_REQUEST;
    private final int RECALCULATION_INTERVAL;
    private final int RECALCULATION_EPSILON;
    private final int ITERATIONS_BEFORE_UPDATING;
    private final int MAX_REQUEST_TIMEOUT_IN_MS;
    private final int TIMER_INTERVAL_IN_MS;

    public VivaldiStage(OSDRequestDispatcher master, int maxRequestsQueueLength) {
        super("VivaldiSt", maxRequestsQueueLength);
        this.master = master;
        this.dirClient = master.getDIRClient();
        this.sentRequests = new HashMap();
        this.toBeRetried = new HashMap();
        this.vNode = new VivaldiNode();
        this.MAX_RETRIES_FOR_A_REQUEST = master.getConfig().getVivaldiMaxRetriesForARequest();
        this.RECALCULATION_INTERVAL = master.getConfig().getVivaldiRecalculationInterval();
        this.RECALCULATION_EPSILON = master.getConfig().getVivaldiRecalculationEpsilon();
        this.ITERATIONS_BEFORE_UPDATING = master.getConfig().getVivaldiIterationsBeforeUpdating();
        this.MAX_REQUEST_TIMEOUT_IN_MS = master.getConfig().getVivaldiMaxRequestTimeout();
        this.TIMER_INTERVAL_IN_MS = master.getConfig().getVivaldiTimerInterval();
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, String.format("Coordinates initialized:(%.3f,%.3f)", this.vNode.getCoordinates().getXCoordinate(), this.vNode.getCoordinates().getYCoordinate()), new Object[0]);
        }
        this.knownOSDs = null;
        this.rankGenerator = null;
        this.lastCheck = 0L;
    }

    private void forceVivaldiRecalculation(GlobalTypes.VivaldiCoordinates coordinatesJ, ArrayList<Long> availableRTTs) {
        if (coordinatesJ != null && availableRTTs.size() > 0) {
            long minRTT = availableRTTs.get(0);
            StringBuilder strbRTTs = new StringBuilder(Long.toString(minRTT));
            for (int i = 1; i < availableRTTs.size(); ++i) {
                strbRTTs.append(",");
                strbRTTs.append(availableRTTs.get(i));
                if (availableRTTs.get(i) >= minRTT) continue;
                minRTT = availableRTTs.get(i);
            }
            this.vNode.recalculatePosition(coordinatesJ, minRTT, true);
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, String.format("Forced(%s):%d Viv:%.3f Own:(%.3f,%.3f) lE=%.3f Rem:(%.3f,%.3f) rE=%.3f", strbRTTs.toString(), minRTT, VivaldiNode.calculateDistance(this.vNode.getCoordinates(), coordinatesJ), this.vNode.getCoordinates().getXCoordinate(), this.vNode.getCoordinates().getYCoordinate(), this.vNode.getCoordinates().getLocalError(), coordinatesJ.getXCoordinate(), coordinatesJ.getYCoordinate(), coordinatesJ.getLocalError()), new Object[0]);
            }
        }
    }

    public void getVivaldiCoordinatesAsync(OSD.xtreemfs_pingMesssage coordinates, InetSocketAddress sender, OSDRequest request) {
        this.enqueueOperation(1, new Object[]{coordinates, sender}, request, null);
    }

    public void getVivaldiCoordinatesSync(OSD.xtreemfs_pingMesssage coordinates, OSDRequest request, VivaldiPingCallback listener) {
        this.enqueueOperation(2, new Object[]{coordinates}, request, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMethod(Stage.StageRequest method) {
        OSD.xtreemfs_pingMesssage msg = (OSD.xtreemfs_pingMesssage)method.getArgs()[0];
        if (method.getStageMethod() == 1) {
            try {
                InetSocketAddress sender = (InetSocketAddress)method.getArgs()[1];
                if (msg.getRequestResponse()) {
                    RPC.RPCHeader.RequestHeader rqHdr = RPC.RPCHeader.RequestHeader.newBuilder().setAuthData(RPCAuthentication.authNone).setUserCreds(RPCAuthentication.userService).setInterfaceId(30001).setProcId(60).build();
                    RPC.RPCHeader hdr = RPC.RPCHeader.newBuilder().setCallId(0).setMessageType(RPC.MessageType.RPC_REQUEST).setRequestHeader(rqHdr).build();
                    OSD.xtreemfs_pingMesssage response = OSD.xtreemfs_pingMesssage.newBuilder().setCoordinates(this.vNode.getCoordinates()).setRequestResponse(false).build();
                    this.master.sendUDPMessage(hdr, response, sender);
                }
                this.recalculateCoordinates(msg.getCoordinates(), sender);
            }
            catch (Exception ex) {
                Logging.logError(4, this, ex);
            }
            finally {
                method.getRequest().getRpcRequest().freeBuffers();
            }
        } else {
            VivaldiPingCallback callback = (VivaldiPingCallback)method.getCallback();
            callback.coordinatesCallback(this.vNode.getCoordinates(), null);
        }
    }

    protected void recalculateCoordinates(GlobalTypes.VivaldiCoordinates coordinatesJ, InetSocketAddress sender) {
        try {
            boolean coordinatesModified = false;
            SentRequest correspondingReq = this.sentRequests.remove(sender);
            if (correspondingReq != null) {
                boolean retryingDisabled;
                long now = System.currentTimeMillis();
                long estimatedRTT = now - correspondingReq.getSystemTime();
                if (estimatedRTT == 0L) {
                    estimatedRTT = 1L;
                }
                VivaldiRetry prevRetry = this.toBeRetried.get(sender);
                boolean retriedTraceVar = false;
                boolean forcedTraceVar = false;
                boolean bl = retryingDisabled = this.MAX_RETRIES_FOR_A_REQUEST <= 0;
                if (!this.vNode.recalculatePosition(coordinatesJ, estimatedRTT, retryingDisabled)) {
                    if (prevRetry == null) {
                        this.toBeRetried.put(sender, new VivaldiRetry(estimatedRTT));
                        retriedTraceVar = true;
                    } else {
                        prevRetry.addRTT(estimatedRTT);
                        prevRetry.setRetried(false);
                        if (prevRetry.numberOfRetries() > this.MAX_RETRIES_FOR_A_REQUEST) {
                            this.forceVivaldiRecalculation(coordinatesJ, prevRetry.getRTTs());
                            coordinatesModified = true;
                            forcedTraceVar = true;
                            this.toBeRetried.remove(sender);
                        } else {
                            retriedTraceVar = true;
                        }
                    }
                } else {
                    coordinatesModified = true;
                    if (prevRetry != null) {
                        this.toBeRetried.remove(sender);
                    }
                }
                if (!forcedTraceVar && Logging.isDebug()) {
                    Logging.logMessage(7, this, String.format("%s:%d Viv:%.3f Own:(%.3f,%.3f) lE=%.3f Rem:(%.3f,%.3f) rE=%.3f %s", retriedTraceVar ? "RETRY" : "RTT", estimatedRTT, VivaldiNode.calculateDistance(this.vNode.getCoordinates(), coordinatesJ), this.vNode.getCoordinates().getXCoordinate(), this.vNode.getCoordinates().getYCoordinate(), this.vNode.getCoordinates().getLocalError(), coordinatesJ.getXCoordinate(), coordinatesJ.getYCoordinate(), coordinatesJ.getLocalError(), sender.getHostName()), new Object[0]);
                }
            }
            if (this.knownOSDs != null && !this.knownOSDs.isEmpty()) {
                String strAddress = sender.getHostName() + ":" + sender.getPort();
                int sendingOSD = 0;
                boolean OSDfound = false;
                while (!OSDfound && sendingOSD < this.knownOSDs.size()) {
                    if (this.knownOSDs.get(sendingOSD).getStrAddress() != null && this.knownOSDs.get(sendingOSD).getStrAddress().equals(strAddress)) {
                        this.knownOSDs.get(sendingOSD).setCoordinates(coordinatesJ);
                        OSDfound = true;
                        continue;
                    }
                    ++sendingOSD;
                }
                if (coordinatesModified) {
                    LinkedList<KnownOSD> auxOSDList = new LinkedList<KnownOSD>();
                    for (int i = this.knownOSDs.size() - 1; i >= 0; --i) {
                        KnownOSD insertedOSD = this.knownOSDs.get(i);
                        double insertedOSDDistance = VivaldiNode.calculateDistance(insertedOSD.getCoordinates(), this.vNode.getCoordinates());
                        int j = 0;
                        boolean inserted = false;
                        while (!inserted && j < auxOSDList.size()) {
                            double prevOSDDistance = VivaldiNode.calculateDistance(((KnownOSD)auxOSDList.get(j)).getCoordinates(), this.vNode.getCoordinates());
                            if (insertedOSDDistance <= prevOSDDistance) {
                                auxOSDList.add(j, insertedOSD);
                                inserted = true;
                                continue;
                            }
                            ++j;
                        }
                        if (inserted) continue;
                        auxOSDList.add(insertedOSD);
                    }
                    this.knownOSDs = auxOSDList;
                } else if (OSDfound) {
                    KnownOSD kosd = this.knownOSDs.remove(sendingOSD);
                    kosd.setCoordinates(coordinatesJ);
                    double osdNewDistance = VivaldiNode.calculateDistance(coordinatesJ, this.vNode.getCoordinates());
                    int i = 0;
                    boolean inserted = false;
                    while (!inserted && i < this.knownOSDs.size()) {
                        double existingDistance = VivaldiNode.calculateDistance(this.knownOSDs.get(i).getCoordinates(), this.vNode.getCoordinates());
                        if (osdNewDistance <= existingDistance) {
                            this.knownOSDs.add(i, kosd);
                            inserted = true;
                            continue;
                        }
                        ++i;
                    }
                    if (!inserted) {
                        this.knownOSDs.add(kosd);
                    }
                }
            }
        }
        catch (Exception ex) {
            Logging.logError(3, this, ex);
        }
    }

    private void sendVivaldiRequest(InetSocketAddress osd, GlobalTypes.VivaldiCoordinates myCoordinates) {
        if (this.sentRequests.get(osd) == null) {
            RPC.RPCHeader.RequestHeader rqHdr = RPC.RPCHeader.RequestHeader.newBuilder().setAuthData(RPCAuthentication.authNone).setUserCreds(RPCAuthentication.userService).setInterfaceId(30001).setProcId(60).build();
            RPC.RPCHeader hdr = RPC.RPCHeader.newBuilder().setCallId(0).setMessageType(RPC.MessageType.RPC_REQUEST).setRequestHeader(rqHdr).build();
            OSD.xtreemfs_pingMesssage pingMsg = OSD.xtreemfs_pingMesssage.newBuilder().setCoordinates(myCoordinates).setRequestResponse(true).build();
            long systemTimeNow = System.currentTimeMillis();
            long localTimeNow = TimeSync.getLocalSystemTime();
            this.sentRequests.put(osd, new SentRequest(localTimeNow, systemTimeNow));
            try {
                this.master.sendUDPMessage(hdr, pingMsg, osd);
            }
            catch (IOException ex) {
                Logging.logError(3, this, ex);
            }
        }
    }

    private void maintainSentRequests() {
        long localNow = TimeSync.getLocalSystemTime();
        ArrayList<InetSocketAddress> removedRequests = new ArrayList<InetSocketAddress>();
        for (InetSocketAddress reqKey : this.sentRequests.keySet()) {
            if (localNow < this.sentRequests.get(reqKey).getLocalTime() + (long)this.MAX_REQUEST_TIMEOUT_IN_MS) continue;
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "OSD times out: " + reqKey.getHostName(), new Object[0]);
            }
            removedRequests.add(reqKey);
        }
        for (InetSocketAddress removed : removedRequests) {
            VivaldiRetry prevRetry = this.toBeRetried.get(removed);
            if (prevRetry == null) {
                this.toBeRetried.put(removed, new VivaldiRetry());
            } else {
                prevRetry.addTimeout();
                prevRetry.setRetried(false);
                if (prevRetry.numberOfRetries() > this.MAX_RETRIES_FOR_A_REQUEST) {
                    this.forceVivaldiRecalculation(null, prevRetry.getRTTs());
                    this.toBeRetried.remove(removed);
                }
            }
            this.sentRequests.remove(removed);
        }
    }

    private void executeTimer() {
        this.master.updateVivaldiCoordinates(this.vNode.getCoordinates());
        this.maintainSentRequests();
    }

    public void receiveVivaldiMessage(UDPMessage msg) {
        this.enqueueOperation(1, new Object[]{msg}, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKnownOSDs() {
        try {
            DIR.ServiceSet receivedOSDs = this.dirClient.xtreemfs_service_get_by_type(null, RPCAuthentication.authNone, RPCAuthentication.userService, DIR.ServiceType.SERVICE_TYPE_OSD);
            String ownUUID = this.master.getConfig().getUUID().toString();
            this.knownOSDs = new LinkedList();
            for (DIR.Service osd : receivedOSDs.getServicesList()) {
                String strCoords;
                if (ownUUID.equals(osd.getUuid()) || osd.getLastUpdatedS() == 0L || (strCoords = KeyValuePairs.getValue(osd.getData().getDataList(), "vivaldi_coordinates")) == null) continue;
                GlobalTypes.VivaldiCoordinates osdCoords = VivaldiNode.stringToCoordinates(strCoords);
                KnownOSD newOSD = new KnownOSD(osd.getUuid(), osdCoords);
                double insertedOSDDistance = VivaldiNode.calculateDistance(osdCoords, this.vNode.getCoordinates());
                int i = 0;
                boolean inserted = false;
                while (!inserted && i < this.knownOSDs.size()) {
                    double oldOSDDistance = VivaldiNode.calculateDistance(this.knownOSDs.get(i).getCoordinates(), this.vNode.getCoordinates());
                    if (insertedOSDDistance <= oldOSDDistance) {
                        this.knownOSDs.add(i, newOSD);
                        inserted = true;
                        continue;
                    }
                    ++i;
                }
                if (inserted) continue;
                this.knownOSDs.add(newOSD);
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "Updating list of known OSDs (size: " + this.knownOSDs.size() + ")", new Object[0]);
            }
        }
        catch (Exception exc) {
            Logging.logMessage(3, this, "Error while updating known OSDs: " + exc, new Object[0]);
            this.knownOSDs = new LinkedList();
        }
        finally {
            if (this.rankGenerator == null) {
                this.rankGenerator = new ZipfGenerator(this.knownOSDs.size(), 0.5);
            } else {
                this.rankGenerator.setSize(this.knownOSDs.size());
            }
            this.sentRequests.clear();
            this.toBeRetried.clear();
        }
    }

    private void iterateVivaldi() {
        if (this.vivaldiIterations % (long)this.ITERATIONS_BEFORE_UPDATING == 1L) {
            this.updateKnownOSDs();
        }
        if (this.knownOSDs != null && !this.knownOSDs.isEmpty()) {
            if (this.toBeRetried.size() > 0) {
                for (InetSocketAddress addr : this.toBeRetried.keySet()) {
                    if (this.toBeRetried.get(addr).hasBeenRetried()) continue;
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, this, "Retrying: " + addr.getHostName(), new Object[0]);
                    }
                    this.sendVivaldiRequest(addr, this.vNode.getCoordinates());
                    this.toBeRetried.get(addr).setRetried(true);
                }
            } else {
                int chosenIndex = this.rankGenerator.next();
                KnownOSD chosenOSD = this.knownOSDs.get(chosenIndex);
                try {
                    ServiceUUID sUUID = new ServiceUUID(chosenOSD.getUUID());
                    sUUID.resolve("pbrpcu");
                    InetSocketAddress osdAddr = null;
                    Mapping[] serviceMappings = sUUID.getMappings();
                    for (int mapIt = 0; osdAddr == null && mapIt < serviceMappings.length; ++mapIt) {
                        if (!serviceMappings[mapIt].protocol.equals("pbrpcu")) continue;
                        osdAddr = serviceMappings[mapIt].resolvedAddr;
                        if (Logging.isDebug()) {
                            Logging.logMessage(7, this, "Recalculating against: " + chosenOSD.getUUID(), new Object[0]);
                        }
                        chosenOSD.setStrAddress(osdAddr.getAddress().getHostAddress() + ":" + osdAddr.getPort());
                        this.sendVivaldiRequest(osdAddr, this.vNode.getCoordinates());
                    }
                }
                catch (UnknownUUIDException unke) {
                    Logging.logMessage(3, this, "Unknown UUID: " + chosenOSD.getUUID(), new Object[0]);
                }
                catch (Exception e) {
                    Logging.logMessage(3, this, "Error detected while iterating Vivaldi", new Object[0]);
                }
            }
        }
        this.vivaldiIterations = (this.vivaldiIterations + 1L) % Long.MAX_VALUE;
    }

    @Override
    public void run() {
        this.notifyStarted();
        this.vivaldiIterations = 0L;
        this.nextRecalculationInMS = -1L;
        this.nextTimerRunInMS = -1L;
        while (!this.quit) {
            try {
                long pollTimeoutInMS = this.checkTimer();
                Stage.StageRequest op = (Stage.StageRequest)this.q.poll(pollTimeoutInMS, TimeUnit.MILLISECONDS);
                if (op == null) continue;
                this.processMethod(op);
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (Throwable ex) {
                Logging.logMessage(3, this, "Error detected: " + ex, new Object[0]);
                this.notifyCrashed(ex);
                break;
            }
        }
        this.notifyStopped();
    }

    private long checkTimer() {
        long now = TimeSync.getLocalSystemTime();
        long elapsedTime = this.lastCheck > 0L ? now - this.lastCheck : 0L;
        this.lastCheck = now;
        this.nextRecalculationInMS -= elapsedTime;
        this.nextTimerRunInMS -= elapsedTime;
        if (this.nextTimerRunInMS <= 0L) {
            this.executeTimer();
            this.nextTimerRunInMS = this.TIMER_INTERVAL_IN_MS;
        }
        if (this.nextRecalculationInMS <= 0L) {
            this.iterateVivaldi();
            this.nextRecalculationInMS = (long)(this.RECALCULATION_INTERVAL - this.RECALCULATION_EPSILON) + (long)((double)(2 * this.RECALCULATION_EPSILON) * Math.random());
        }
        long nextCheck = this.nextTimerRunInMS > this.nextRecalculationInMS ? this.nextRecalculationInMS : this.nextTimerRunInMS;
        return nextCheck;
    }

    public class SentRequest {
        private long localTime;
        private long systemTime;

        public SentRequest(long localTime, long systemTime) {
            this.localTime = localTime;
            this.systemTime = systemTime;
        }

        public long getLocalTime() {
            return this.localTime;
        }

        public long getSystemTime() {
            return this.systemTime;
        }
    }

    public class VivaldiRetry {
        private ArrayList<Long> prevRTTs = new ArrayList();
        private int numRetries;
        private boolean retried;

        public VivaldiRetry() {
            this.numRetries = 1;
            this.retried = false;
        }

        public VivaldiRetry(long firstRTT) {
            this.prevRTTs.add(firstRTT);
            this.numRetries = 1;
            this.retried = false;
        }

        public ArrayList<Long> getRTTs() {
            return this.prevRTTs;
        }

        public void addRTT(long newRTT) {
            this.prevRTTs.add(newRTT);
            ++this.numRetries;
        }

        public void addTimeout() {
            ++this.numRetries;
        }

        public int numberOfRetries() {
            return this.numRetries;
        }

        public void setRetried(boolean p) {
            this.retried = p;
        }

        public boolean hasBeenRetried() {
            return this.retried;
        }
    }

    public class KnownOSD {
        private String uuid;
        private String strAddress;
        private GlobalTypes.VivaldiCoordinates coordinates;

        public KnownOSD(String uuid, GlobalTypes.VivaldiCoordinates coordinates) {
            this.uuid = uuid;
            this.strAddress = null;
            this.coordinates = coordinates;
        }

        public String getUUID() {
            return this.uuid;
        }

        public GlobalTypes.VivaldiCoordinates getCoordinates() {
            return this.coordinates;
        }

        public String getStrAddress() {
            return this.strAddress;
        }

        public void setStrAddress(String strAddress) {
            this.strAddress = strAddress;
        }

        public void setCoordinates(GlobalTypes.VivaldiCoordinates newCoordinates) {
            this.coordinates = newCoordinates;
        }
    }

    public static interface VivaldiPingCallback {
        public void coordinatesCallback(GlobalTypes.VivaldiCoordinates var1, RPC.RPCHeader.ErrorResponse var2);
    }
}

