/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.stages.DeletionStage;
import org.xtreemfs.osd.stages.PreprocStage;
import org.xtreemfs.osd.storage.StorageLayout;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class CleanupThread
extends LifeCycleThread {
    public static final String DEFAULT_RESTORE_PATH = "lost+found";
    public static final String STATUS_FORMAT = "files checked: %8d   zombies: %8d   running since: %s";
    public static final String STOPPED_FORMAT = "not running, last check started %s";
    public static final String DEAD_VOLUME_FORMAT = "volume %s is dead - not registered at directory service";
    public static final String VOLUME_RESULT_FORMAT = "volume %s had %8d zombies - out of %8d files checked";
    public static final String ERROR_FORMAT = "ERROR: cannot check volume %s , reason: %s";
    public static final String ZOMBIES_RESTORED_FORMAT = "%8d zombies restored to 'lost+found' on volume %s";
    public static final String ZOMBIES_DELETED_FORMAT = "%8d zombies deleted from %s volume %s";
    public static final String ZOMBIE_DELETE_ERROR_FORMAT = "%s could not be deleted, because: %s";
    private final OSDRequestDispatcher master;
    private volatile boolean isRunning;
    private volatile boolean quit;
    private volatile boolean removeZombies;
    private volatile boolean removeDeadVolumes;
    private volatile boolean lostAndFound;
    private volatile boolean removeMetadata;
    private volatile int metaDataTimeoutS;
    private final List<String> results;
    private final StorageLayout layout;
    private volatile long filesChecked;
    private final AtomicLong zombies = new AtomicLong(0L);
    private volatile long startTime;
    private RPC.UserCredentials uc;
    final ServiceUUID localUUID;
    final MRCServiceClient mrcClient;
    private final AtomicLong openDeletes;

    public CleanupThread(OSDRequestDispatcher master, StorageLayout layout) {
        super("CleanupThr");
        this.master = master;
        this.isRunning = false;
        this.quit = false;
        this.layout = layout;
        this.results = Collections.synchronizedList(new LinkedList());
        this.localUUID = master.getConfig().getUUID();
        this.startTime = 0L;
        this.filesChecked = 0L;
        this.mrcClient = new MRCServiceClient(master.getRPCClient(), null);
        this.openDeletes = new AtomicLong(0L);
        this.removeMetadata = false;
        this.metaDataTimeoutS = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanupStart(boolean removeZombies, boolean removeDeadVolumes, boolean lostAndFound, boolean removeMetaData, int metaDataTimeoutS, RPC.UserCredentials uc) {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            if (this.isRunning) {
                return false;
            }
            this.removeZombies = removeZombies;
            this.removeDeadVolumes = removeDeadVolumes;
            this.lostAndFound = lostAndFound;
            this.removeMetadata = removeMetaData;
            this.metaDataTimeoutS = metaDataTimeoutS;
            this.uc = uc;
            this.isRunning = true;
            this.notify();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupStop() {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            if (this.isRunning) {
                this.isRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getResult() {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            return this.results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            String d = DateFormat.getDateInstance().format(new Date(this.startTime));
            assert (d != null);
            if (this.isRunning) {
                return String.format(STATUS_FORMAT, this.filesChecked, this.zombies.get(), d);
            }
            return String.format(STOPPED_FORMAT, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.quit = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.notifyStarted();
        try {
            do {
                CleanupThread cleanupThread = this;
                synchronized (cleanupThread) {
                    if (!this.isRunning) {
                        this.wait();
                    }
                    if (this.quit) {
                        break;
                    }
                }
                this.runCleanup();
                this.isRunning = false;
            } while (!this.quit);
        }
        catch (Throwable thr) {
            this.notifyCrashed(thr);
        }
        this.notifyStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCleanup() throws Throwable {
        StorageLayout.FileList l = null;
        this.results.clear();
        this.filesChecked = 0L;
        this.zombies.set(0L);
        this.startTime = TimeSync.getGlobalTime();
        do {
            RPCResponse r;
            Map<String, StorageLayout.FileData> zombieFiles;
            l = this.layout.getFileList(l, 4096);
            Hashtable perVolume = new Hashtable();
            Hashtable<Volume, LinkedList<String>> metaOnlyPerVolume = new Hashtable<Volume, LinkedList<String>>();
            for (String fileName : l.files.keySet()) {
                ++this.filesChecked;
                String[] tmp = fileName.split(":");
                Volume v = new Volume(tmp[0]);
                String fileId = tmp[1];
                Hashtable<Volume, LinkedList<String>> target = l.files.get((Object)fileName).metaDataOnly ? metaOnlyPerVolume : perVolume;
                LinkedList<String> flist = (LinkedList<String>)target.get(v);
                if (flist == null) {
                    flist = new LinkedList<String>();
                    target.put(v, flist);
                }
                flist.add(fileId);
            }
            CleanupThread i$ = this;
            synchronized (i$) {
                if (!this.isRunning) {
                    break;
                }
            }
            Hashtable<Volume, Map<String, StorageLayout.FileData>> zombieFilesPerVolume = new Hashtable<Volume, Map<String, StorageLayout.FileData>>();
            for (Volume volume : perVolume.keySet()) {
                block39: {
                    zombieFiles = new Hashtable();
                    try {
                        DIR.ServiceSet s = this.master.getDIRClient().xtreemfs_service_get_by_uuid(null, RPCAuthentication.authNone, RPCAuthentication.userService, volume.id);
                        if (s.getServicesCount() == 0) {
                            this.results.add(String.format(DEAD_VOLUME_FORMAT, volume.id));
                            volume.dead();
                            break block39;
                        }
                        boolean cowEnabled = false;
                        String mrcUUID = null;
                        for (GlobalTypes.KeyValuePair kvp : s.getServices(0).getData().getDataList()) {
                            if (!kvp.getKey().equals("mrc")) continue;
                            mrcUUID = kvp.getValue();
                        }
                        volume.mrc = new ServiceUUID(mrcUUID);
                        r = this.mrcClient.xtreemfs_check_file_exists(volume.mrc.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, volume.id, (List)perVolume.get(volume), this.localUUID.toString());
                        MRC.xtreemfs_check_file_existsResponse response = r.get();
                        r.freeBuffers();
                        if (!response.getVolumeExists()) {
                            this.results.add(String.format(DEAD_VOLUME_FORMAT, volume.id));
                            volume.dead();
                            break block39;
                        }
                        List files = (List)perVolume.get(volume);
                        final AtomicInteger numZombies = new AtomicInteger(0);
                        final AtomicInteger openOFTChecks = new AtomicInteger(0);
                        for (int i = 0; i < files.size(); ++i) {
                            MRC.xtreemfs_check_file_existsResponse.FILE_STATE fileState = response.getFileStates(i);
                            if (fileState != MRC.xtreemfs_check_file_existsResponse.FILE_STATE.ABANDONED && fileState != MRC.xtreemfs_check_file_existsResponse.FILE_STATE.DELETED) continue;
                            final boolean abandoned = fileState == MRC.xtreemfs_check_file_existsResponse.FILE_STATE.ABANDONED;
                            final String fName = volume.id + ":" + (String)files.get(i);
                            final StorageLayout.FileData fData = l.files.get(fName);
                            openOFTChecks.incrementAndGet();
                            this.master.getPreprocStage().checkDeleteOnClose((String)files.get(i), new PreprocStage.DeleteOnCloseCallback(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void deleteOnCloseResult(boolean isDeleteOnClose, RPC.RPCHeader.ErrorResponse error) {
                                    if (!isDeleteOnClose && !abandoned) {
                                        numZombies.incrementAndGet();
                                        CleanupThread.this.zombies.incrementAndGet();
                                        zombieFiles.put(fName, fData);
                                    }
                                    if (!isDeleteOnClose && abandoned) {
                                        CleanupThread.this.deleteFile(fName, false);
                                    }
                                    if (openOFTChecks.decrementAndGet() <= 0) {
                                        AtomicInteger atomicInteger = openOFTChecks;
                                        synchronized (atomicInteger) {
                                            openOFTChecks.notify();
                                        }
                                    }
                                }
                            });
                        }
                        AtomicInteger atomicInteger = openOFTChecks;
                        synchronized (atomicInteger) {
                            while (openOFTChecks.get() > 0) {
                                openOFTChecks.wait();
                            }
                        }
                        this.results.add(String.format(VOLUME_RESULT_FORMAT, volume.id, numZombies.get(), files.size()));
                    }
                    catch (Exception ex) {
                        this.results.add(String.format(ERROR_FORMAT, volume.id, OutputUtils.stackTraceToString(ex)));
                    }
                }
                if (volume.isDead()) {
                    List files = (List)perVolume.get(volume);
                    for (int i = 0; i < files.size(); ++i) {
                        String fName = volume.id + ":" + (String)files.get(i);
                        StorageLayout.FileData fData = l.files.get(fName);
                        zombieFiles.put(fName, fData);
                    }
                }
                if (zombieFiles.size() == 0) continue;
                zombieFilesPerVolume.put(volume, zombieFiles);
            }
            Iterator i$2 = this;
            synchronized (i$2) {
                if (!this.isRunning) {
                    break;
                }
            }
            for (Volume volume : zombieFilesPerVolume.keySet()) {
                if (!volume.isDead() && this.lostAndFound) {
                    zombieFiles = (Map)zombieFilesPerVolume.get(volume);
                    for (String fileName : zombieFiles.keySet()) {
                        StorageLayout.FileData data = (StorageLayout.FileData)zombieFiles.get(fileName);
                        if (data.metaDataOnly) continue;
                        r = this.mrcClient.xtreemfs_restore_file(volume.mrc.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, DEFAULT_RESTORE_PATH, fileName, data.size, this.localUUID.toString(), Integer.valueOf(String.valueOf(data.objectSize)));
                        r.get();
                        r.freeBuffers();
                    }
                    this.results.add(String.format(ZOMBIES_RESTORED_FORMAT, zombieFiles.keySet().size(), volume.id));
                    continue;
                }
                if ((!volume.isDead() || !this.removeDeadVolumes) && (volume.isDead() || !this.removeZombies)) continue;
                zombieFiles = (Map)zombieFilesPerVolume.get(volume);
                boolean cowEnabled = false;
                for (String fileName : zombieFiles.keySet()) {
                    this.deleteFile(fileName, false);
                }
                this.results.add(String.format(ZOMBIES_DELETED_FORMAT, zombieFiles.keySet().size(), volume.isDead() ? "dead" : "existing", volume.id));
            }
            if (this.removeMetadata) {
                for (Volume volume : metaOnlyPerVolume.keySet()) {
                    boolean cowEnabled = false;
                    List metaDataDirs = (List)metaOnlyPerVolume.get(volume);
                    for (String fileId : metaDataDirs) {
                        String fName = volume.id + ":" + fileId;
                        this.deleteFile(fName, false);
                    }
                }
            }
            Object object = this.openDeletes;
            synchronized (object) {
                while (this.openDeletes.get() > 0L) {
                    this.openDeletes.wait();
                }
            }
            object = this;
            synchronized (object) {
                if (!this.isRunning) {
                    break;
                }
            }
        } while (l.hasMore);
    }

    public static String getRegex(String format) {
        return format.replaceAll("\\+", ".").replaceAll("%8d", "(\\\\s*\\\\d+)").replaceAll("%s", "([\\\\S\\\\p{Punct}]+)");
    }

    private void deleteFile(final String fileName, boolean cowEnabled) {
        boolean deleteMetadata;
        try {
            deleteMetadata = this.checkXLocVersionStateTimeout(fileName);
        }
        catch (IOException e) {
            deleteMetadata = false;
        }
        this.openDeletes.incrementAndGet();
        this.master.getDeletionStage().deleteObjects(fileName, null, cowEnabled, null, deleteMetadata, new DeletionStage.DeleteObjectsCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteComplete(RPC.RPCHeader.ErrorResponse error) {
                if (error != null) {
                    CleanupThread.this.results.add(String.format(CleanupThread.ZOMBIE_DELETE_ERROR_FORMAT, fileName, error.getErrorMessage()));
                }
                if (CleanupThread.this.openDeletes.decrementAndGet() <= 0L) {
                    AtomicLong atomicLong = CleanupThread.this.openDeletes;
                    synchronized (atomicLong) {
                        CleanupThread.this.openDeletes.notifyAll();
                    }
                }
            }
        });
    }

    private boolean checkXLocVersionStateTimeout(String fileName) throws IOException {
        if (!this.removeMetadata) {
            return false;
        }
        if (this.metaDataTimeoutS == 0) {
            return true;
        }
        if (this.metaDataTimeoutS > 0) {
            long toTimeMs = TimeSync.getGlobalTime() - (long)(this.metaDataTimeoutS * 1000);
            OSD.XLocSetVersionState vs = this.layout.getXLocSetVersionState(fileName);
            return !vs.hasModifiedTime() || vs.getModifiedTime() < toTimeMs;
        }
        return false;
    }

    public class Volume {
        final String id;
        ServiceUUID mrc = null;
        boolean dead = false;
        boolean deleted = false;

        Volume(String volId) {
            this.id = volId;
        }

        void dead() {
            this.dead = true;
        }

        boolean isDead() {
            return this.dead;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Volume)) {
                return false;
            }
            return this.id.equals(((Volume)obj).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

