/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.RAID0Impl;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.storage.FileMetadata;
import org.xtreemfs.osd.storage.StorageLayout;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;

public class CleanupVersionsThread
extends LifeCycleThread {
    public static final String STATUS_FORMAT = "files checked: %8d   versions deleted: %8d   running since: %s";
    public static final String STOPPED_FORMAT = "not running, last check started %s";
    private final OSDRequestDispatcher master;
    private volatile boolean isRunning;
    private volatile boolean quit;
    private final StorageLayout layout;
    private volatile long filesChecked;
    private volatile long versionsRemoved;
    private volatile long startTime;
    private RPC.UserCredentials uc;
    final ServiceUUID localUUID;

    public CleanupVersionsThread(OSDRequestDispatcher master, StorageLayout layout) {
        super("CleanupVThr");
        this.master = master;
        this.isRunning = false;
        this.quit = false;
        this.layout = layout;
        this.localUUID = master.getConfig().getUUID();
        this.startTime = 0L;
        this.filesChecked = 0L;
        this.versionsRemoved = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanupStart(RPC.UserCredentials uc) {
        CleanupVersionsThread cleanupVersionsThread = this;
        synchronized (cleanupVersionsThread) {
            if (this.isRunning) {
                return false;
            }
            this.uc = uc;
            this.isRunning = true;
            this.notify();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupStop() {
        CleanupVersionsThread cleanupVersionsThread = this;
        synchronized (cleanupVersionsThread) {
            if (this.isRunning) {
                this.isRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        CleanupVersionsThread cleanupVersionsThread = this;
        synchronized (cleanupVersionsThread) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        CleanupVersionsThread cleanupVersionsThread = this;
        synchronized (cleanupVersionsThread) {
            String d = DateFormat.getDateInstance().format(new Date(this.startTime));
            assert (d != null);
            if (this.isRunning) {
                return String.format(STATUS_FORMAT, this.filesChecked, this.versionsRemoved, d);
            }
            return String.format(STOPPED_FORMAT, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        CleanupVersionsThread cleanupVersionsThread = this;
        synchronized (cleanupVersionsThread) {
            this.quit = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.notifyStarted();
        try {
            do {
                CleanupVersionsThread cleanupVersionsThread = this;
                synchronized (cleanupVersionsThread) {
                    if (!this.isRunning) {
                        this.wait();
                    }
                    if (this.quit) {
                        break;
                    }
                }
                StorageLayout.FileList l = null;
                this.filesChecked = 0L;
                this.startTime = TimeSync.getGlobalTime();
                MRCServiceClient mrcClient = new MRCServiceClient(this.master.getRPCClient(), null);
                Hashtable<Volume, LinkedList<String>> perVolume = new Hashtable<Volume, LinkedList<String>>();
                do {
                    l = this.layout.getFileList(l, 4096);
                    for (String fileName : l.files.keySet()) {
                        Object s;
                        ++this.filesChecked;
                        String[] tmp = fileName.split(":");
                        String volId = tmp[0];
                        String fileId = tmp[1];
                        Volume vol = new Volume(volId);
                        LinkedList<String> flist = (LinkedList<String>)perVolume.get(vol);
                        if (flist == null) {
                            s = this.master.getDIRClient().xtreemfs_service_get_by_uuid(null, RPCAuthentication.authNone, RPCAuthentication.userService, vol.id);
                            if (((DIR.ServiceSet)s).getServicesCount() == 0) {
                                Logging.logMessage(4, Logging.Category.misc, this, "could not retrieve volume information for '%s' from DIR", vol.id);
                                continue;
                            }
                            String volName = ((DIR.ServiceSet)s).getServices(0).getName();
                            vol.mrc = new ServiceUUID(KeyValuePairs.getValue(((DIR.ServiceSet)s).getServices(0).getData().getDataList(), "mrc"));
                            RPCResponse<MRC.getxattrResponse> tsResponse = null;
                            String ts = null;
                            try {
                                tsResponse = mrcClient.getxattr(vol.mrc.getAddress(), RPCAuthentication.authNone, this.uc, MRC.getxattrRequest.newBuilder().setVolumeName(volName).setPath("").setName("xtreemfs.snapshot_time").build());
                                ts = tsResponse.get().getValue();
                                StringTokenizer st = new StringTokenizer(ts);
                                long[] tsArray = new long[st.countTokens()];
                                for (int i = 0; i < tsArray.length; ++i) {
                                    tsArray[i] = Long.parseLong(st.nextToken());
                                }
                                vol.timestamps = tsArray;
                                flist = new LinkedList<String>();
                                perVolume.put(vol, flist);
                            }
                            finally {
                                if (tsResponse != null) {
                                    tsResponse.freeBuffers();
                                }
                            }
                        }
                        flist.add(fileId);
                        s = this;
                        synchronized (s) {
                            if (!this.isRunning) {
                                break;
                            }
                        }
                    }
                    Iterator i$ = this;
                    synchronized (i$) {
                        if (!this.isRunning) {
                            break;
                        }
                    }
                } while (l.hasMore);
                block24: for (Map.Entry entry : perVolume.entrySet()) {
                    long[] timestamps = ((Volume)entry.getKey()).timestamps;
                    List files = (List)entry.getValue();
                    for (String fileId : files) {
                        fileId = ((Volume)entry.getKey()).id + ":" + fileId;
                        FileMetadata md = this.layout.getFileMetadataNoCaching(RAID0Impl.getPolicy(GlobalTypes.Replica.newBuilder().setReplicationFlags(0).setStripingPolicy(GlobalTypes.StripingPolicy.newBuilder().setType(GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0).setStripeSize(128).setWidth(1).build()).build(), 0), fileId);
                        Map<Integer, Set<Integer>> versionsToDelete = md.getVersionTable().cleanup(timestamps);
                        for (Map.Entry<Integer, Set<Integer>> v : versionsToDelete.entrySet()) {
                            for (int version : v.getValue()) {
                                if (md.getLatestObjectVersion(v.getKey().intValue()) == (long)version) continue;
                                this.layout.deleteObject(fileId, md, v.getKey().intValue(), version);
                            }
                        }
                        if (versionsToDelete.size() != 0) {
                            md.getVersionTable().save();
                        }
                        CleanupVersionsThread cleanupVersionsThread2 = this;
                        synchronized (cleanupVersionsThread2) {
                            if (!this.isRunning) {
                                continue block24;
                            }
                        }
                    }
                }
                CleanupVersionsThread cleanupVersionsThread3 = this;
                synchronized (cleanupVersionsThread3) {
                    if (!this.isRunning) {
                        break;
                    }
                }
                this.isRunning = false;
            } while (!this.quit);
        }
        catch (Exception thr) {
            Logging.logError(3, this, thr);
        }
        this.notifyStopped();
    }

    public class Volume {
        final String id;
        ServiceUUID mrc = null;
        long[] timestamps;

        Volume(String volId) {
            this.id = volId;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Volume)) {
                return false;
            }
            return this.id.equals(((Volume)obj).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

