/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

public class CowPolicy {
    public static final CowPolicy PolicyNoCow = new CowPolicy(cowMode.NO_COW);
    private final cowMode mode;
    private long initialObjectCount;
    private byte[] cowFlags;

    public CowPolicy(cowMode mode) {
        this.mode = mode;
    }

    public void initCowFlagsIfRequired(long objectCount) {
        if (this.mode == cowMode.COW_ONCE && this.cowFlags == null) {
            assert (objectCount / 8L < Integer.MAX_VALUE) : "number of objects for COW_ONCE file (" + objectCount + ") exceeds limit (" + -8 + ")";
            int fieldLen = (int)Math.ceil((double)objectCount / 8.0);
            this.cowFlags = new byte[fieldLen];
            this.initialObjectCount = objectCount;
        }
    }

    private boolean requiresCow(int objectNumber) {
        assert (this.mode == cowMode.COW_ONCE);
        assert (this.cowFlags != null);
        if ((long)objectNumber >= this.initialObjectCount) {
            return false;
        }
        int field = objectNumber / 8;
        int bit = objectNumber % 8;
        return (this.cowFlags[field] & 1 << bit) == 0;
    }

    public boolean isCOW(int objectNumber) {
        return this.mode != cowMode.NO_COW && (this.mode == cowMode.ALWAYS_COW || this.requiresCow(objectNumber));
    }

    public boolean cowEnabled() {
        return this.mode != cowMode.NO_COW;
    }

    public void objectChanged(int objectNumber) {
        if (this.mode == cowMode.COW_ONCE && (long)objectNumber < this.initialObjectCount) {
            assert (this.cowFlags != null);
            int field = objectNumber / 8;
            int bit = objectNumber % 8;
            this.cowFlags[field] = (byte)(this.cowFlags[field] | 1 << bit);
        }
    }

    public static enum cowMode {
        NO_COW,
        COW_ONCE,
        ALWAYS_COW;

    }
}

